/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import javax.annotation.concurrent.GuardedBy;
import jmri.implementation.AbstractTurnout;
import jmri.jmrix.lenz.FeedbackItem;
import jmri.jmrix.lenz.XNetListener;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XNetTurnout
extends AbstractTurnout
implements XNetListener {
    protected static final int OFFSENT = 1;
    protected static final int COMMANDSENT = 2;
    protected static final int STATUSREQUESTSENT = 4;
    protected static final int QUEUEDMESSAGE = 8;
    protected static final int IDLE = 0;
    protected int internalState = 0;
    static String[] modeNames = null;
    static int[] modeValues = null;
    @GuardedBy(value="this")
    protected int _mThrown = 4;
    @GuardedBy(value="this")
    protected int _mClosed = 2;
    protected int mNumber;
    final XNetTurnoutStateListener _stateListener;
    @GuardedBy(value="this")
    protected final Queue<RequestMessage> requestList;
    @GuardedBy(value="this")
    protected RequestMessage lastMsg = null;
    protected final String _prefix;
    protected final XNetTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(XNetTurnout.class);

    public XNetTurnout(String prefix, int pNumber, XNetTrafficController controller) {
        super(String.valueOf(prefix) + "T" + pNumber);
        this.tc = controller;
        this._prefix = prefix;
        this.mNumber = pNumber;
        this.requestList = new LinkedList<RequestMessage>();
        this._validFeedbackTypes |= 0x4A;
        this._activeFeedbackType = 8;
        XNetTurnout.setModeInformation(this._validFeedbackNames, this._validFeedbackModes);
        this._validFeedbackNames = XNetTurnout.getModeNames();
        this._validFeedbackModes = XNetTurnout.getModeValues();
        this._stateListener = new XNetTurnoutStateListener(this);
        this.addPropertyChangeListener(this._stateListener);
        this.tc.getFeedbackMessageCache().requestCachedStateFromLayout(this);
    }

    private static synchronized void setModeInformation(String[] feedbackNames, int[] feedbackModes) {
        if (modeNames == null) {
            if (feedbackNames.length != feedbackModes.length) {
                log.error("int and string feedback arrays different length");
            }
            modeNames = Arrays.copyOf(feedbackNames, feedbackNames.length + 3);
            modeValues = Arrays.copyOf(feedbackModes, feedbackNames.length + 3);
            XNetTurnout.modeNames[feedbackNames.length] = "MONITORING";
            XNetTurnout.modeValues[feedbackNames.length] = 8;
            XNetTurnout.modeNames[feedbackNames.length + 1] = "EXACT";
            XNetTurnout.modeValues[feedbackNames.length + 1] = 2;
            XNetTurnout.modeNames[feedbackNames.length + 2] = "SIGNAL";
            XNetTurnout.modeValues[feedbackNames.length + 2] = 64;
        }
    }

    static int[] getModeValues() {
        return modeValues;
    }

    static String[] getModeNames() {
        return modeNames;
    }

    public int getNumber() {
        return this.mNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCommandedState(int s) {
        if (log.isDebugEnabled()) {
            log.debug("set commanded state for XNet turnout {} to {}", (Object)this.getSystemName(), (Object)s);
        }
        XNetTurnout xNetTurnout = this;
        synchronized (xNetTurnout) {
            this.newCommandedState(s);
        }
        this.myOperator = this.getTurnoutOperator();
        if (this.myOperator == null) {
            this.forwardCommandChangeToLayout(s);
            xNetTurnout = this;
            synchronized (xNetTurnout) {
                this.newKnownState(8);
            }
        } else {
            this.myOperator.start();
        }
    }

    @Override
    protected synchronized void forwardCommandChangeToLayout(int s) {
        if (s != this._mClosed && s != this._mThrown) {
            log.warn("Turnout {}: state {} not forwarded to layout.", (Object)this.mNumber, (Object)s);
            return;
        }
        XNetMessage msg = XNetMessage.getTurnoutCommandMsg(this.mNumber, (s & this._mClosed) != 0, (s & this._mThrown) != 0, true);
        if (this.getFeedbackMode() == 64) {
            msg.setTimeout(0);
            this.tc.sendXNetMessage(msg, null);
            this.sendOffMessage();
        } else {
            this.queueMessage(msg, 2, this);
        }
    }

    @Override
    protected void turnoutPushbuttonLockout(boolean _pushButtonLockout) {
        log.debug("Send command to {} Pushbutton {}T{}", new Object[]{_pushButtonLockout ? "Lock" : "Unlock", this._prefix, this.mNumber});
    }

    @Override
    public void requestUpdateFromLayout() {
        super.requestUpdateFromLayout();
        XNetMessage msg = XNetMessage.getFeedbackRequestMsg(this.mNumber, (this.mNumber - 1) % 4 < 2);
        this.queueMessage(msg, 0, null);
    }

    @Override
    public synchronized void setInverted(boolean inverted) {
        log.debug("Inverting Turnout State for turnout {}T{}", (Object)this._prefix, (Object)this.mNumber);
        if (inverted) {
            this._mThrown = 2;
            this._mClosed = 4;
        } else {
            this._mThrown = 4;
            this._mClosed = 2;
        }
        super.setInverted(inverted);
    }

    @Override
    public boolean canInvert() {
        return true;
    }

    synchronized void initmessage(XNetReply l) {
        int oldState = this.internalState;
        this.message(l);
        this.internalState = oldState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void message(XNetReply l) {
        log.debug("received message: {}", (Object)l);
        if (this.internalState == 1) {
            if (l.isOkMessage() && !l.isUnsolicited()) {
                XNetTurnout xNetTurnout = this;
                synchronized (xNetTurnout) {
                    this.newKnownState(this.getCommandedState());
                }
                this.sendQueuedMessage();
                return;
            }
            if (l.isRetransmittableErrorMsg()) {
                return;
            }
            log.debug("Message is not OK message. Message received was: {}", (Object)l);
            this.sendOffMessage();
        }
        switch (this.getFeedbackMode()) {
            case 2: {
                this.handleExactModeFeedback(l);
                break;
            }
            case 8: {
                this.handleMonitoringModeFeedback(l);
                break;
            }
            default: {
                this.handleDirectModeFeedback(l);
            }
        }
    }

    @Override
    public synchronized void message(XNetMessage l) {
        log.debug("received outgoing message {} for turnout {}", (Object)l, (Object)this.getSystemName());
        if (this.lastMsg != null && l == this.lastMsg.msg) {
            this.internalState = this.lastMsg.getState();
            this.lastMsg = null;
        }
    }

    @Override
    public synchronized void notifyTimeout(XNetMessage msg) {
        log.debug("Notified of timeout on message {}", (Object)msg);
        if (this.internalState == 1) {
            this.sendOffMessage();
        }
    }

    private synchronized void handleDirectModeFeedback(XNetReply l) {
        log.debug("Handle Message for turnout {} in DIRECT feedback mode   ", (Object)this.mNumber);
        if (this.getCommandedState() != this.getKnownState() || this.internalState == 2) {
            if (l.isOkMessage()) {
                log.debug("Turnout {} DIRECT feedback mode - OK message triggering OFF message.", (Object)this.mNumber);
            } else {
                if (!l.selectTurnoutFeedback(this.mNumber).isPresent()) {
                    return;
                }
                log.debug("Turnout {} DIRECT feedback mode - directed reply received.", (Object)this.mNumber);
            }
            this.sendOffMessage();
            this.sendOffMessage();
        }
    }

    private synchronized void handleMonitoringModeFeedback(XNetReply l) {
        log.debug("Handle Message for turnout {} in MONITORING feedback mode ", (Object)this.mNumber);
        if (this.internalState == 0 || this.internalState == 4) {
            if (l.onTurnoutFeedback(this.mNumber, this::parseFeedbackMessage)) {
                log.debug("Turnout {} MONITORING feedback mode - state change from feedback.", (Object)this.mNumber);
            }
        } else if (this.getCommandedState() != this.getKnownState() || this.internalState == 2) {
            if (l.isOkMessage()) {
                log.debug("Turnout {} MONITORING feedback mode - OK message triggering OFF message.", (Object)this.mNumber);
                this.sendOffMessage();
            } else if (l.onTurnoutFeedback(this.mNumber, this::parseFeedbackMessage)) {
                log.debug("Turnout {} MONITORING feedback mode - state change from feedback, CommandedState != KnownState.", (Object)this.mNumber);
                this.sendOffMessage();
            }
        }
    }

    private synchronized void handleExactModeFeedback(XNetReply reply) {
        log.debug("Handle Message for turnout {} in EXACT feedback mode ", (Object)this.mNumber);
        if (this.getCommandedState() == this.getKnownState() && (this.internalState == 0 || this.internalState == 4)) {
            if (reply.onTurnoutFeedback(this.mNumber, this::parseFeedbackMessage)) {
                log.debug("Turnout {} EXACT feedback mode - state change from feedback.", (Object)this.mNumber);
            }
        } else if (this.getCommandedState() != this.getKnownState() || this.internalState == 2 || this.internalState == 4) {
            if (reply.isOkMessage()) {
                log.debug("Turnout {} EXACT feedback mode - OK message triggering OFF message.", (Object)this.mNumber);
                this.sendOffMessage();
            } else {
                reply.selectTurnoutFeedback(this.mNumber).ifPresent(l -> {
                    int messageType = l.getType();
                    switch (messageType) {
                        case 1: {
                            if (!l.isMotionComplete()) {
                                log.debug("Turnout {} EXACT feedback mode - state change from feedback, CommandedState!=KnownState - motion not complete", (Object)this.mNumber);
                                XNetMessage msg = XNetMessage.getFeedbackRequestMsg(this.mNumber, this.mNumber % 4 <= 1);
                                this.queueMessage(msg, 4, null);
                                return;
                            }
                            log.debug("Turnout {} EXACT feedback mode - state change from feedback, CommandedState!=KnownState - motion complete", (Object)this.mNumber);
                            break;
                        }
                        case 0: {
                            log.debug("Turnout {} EXACT feedback mode - state change from feedback, CommandedState!=KnownState - motion complete", (Object)this.mNumber);
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    this.parseFeedbackMessage((FeedbackItem)l);
                    this.sendOffMessage();
                });
            }
        }
    }

    protected synchronized void sendOffMessage() {
        if (log.isDebugEnabled()) {
            log.debug("Sending off message for turnout {} commanded state={}", (Object)this.mNumber, (Object)this.getCommandedState());
            log.debug("Current Thread ID: {} Thread Name {}", (Object)Thread.currentThread().getId(), (Object)Thread.currentThread().getName());
        }
        XNetMessage msg = this.getOffMessage();
        this.lastMsg = new RequestMessage(msg, 1, this);
        this.internalState = 1;
        this.newKnownState(this.getCommandedState());
        this.tc.sendHighPriorityXNetMessage(msg, this);
    }

    protected synchronized XNetMessage getOffMessage() {
        return XNetMessage.getTurnoutCommandMsg(this.mNumber, this.getCommandedState() == this._mClosed, this.getCommandedState() == this._mThrown, false);
    }

    private synchronized boolean parseFeedbackMessage(FeedbackItem l) {
        log.debug("Message for turnout {}", (Object)this.mNumber);
        switch (l.getTurnoutStatus()) {
            case 4: {
                this.newKnownState(this._mThrown);
                return true;
            }
            case 2: {
                this.newKnownState(this._mClosed);
                return true;
            }
        }
        if (this.getCommandedState() != this.getKnownState()) {
            this.forwardCommandChangeToLayout(this.getCommandedState());
        } else {
            this.sendQueuedMessage();
        }
        return false;
    }

    @Override
    public void dispose() {
        this.removePropertyChangeListener(this._stateListener);
        super.dispose();
    }

    protected synchronized void sendQueuedMessage() {
        this.lastMsg = null;
        this.lastMsg = this.requestList.poll();
        if (this.lastMsg != null) {
            log.debug("sending message to traffic controller");
            this.internalState = this.lastMsg.listener != null ? 8 : this.lastMsg.state;
            this.tc.sendXNetMessage(this.lastMsg.getMsg(), this.lastMsg.getListener());
        } else {
            log.debug("message queue empty");
            this.internalState = 0;
        }
    }

    protected synchronized void queueMessage(XNetMessage m, int s, XNetListener l) {
        log.debug("adding message {} to message queue.  Current Internal State {}", (Object)m, (Object)this.internalState);
        RequestMessage msg = new RequestMessage(m, s, l);
        this.requestList.add(msg);
        if (this.internalState == 0) {
            this.sendQueuedMessage();
        }
    }

    protected static class RequestMessage {
        private final int state;
        private final XNetMessage msg;
        private final XNetListener listener;

        RequestMessage(XNetMessage m, int s, XNetListener listener) {
            this.state = s;
            this.msg = m;
            this.listener = listener;
        }

        int getState() {
            return this.state;
        }

        XNetMessage getMsg() {
            return this.msg;
        }

        XNetListener getListener() {
            return this.listener;
        }
    }

    private static class XNetTurnoutStateListener
    implements PropertyChangeListener {
        final XNetTurnout _turnout;

        XNetTurnoutStateListener(XNetTurnout turnout) {
            this._turnout = turnout;
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            log.debug("propertyChange called");
            if (this._turnout.getFeedbackMode() != 1) {
                if (log.isDebugEnabled()) {
                    log.debug("propertyChange Not Direct Mode property: {} old value {} new value {}", new Object[]{event.getPropertyName(), event.getOldValue(), event.getNewValue()});
                }
                if (event.getPropertyName().equals("KnownState")) {
                    int oldKnownState = (Integer)event.getOldValue();
                    int curKnownState = (Integer)event.getNewValue();
                    log.debug("propertyChange KnownState - old value {} new value {}", (Object)oldKnownState, (Object)curKnownState);
                    if (curKnownState != 8 && this._turnout.getCommandedState() == oldKnownState) {
                        if (log.isDebugEnabled()) {
                            log.debug("propertyChange CommandedState: {}", (Object)this._turnout.getCommandedState());
                        }
                        this._turnout.newCommandedState(curKnownState);
                    } else if (oldKnownState == 8) {
                        if (log.isDebugEnabled()) {
                            log.debug("propertyChange CommandedState: {}", (Object)this._turnout.getCommandedState());
                        }
                        this._turnout.sendOffMessage();
                    }
                }
            }
        }
    }
}

