/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz;

import java.util.EnumSet;
import java.util.HashMap;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.ThrottleListener;
import jmri.jmrix.AbstractThrottleManager;
import jmri.jmrix.lenz.Bundle;
import jmri.jmrix.lenz.XNetListener;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetSystemConnectionMemo;
import jmri.jmrix.lenz.XNetThrottle;
import jmri.jmrix.lenz.XNetTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XNetThrottleManager
extends AbstractThrottleManager
implements XNetListener {
    protected final HashMap<LocoAddress, XNetThrottle> throttles = new HashMap(5);
    protected XNetTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(XNetThrottleManager.class);

    public XNetThrottleManager(XNetSystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getXNetTrafficController();
        this.tc.addXNetListener(16, this);
    }

    @Override
    public void requestThrottleSetup(LocoAddress address, boolean control) {
        if (log.isDebugEnabled()) {
            log.debug("Requesting Throttle: {}", (Object)address);
        }
        if ((this.tc.getCommandStation().getCommandStationType() == 1 || this.tc.getCommandStation().getCommandStationType() == 2) && address.getNumber() >= 100) {
            String typeString = Bundle.getMessage(this.tc.getCommandStation().getCommandStationType() == 1 ? "CSTypeLH200" : "CSTypeCompact");
            this.failedThrottleRequest(address, Bundle.getMessage("ThrottleErrorCSTwoDigit", typeString));
            return;
        }
        if (this.throttles.containsKey(address)) {
            this.notifyThrottleKnown(this.throttles.get(address), address);
        } else {
            XNetThrottle throttle = new XNetThrottle((XNetSystemConnectionMemo)this.adapterMemo, address, this.tc);
            this.throttles.put(address, throttle);
            this.notifyThrottleKnown(throttle, address);
        }
    }

    @Override
    public boolean hasDispatchFunction() {
        return false;
    }

    @Override
    protected boolean singleUse() {
        return false;
    }

    @Override
    public boolean canBeLongAddress(int address) {
        return XNetThrottleManager.isLongAddress(address);
    }

    @Override
    public boolean canBeShortAddress(int address) {
        return !XNetThrottleManager.isLongAddress(address);
    }

    @Override
    public boolean addressTypeUnique() {
        return true;
    }

    protected static boolean isLongAddress(int num) {
        return num >= 100;
    }

    @Override
    public EnumSet<SpeedStepMode> supportedSpeedModes() {
        return EnumSet.of(SpeedStepMode.NMRA_DCC_128, SpeedStepMode.NMRA_DCC_28, SpeedStepMode.NMRA_DCC_27, SpeedStepMode.NMRA_DCC_14);
    }

    @Override
    public void message(XNetReply r) {
        DccLocoAddress address;
        if (r.getElement(0) == 227 && r.getElement(1) == 64 && this.throttles.containsKey(address = new DccLocoAddress(r.getThrottleMsgAddr(), XNetThrottleManager.isLongAddress(r.getThrottleMsgAddr())))) {
            this.throttles.get(address).message(r);
        }
    }

    @Override
    public void message(XNetMessage l) {
    }

    @Override
    public void notifyTimeout(XNetMessage msg) {
    }

    @Override
    public void releaseThrottle(DccThrottle t, ThrottleListener l) {
    }

    @Override
    public boolean disposeThrottle(DccThrottle t, ThrottleListener l) {
        if (super.disposeThrottle(t, l)) {
            if (!(t instanceof XNetThrottle)) {
                throw new IllegalArgumentException("Attempt to dispose non-XpressNet Throttle");
            }
            XNetThrottle lnt = (XNetThrottle)t;
            lnt.throttleDispose();
            return true;
        }
        return false;
    }
}

