/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz;

import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.concurrent.GuardedBy;
import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.jmrix.AbstractThrottle;
import jmri.jmrix.lenz.LenzCommandStation;
import jmri.jmrix.lenz.XNetListener;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetSystemConnectionMemo;
import jmri.jmrix.lenz.XNetThrottleManager;
import jmri.jmrix.lenz.XNetTrafficController;
import jmri.util.TimerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XNetThrottle
extends AbstractThrottle
implements XNetListener {
    protected boolean isAvailable;
    protected TimerTask statusTask;
    protected static final int statTimeoutValue = 1000;
    @GuardedBy(value="this")
    protected XNetTrafficController tc;
    protected static final int THROTTLEIDLE = 0;
    protected static final int THROTTLESTATSENT = 1;
    protected static final int THROTTLESPEEDSENT = 2;
    protected static final int THROTTLEFUNCSENT = 4;
    protected static final int THROTTLEMOMSTATSENT = 8;
    protected static final int THROTTLEHIGHSTATSENT = 16;
    protected static final int THROTTLEHIGHMOMSTATSENT = 32;
    protected int requestState = 0;
    protected int address;
    protected LinkedBlockingQueue<RequestMessage> requestList;
    private static final Logger log = LoggerFactory.getLogger(XNetThrottle.class);

    public XNetThrottle(XNetSystemConnectionMemo memo, XNetTrafficController controller) {
        super(memo);
        this.tc = controller;
        this.requestList = new LinkedBlockingQueue();
        log.debug("XNetThrottle constructor");
    }

    public XNetThrottle(XNetSystemConnectionMemo memo, LocoAddress address, XNetTrafficController controller) {
        super(memo);
        this.tc = controller;
        this.setDccAddress(address.getNumber());
        this.speedStepMode = SpeedStepMode.NMRA_DCC_128;
        this.setIsAvailable(false);
        this.requestList = new LinkedBlockingQueue();
        this.sendStatusInformationRequest();
        log.debug("XNetThrottle constructor called for address {}", (Object)address);
    }

    public synchronized void setXNetTrafficController(XNetTrafficController controller) {
        this.tc = controller;
    }

    @Override
    protected void sendFunctionGroup1() {
        XNetMessage msg = XNetMessage.getFunctionGroup1OpsMsg(this.getDccAddress(), this.getFunction(0), this.getFunction(1), this.getFunction(2), this.getFunction(3), this.getFunction(4));
        this.queueMessage(msg, 4);
    }

    @Override
    protected void sendFunctionGroup2() {
        XNetMessage msg = XNetMessage.getFunctionGroup2OpsMsg(this.getDccAddress(), this.getFunction(5), this.getFunction(6), this.getFunction(7), this.getFunction(8));
        this.queueMessage(msg, 4);
    }

    @Override
    protected void sendFunctionGroup3() {
        XNetMessage msg = XNetMessage.getFunctionGroup3OpsMsg(this.getDccAddress(), this.getFunction(9), this.getFunction(10), this.getFunction(11), this.getFunction(12));
        this.queueMessage(msg, 4);
    }

    protected boolean csVersionSupportsHighFunctions() {
        if (this.tc.getCommandStation().getCommandStationSoftwareVersionBCD() < 54.0f) {
            log.info("Functions F13-F28 unavailable in CS software version {}", (Object)Float.valueOf(this.tc.getCommandStation().getCommandStationSoftwareVersion()));
            return false;
        }
        return true;
    }

    @Override
    protected void sendFunctionGroup4() {
        if (this.csVersionSupportsHighFunctions()) {
            XNetMessage msg = XNetMessage.getFunctionGroup4OpsMsg(this.getDccAddress(), this.getFunction(13), this.getFunction(14), this.getFunction(15), this.getFunction(16), this.getFunction(17), this.getFunction(18), this.getFunction(19), this.getFunction(20));
            this.queueMessage(msg, 4);
        }
    }

    @Override
    protected void sendFunctionGroup5() {
        if (this.csVersionSupportsHighFunctions()) {
            XNetMessage msg = XNetMessage.getFunctionGroup5OpsMsg(this.getDccAddress(), this.getFunction(21), this.getFunction(22), this.getFunction(23), this.getFunction(24), this.getFunction(25), this.getFunction(26), this.getFunction(27), this.getFunction(28));
            this.queueMessage(msg, 4);
        }
    }

    @Override
    protected void sendMomentaryFunctionGroup1() {
        XNetMessage msg = XNetMessage.getFunctionGroup1SetMomMsg(this.getDccAddress(), this.getFunctionMomentary(0), this.getFunctionMomentary(1), this.getFunctionMomentary(2), this.getFunctionMomentary(3), this.getFunctionMomentary(4));
        this.queueMessage(msg, 4);
    }

    @Override
    protected void sendMomentaryFunctionGroup2() {
        XNetMessage msg = XNetMessage.getFunctionGroup2SetMomMsg(this.getDccAddress(), this.getFunctionMomentary(5), this.getFunctionMomentary(6), this.getFunctionMomentary(7), this.getFunctionMomentary(8));
        this.queueMessage(msg, 4);
    }

    @Override
    protected void sendMomentaryFunctionGroup3() {
        XNetMessage msg = XNetMessage.getFunctionGroup3SetMomMsg(this.getDccAddress(), this.getFunctionMomentary(9), this.getFunctionMomentary(10), this.getFunctionMomentary(11), this.getFunctionMomentary(12));
        this.queueMessage(msg, 4);
    }

    @Override
    protected void sendMomentaryFunctionGroup4() {
        if (this.csVersionSupportsHighFunctions()) {
            XNetMessage msg = XNetMessage.getFunctionGroup4SetMomMsg(this.getDccAddress(), this.getFunctionMomentary(13), this.getFunctionMomentary(14), this.getFunctionMomentary(15), this.getFunctionMomentary(16), this.getFunctionMomentary(17), this.getFunctionMomentary(18), this.getFunctionMomentary(19), this.getFunctionMomentary(20));
            this.queueMessage(msg, 4);
        }
    }

    @Override
    protected void sendMomentaryFunctionGroup5() {
        if (this.csVersionSupportsHighFunctions()) {
            XNetMessage msg = XNetMessage.getFunctionGroup5SetMomMsg(this.getDccAddress(), this.getFunctionMomentary(21), this.getFunctionMomentary(22), this.getFunctionMomentary(23), this.getFunctionMomentary(24), this.getFunctionMomentary(25), this.getFunctionMomentary(26), this.getFunctionMomentary(27), this.getFunctionMomentary(28));
            this.queueMessage(msg, 4);
        }
    }

    @Override
    public synchronized void setSpeedSetting(float speed) {
        log.debug("set Speed to: {} Current step mode is: {}", (Object)Float.valueOf(speed), (Object)this.speedStepMode);
        super.setSpeedSetting(speed);
        if (speed < 0.0f) {
            this.sendEmergencyStop();
        } else {
            if (speed > 1.0f) {
                speed = 1.0f;
            }
            XNetMessage msg = XNetMessage.getSpeedAndDirectionMsg(this.getDccAddress(), this.speedStepMode, speed, this.isForward);
            this.queueMessage(msg, 2);
        }
    }

    protected void sendEmergencyStop() {
        XNetMessage msg = XNetMessage.getAddressedEmergencyStop(this.getDccAddress());
        this.queueMessage(msg, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIsForward(boolean forward) {
        super.setIsForward(forward);
        XNetThrottle xNetThrottle = this;
        synchronized (xNetThrottle) {
            this.setSpeedSetting(this.speedSetting);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSpeedStepMode(SpeedStepMode Mode) {
        super.setSpeedStepMode(Mode);
        XNetThrottle xNetThrottle = this;
        synchronized (xNetThrottle) {
            this.setSpeedSetting(this.speedSetting);
        }
    }

    @Override
    public void throttleDispose() {
        this.active = false;
        this.stopStatusTimer();
        this.finishRecord();
    }

    public int setDccAddress(int newaddress) {
        this.address = newaddress;
        return this.address;
    }

    public int getDccAddress() {
        return this.address;
    }

    protected int getDccAddressHigh() {
        return LenzCommandStation.getDCCAddressHigh(this.address);
    }

    protected int getDccAddressLow() {
        return LenzCommandStation.getDCCAddressLow(this.address);
    }

    protected synchronized void sendStatusInformationRequest() {
        XNetMessage msg = XNetMessage.getLocomotiveInfoRequestMsg(this.address);
        msg.setRetries(1);
        this.queueMessage(msg, 1);
    }

    protected synchronized void sendFunctionStatusInformationRequest() {
        log.debug("Throttle {} sending request for function momentary status.", (Object)this.address);
        XNetMessage msg = XNetMessage.getLocomotiveFunctionStatusMsg(this.address);
        this.queueMessage(msg, 9);
    }

    protected synchronized void sendFunctionHighInformationRequest() {
        if (this.csVersionSupportsHighFunctions()) {
            log.debug("Throttle {} sending request for high function momentary status.", (Object)this.address);
            XNetMessage msg = XNetMessage.getLocomotiveFunctionHighOnStatusMsg(this.address);
            this.queueMessage(msg, 17);
        }
    }

    protected synchronized void sendFunctionHighMomentaryStatusRequest() {
        if (this.csVersionSupportsHighFunctions()) {
            log.debug("Throttle {} sending request for function momentary status.", (Object)this.address);
            XNetMessage msg = XNetMessage.getLocomotiveFunctionHighMomStatusMsg(this.address);
            this.queueMessage(msg, 33);
        }
    }

    @Override
    public void message(XNetReply l) {
        log.debug("Throttle {} - received message {}", (Object)this.getDccAddress(), (Object)l);
        if (this.requestState == 0) {
            log.trace("Current throttle status is THROTTLEIDLE");
            if (l.getElement(0) == 227) {
                log.trace("Throttle - message is LOCO_INFO_RESPONSE ");
                if (l.getElement(1) == 64 && this.getDccAddressHigh() == l.getElement(2) && this.getDccAddressLow() == l.getElement(3)) {
                    this.locoInUse();
                }
            }
        } else if ((this.requestState & 2) == 2 || (this.requestState & 4) == 4) {
            log.trace("Current throttle status is THROTTLESPEEDSENT");
            if (l.isOkMessage()) {
                log.trace("Last Command processed successfully.");
                this.setIsAvailable(true);
                this.requestState = 0;
                this.sendQueuedMessage();
            } else if (l.isRetransmittableErrorMsg()) {
                log.trace("Communications error occurred - message received was: {}", (Object)l);
            } else if (l.isUnsupportedError()) {
                log.error("Unsupported Command Sent to command station");
                this.requestState = 0;
                this.sendQueuedMessage();
            } else {
                this.requestState = 0;
                this.sendQueuedMessage();
                log.trace("Received unhandled response: {}", (Object)l);
            }
        } else if ((this.requestState & 1) == 1) {
            log.trace("Current throttle status is THROTTLESTATSENT");
            if (l.getElement(0) == 228) {
                if (l.getElement(1) == 81) {
                    log.trace("Throttle - message is LOCO_FUNCTION_STATUS_HIGH_MOM");
                    int b3 = l.getElement(2);
                    int b4 = l.getElement(3);
                    this.parseFunctionHighMomentaryInformation(b3, b4);
                    this.requestState = 0;
                    this.sendQueuedMessage();
                } else {
                    log.trace("Throttle - message is LOCO_INFO_NORMAL_UNIT");
                    int b1 = l.getElement(1);
                    int b2 = l.getElement(2);
                    int b3 = l.getElement(3);
                    int b4 = l.getElement(4);
                    this.parseSpeedAndAvailability(b1);
                    this.parseSpeedAndDirection(b2);
                    this.parseFunctionInformation(b3, b4);
                    this.requestState = 0;
                    this.sendQueuedMessage();
                    this.sendFunctionStatusInformationRequest();
                }
            } else if (l.getElement(0) == 229) {
                log.trace("Throttle - message is LOCO_INFO_MUED_UNIT ");
                int b1 = l.getElement(1);
                int b2 = l.getElement(2);
                int b3 = l.getElement(3);
                int b4 = l.getElement(4);
                int b5 = l.getElement(5);
                log.trace("Locomotive {} inconsist {} ", (Object)this.getDccAddress(), (Object)b5);
                this.parseSpeedAndAvailability(b1);
                this.parseSpeedAndDirection(b2);
                this.parseFunctionInformation(b3, b4);
                this.requestState = 0;
                this.sendQueuedMessage();
                this.sendFunctionStatusInformationRequest();
            } else if (l.getElement(0) == 230) {
                log.trace("Throttle - message is LOCO_INFO_DH_UNIT ");
                int b1 = l.getElement(1);
                int b2 = l.getElement(2);
                int b3 = l.getElement(3);
                int b4 = l.getElement(4);
                int b5 = l.getElement(5);
                int b6 = l.getElement(6);
                if (log.isDebugEnabled()) {
                    int address2 = b5 == 0 ? b6 : (b5 * 256 & 0xFF00) + (b6 & 0xFF) - 49152;
                    log.trace("Locomotive {} in Double Header with {}", (Object)this.getDccAddress(), (Object)address2);
                }
                this.parseSpeedAndAvailability(b1);
                this.parseSpeedAndDirection(b2);
                this.parseFunctionInformation(b3, b4);
                this.requestState = 0;
                this.sendQueuedMessage();
                this.sendFunctionStatusInformationRequest();
            } else if (l.getElement(0) == 226) {
                log.trace("Throttle - message is LOCO_INFO_MU ADDRESS ");
                int b1 = l.getElement(1);
                int b2 = l.getElement(2);
                this.parseSpeedAndAvailability(b1);
                this.parseSpeedAndDirection(b2);
                this.requestState = 0;
                this.sendQueuedMessage();
                this.sendFunctionStatusInformationRequest();
            } else if (l.getElement(0) == 227) {
                log.trace("Throttle - message is LOCO_INFO_RESPONSE ");
                if (l.getElement(1) == 64) {
                    if (this.getDccAddressHigh() == l.getElement(2) && this.getDccAddressLow() == l.getElement(3)) {
                        this.locoInUse();
                    }
                    this.requestState = 0;
                    this.sendQueuedMessage();
                } else if (l.getElement(1) == 80) {
                    int b3 = l.getElement(2);
                    int b4 = l.getElement(3);
                    this.parseFunctionMomentaryInformation(b3, b4);
                    this.requestState = 0;
                    this.sendQueuedMessage();
                    this.sendFunctionHighInformationRequest();
                } else if (l.getElement(1) == 82) {
                    int b3 = l.getElement(2);
                    int b4 = l.getElement(3);
                    this.parseFunctionHighInformation(b3, b4);
                    this.requestState = 0;
                    this.sendQueuedMessage();
                    this.sendFunctionHighMomentaryStatusRequest();
                }
            } else if (l.isRetransmittableErrorMsg()) {
                log.trace("Communications error occurred - message received was: {}", (Object)l);
            } else if (l.isUnsupportedError()) {
                log.error("Unsupported Command Sent to command station");
                if ((this.requestState & 8) == 8) {
                    this.requestState = 0;
                    this.sendFunctionHighInformationRequest();
                } else {
                    this.requestState = 0;
                    this.sendQueuedMessage();
                }
            } else {
                this.requestState = 0;
                this.sendQueuedMessage();
                log.trace("Received unhandled response: {}", (Object)l);
            }
        }
    }

    private void locoInUse() {
        if (this.isAvailable) {
            log.info("Loco {} In use by another device", (Object)this.getDccAddress());
            this.setIsAvailable(false);
        }
    }

    @Override
    public void message(XNetMessage l) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyTimeout(XNetMessage msg) {
        log.debug("Notified of timeout on message {} , {} retries available.", (Object)msg, (Object)msg.getRetries());
        if (msg.getRetries() > 0) {
            XNetThrottle xNetThrottle = this;
            synchronized (xNetThrottle) {
                this.tc.sendXNetMessage(msg, this);
            }
        } else {
            this.sendQueuedMessage();
        }
    }

    protected void parseSpeedAndAvailability(int b1) {
        if ((b1 & 8) == 8 && this.isAvailable) {
            this.locoInUse();
        } else if ((b1 & 8) == 0 && !this.isAvailable) {
            log.trace("Loco Is Available");
            this.setIsAvailable(true);
        }
        if ((b1 & 1) == 1) {
            log.trace("Speed Step setting 27");
            this.notifyNewSpeedStepMode(SpeedStepMode.NMRA_DCC_27);
        } else if ((b1 & 2) == 2) {
            log.trace("Speed Step setting 28");
            this.notifyNewSpeedStepMode(SpeedStepMode.NMRA_DCC_28);
        } else if ((b1 & 4) == 4) {
            log.trace("Speed Step setting 128");
            this.notifyNewSpeedStepMode(SpeedStepMode.NMRA_DCC_128);
        } else {
            log.trace("Speed Step setting 14");
            this.notifyNewSpeedStepMode(SpeedStepMode.NMRA_DCC_14);
        }
    }

    protected void notifyNewSpeedStepMode(SpeedStepMode mode) {
        if (this.speedStepMode != mode) {
            this.speedStepMode = mode;
            this.firePropertyChange("SpeedSteps", (Object)this.speedStepMode, (Object)this.speedStepMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseSpeedAndDirection(int b2) {
        if ((b2 & 0x80) == 128 && !this.isForward) {
            this.notifyNewDirection(true);
        } else if ((b2 & 0x80) == 0 && this.isForward) {
            this.notifyNewDirection(false);
        }
        if (this.speedStepMode == SpeedStepMode.NMRA_DCC_128) {
            int speedVal = b2 & 0x7F;
            if (speedVal >= 1) {
                --speedVal;
            }
            if ((double)Math.abs(this.getSpeedSetting() - (float)speedVal / 126.0f) >= 0.0079) {
                XNetThrottle xNetThrottle = this;
                synchronized (xNetThrottle) {
                    this.speedSetting = (float)speedVal / 126.0f;
                    this.firePropertyChange("SpeedSetting", Float.valueOf(this.speedSetting), Float.valueOf(this.speedSetting));
                }
            }
        } else if (this.speedStepMode == SpeedStepMode.NMRA_DCC_28) {
            int speedVal = ((b2 & 0xF) << 1) + ((b2 & 0x10) >> 4);
            speedVal = speedVal >= 3 ? (speedVal -= 3) : 0;
            if ((double)Math.abs(this.getSpeedSetting() - (float)speedVal / 28.0f) >= 0.035) {
                XNetThrottle xNetThrottle = this;
                synchronized (xNetThrottle) {
                    this.speedSetting = (float)speedVal / 28.0f;
                    this.firePropertyChange("SpeedSetting", Float.valueOf(this.speedSetting), Float.valueOf(this.speedSetting));
                }
            }
        } else if (this.speedStepMode == SpeedStepMode.NMRA_DCC_27) {
            int speedVal = ((b2 & 0xF) << 1) + ((b2 & 0x10) >> 4);
            speedVal = speedVal >= 3 ? (speedVal -= 3) : 0;
            if ((double)Math.abs(this.getSpeedSetting() - (float)speedVal / 27.0f) >= 0.037) {
                XNetThrottle xNetThrottle = this;
                synchronized (xNetThrottle) {
                    this.speedSetting = (float)speedVal / 27.0f;
                    this.firePropertyChange("SpeedSetting", Float.valueOf(this.speedSetting), Float.valueOf(this.speedSetting));
                }
            }
        } else {
            int speedVal = b2 & 0xF;
            if (speedVal >= 1) {
                --speedVal;
            }
            if ((double)Math.abs(this.getSpeedSetting() - (float)speedVal / 14.0f) >= 0.071) {
                XNetThrottle xNetThrottle = this;
                synchronized (xNetThrottle) {
                    this.speedSetting = (float)speedVal / 14.0f;
                    this.firePropertyChange("SpeedSetting", Float.valueOf(this.speedSetting), Float.valueOf(this.speedSetting));
                }
            }
        }
    }

    protected void notifyNewDirection(boolean forward) {
        this.isForward = forward;
        this.firePropertyChange("IsForward", this.isForward, this.isForward);
        log.trace("Throttle - Changed direction to {} Locomotive: {}", (Object)(forward ? "forward" : "reverse"), (Object)this.getDccAddress());
    }

    protected void parseFunctionInformation(int b3, int b4) {
        log.trace("Parsing Function F0-F12 status, function bytes: {} and {}", (Object)b3, (Object)b4);
        this.updateFunction(0, (b3 & 0x10) == 16);
        this.updateFunction(1, (b3 & 1) == 1);
        this.updateFunction(2, (b3 & 2) == 2);
        this.updateFunction(3, (b3 & 4) == 4);
        this.updateFunction(4, (b3 & 8) == 8);
        this.updateFunction(5, (b4 & 1) == 1);
        this.updateFunction(6, (b4 & 2) == 2);
        this.updateFunction(7, (b4 & 4) == 4);
        this.updateFunction(8, (b4 & 8) == 8);
        this.updateFunction(9, (b4 & 0x10) == 16);
        this.updateFunction(10, (b4 & 0x20) == 32);
        this.updateFunction(11, (b4 & 0x40) == 64);
        this.updateFunction(12, (b4 & 0x80) == 128);
    }

    protected void parseFunctionHighInformation(int b3, int b4) {
        log.trace("Parsing Function F13-F28 status, function bytes: {} and {}", (Object)b3, (Object)b4);
        this.updateFunction(13, (b3 & 1) == 1);
        this.updateFunction(14, (b3 & 2) == 2);
        this.updateFunction(15, (b3 & 4) == 4);
        this.updateFunction(16, (b3 & 8) == 8);
        this.updateFunction(17, (b3 & 0x10) == 16);
        this.updateFunction(18, (b3 & 0x20) == 32);
        this.updateFunction(19, (b3 & 0x40) == 64);
        this.updateFunction(20, (b3 & 0x80) == 128);
        this.updateFunction(21, (b4 & 1) == 1);
        this.updateFunction(22, (b4 & 2) == 2);
        this.updateFunction(23, (b4 & 4) == 4);
        this.updateFunction(24, (b4 & 8) == 8);
        this.updateFunction(25, (b4 & 0x10) == 16);
        this.updateFunction(26, (b4 & 0x20) == 32);
        this.updateFunction(27, (b4 & 0x40) == 64);
        this.updateFunction(28, (b4 & 0x80) == 128);
    }

    protected void parseFunctionMomentaryInformation(int b3, int b4) {
        log.trace("Parsing Function Momentary status, function bytes: {} and {}", (Object)b3, (Object)b4);
        this.checkForFunctionMomentaryValueChange(0, b3, 16, this.getF0Momentary());
        this.checkForFunctionMomentaryValueChange(1, b3, 1, this.getF1Momentary());
        this.checkForFunctionMomentaryValueChange(2, b3, 2, this.getF2Momentary());
        this.checkForFunctionMomentaryValueChange(3, b3, 4, this.getF3Momentary());
        this.checkForFunctionMomentaryValueChange(4, b3, 8, this.getF4Momentary());
        this.checkForFunctionMomentaryValueChange(5, b4, 1, this.getF5Momentary());
        this.checkForFunctionMomentaryValueChange(6, b4, 2, this.getF6Momentary());
        this.checkForFunctionMomentaryValueChange(7, b4, 4, this.getF7Momentary());
        this.checkForFunctionMomentaryValueChange(8, b4, 8, this.getF8Momentary());
        this.checkForFunctionMomentaryValueChange(9, b4, 16, this.getF9Momentary());
        this.checkForFunctionMomentaryValueChange(10, b4, 32, this.getF10Momentary());
        this.checkForFunctionMomentaryValueChange(11, b4, 64, this.getF11Momentary());
        this.checkForFunctionMomentaryValueChange(12, b4, 128, this.getF12Momentary());
    }

    protected void parseFunctionHighMomentaryInformation(int b3, int b4) {
        log.trace("Parsing Function F13-F28 Momentary status, function bytes: {} and {}", (Object)b3, (Object)b4);
        this.checkForFunctionMomentaryValueChange(13, b3, 1, this.getFunctionMomentary(13));
        this.checkForFunctionMomentaryValueChange(14, b3, 2, this.getF14Momentary());
        this.checkForFunctionMomentaryValueChange(15, b3, 4, this.getF15Momentary());
        this.checkForFunctionMomentaryValueChange(16, b3, 8, this.getF16Momentary());
        this.checkForFunctionMomentaryValueChange(17, b3, 16, this.getF17Momentary());
        this.checkForFunctionMomentaryValueChange(18, b3, 32, this.getF18Momentary());
        this.checkForFunctionMomentaryValueChange(19, b3, 64, this.getF19Momentary());
        this.checkForFunctionMomentaryValueChange(20, b3, 128, this.getF20Momentary());
        this.checkForFunctionMomentaryValueChange(21, b4, 1, this.getF21Momentary());
        this.checkForFunctionMomentaryValueChange(22, b4, 2, this.getF22Momentary());
        this.checkForFunctionMomentaryValueChange(23, b4, 4, this.getF23Momentary());
        this.checkForFunctionMomentaryValueChange(24, b4, 8, this.getF24Momentary());
        this.checkForFunctionMomentaryValueChange(25, b4, 16, this.getF25Momentary());
        this.checkForFunctionMomentaryValueChange(26, b4, 32, this.getF26Momentary());
        this.checkForFunctionMomentaryValueChange(27, b4, 64, this.getF27Momentary());
        this.checkForFunctionMomentaryValueChange(28, b4, 128, this.getF28Momentary());
    }

    protected void checkForFunctionMomentaryValueChange(int funcNum, int bytevalue, int bitmask, boolean currentValue) {
        if ((bytevalue & bitmask) == bitmask && !currentValue) {
            this.updateFunctionMomentary(funcNum, true);
        } else if ((bytevalue & bitmask) == 0 && currentValue) {
            this.updateFunctionMomentary(funcNum, false);
        }
    }

    protected void setIsAvailable(boolean available) {
        this.isAvailable = available;
        this.firePropertyChange("IsAvailable", this.isAvailable, this.isAvailable);
        if (available) {
            this.stopStatusTimer();
        } else {
            this.startStatusTimer();
        }
    }

    protected void startStatusTimer() {
        log.debug("Status Timer Started");
        if (this.statusTask != null) {
            this.statusTask.cancel();
            this.statusTask = null;
        }
        this.statusTask = new TimerTask(){

            @Override
            public void run() {
                XNetThrottle.this.sendStatusInformationRequest();
            }
        };
        TimerUtil.schedule(this.statusTask, 1000L, 1000L);
    }

    protected void stopStatusTimer() {
        log.debug("Status Timer Stopped");
        if (this.statusTask != null) {
            try {
                this.statusTask.cancel();
            }
            catch (IllegalStateException illegalStateException) {
                log.debug("Timer already canceled");
            }
            this.statusTask = null;
        }
    }

    @Override
    public LocoAddress getLocoAddress() {
        return new DccLocoAddress(this.address, XNetThrottleManager.isLongAddress(this.address));
    }

    protected synchronized void sendQueuedMessage() {
        if (!this.requestList.isEmpty()) {
            RequestMessage msg;
            log.debug("sending message to traffic controller");
            try {
                msg = this.requestList.take();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            this.requestState = msg.getState();
            this.tc.sendXNetMessage(msg.getMsg(), this);
        } else {
            log.debug("message queue empty");
            this.requestState = 0;
        }
    }

    protected synchronized void queueMessage(XNetMessage m, int s) {
        log.debug("adding message to message queue");
        RequestMessage msg = new RequestMessage(m, s);
        try {
            this.requestList.put(msg);
        }
        catch (InterruptedException interruptedException) {
            log.trace("Interrupted while queueing message {}", (Object)msg);
        }
        if (this.requestState == 0) {
            this.sendQueuedMessage();
        }
    }

    protected static class RequestMessage {
        private final int state;
        private final XNetMessage msg;

        RequestMessage(XNetMessage m, int s) {
            this.state = s;
            this.msg = m;
        }

        int getState() {
            return this.state;
        }

        XNetMessage getMsg() {
            return this.msg;
        }
    }
}

