/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz;

import java.util.Comparator;
import java.util.ResourceBundle;
import jmri.AddressedProgrammerManager;
import jmri.CommandStation;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.LightManager;
import jmri.NamedBean;
import jmri.PowerManager;
import jmri.SensorManager;
import jmri.ThrottleManager;
import jmri.TurnoutManager;
import jmri.jmrix.DefaultSystemConnectionMemo;
import jmri.jmrix.lenz.Bundle;
import jmri.jmrix.lenz.LenzCommandStation;
import jmri.jmrix.lenz.XNetProgrammerManager;
import jmri.jmrix.lenz.XNetTrafficController;
import jmri.jmrix.lenz.swing.XNetComponentFactory;
import jmri.jmrix.swing.ComponentFactory;
import jmri.util.NamedBeanComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XNetSystemConnectionMemo
extends DefaultSystemConnectionMemo {
    private ComponentFactory cf;
    private XNetTrafficController xt;
    private static final Logger log = LoggerFactory.getLogger(XNetSystemConnectionMemo.class);

    public XNetSystemConnectionMemo(XNetTrafficController xt) {
        super("X", Bundle.getMessage("MenuXpressNet"));
        this.xt = xt;
        xt.setSystemConnectionMemo(this);
        this.setLenzCommandStation(xt.getCommandStation());
        this.commonInit();
    }

    public XNetSystemConnectionMemo() {
        super("X", Bundle.getMessage("MenuXpressNet"));
        this.commonInit();
    }

    private void commonInit() {
        this.register();
        InstanceManager.store(this, XNetSystemConnectionMemo.class);
        this.cf = new XNetComponentFactory(this);
        InstanceManager.store(this.cf, ComponentFactory.class);
        log.debug("Created XNetSystemConnectionMemo");
    }

    public XNetTrafficController getXNetTrafficController() {
        return this.xt;
    }

    public void setXNetTrafficController(XNetTrafficController xt) {
        this.xt = xt;
        xt.setSystemConnectionMemo(this);
        this.setLenzCommandStation(xt.getCommandStation());
    }

    public XNetProgrammerManager getProgrammerManager() {
        return (XNetProgrammerManager)this.get(XNetProgrammerManager.class);
    }

    public void setProgrammerManager(XNetProgrammerManager p) {
        this.store(p, XNetProgrammerManager.class);
        if (p.isGlobalProgrammerAvailable()) {
            this.store(p, GlobalProgrammerManager.class);
        }
        if (p.isAddressedModePossible()) {
            this.store(p, AddressedProgrammerManager.class);
        }
    }

    public ThrottleManager getThrottleManager() {
        return (ThrottleManager)this.get(ThrottleManager.class);
    }

    public void setThrottleManager(ThrottleManager t) {
        this.store(t, ThrottleManager.class);
    }

    public PowerManager getPowerManager() {
        return (PowerManager)this.get(PowerManager.class);
    }

    public void setPowerManager(PowerManager p) {
        this.store(p, PowerManager.class);
    }

    public SensorManager getSensorManager() {
        return (SensorManager)this.get(SensorManager.class);
    }

    public void setSensorManager(SensorManager s) {
        this.store(s, SensorManager.class);
    }

    public TurnoutManager getTurnoutManager() {
        return (TurnoutManager)this.get(TurnoutManager.class);
    }

    public void setTurnoutManager(TurnoutManager t) {
        this.store(t, TurnoutManager.class);
    }

    public LightManager getLightManager() {
        return (LightManager)this.get(LightManager.class);
    }

    public void setLightManager(LightManager l) {
        this.store(l, LightManager.class);
    }

    public CommandStation getCommandStation() {
        return (CommandStation)this.get(CommandStation.class);
    }

    public void setCommandStation(CommandStation c) {
        if (c instanceof LenzCommandStation) {
            this.setLenzCommandStation((LenzCommandStation)c);
            if (((LenzCommandStation)c).getCommandStationType() != 2) {
                this.store(c, CommandStation.class);
            }
        } else {
            this.store(c, CommandStation.class);
        }
    }

    public LenzCommandStation getLenzCommandStation() {
        return (LenzCommandStation)this.get(LenzCommandStation.class);
    }

    public void setLenzCommandStation(LenzCommandStation c) {
        this.store(c, LenzCommandStation.class);
        c.setTrafficController(this.xt);
        c.setSystemConnectionMemo(this);
    }

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        return ResourceBundle.getBundle("jmri.jmrix.lenz.XNetActionListBundle");
    }

    @Override
    public <B extends NamedBean> Comparator<B> getNamedBeanComparator(Class<B> type) {
        return new NamedBeanComparator();
    }

    @Override
    public void dispose() {
        this.xt = null;
        InstanceManager.deregister(this, XNetSystemConnectionMemo.class);
        if (this.cf != null) {
            InstanceManager.deregister(this.cf, ComponentFactory.class);
        }
        super.dispose();
    }
}

