/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz;

import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.lenz.XNetPortController;
import jmri.jmrix.lenz.XNetSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import purejavacomm.SerialPort;

public abstract class XNetSerialPortController
extends AbstractSerialPortController
implements XNetPortController {
    protected SerialPort activeSerialPort = null;
    private boolean outputBufferEmpty = true;
    private boolean timeSlot = true;
    protected String[] validOption2 = new String[]{"yes", "no"};
    private boolean checkBuffer = false;
    private static final Logger log = LoggerFactory.getLogger(XNetSerialPortController.class);

    public XNetSerialPortController() {
        super(new XNetSystemConnectionMemo());
    }

    public XNetSerialPortController(XNetSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    public boolean okToSend() {
        if ((this.activeSerialPort.getFlowControlMode() & 2) == 2) {
            if (this.checkBuffer) {
                log.debug("CTS: {} Buffer Empty {}", (Object)this.activeSerialPort.isCTS(), (Object)this.outputBufferEmpty);
                return this.activeSerialPort.isCTS() && this.outputBufferEmpty;
            }
            log.debug("CTS: {}", (Object)this.activeSerialPort.isCTS());
            return this.activeSerialPort.isCTS();
        }
        if (this.checkBuffer) {
            log.debug("Buffer Empty: {}", (Object)this.outputBufferEmpty);
            return this.outputBufferEmpty && this.hasTimeSlot();
        }
        log.debug("No Flow Control or Buffer Check");
        return this.hasTimeSlot();
    }

    @Override
    public boolean hasTimeSlot() {
        return this.timeSlot;
    }

    @Override
    public void setTimeSlot(boolean timeslot) {
        this.timeSlot = timeslot;
    }

    @Override
    public synchronized void setOutputBufferEmpty(boolean s) {
        this.outputBufferEmpty = s;
    }

    protected void setCheckBuffer(boolean b) {
        this.checkBuffer = b;
    }

    @Override
    public XNetSystemConnectionMemo getSystemConnectionMemo() {
        return (XNetSystemConnectionMemo)super.getSystemConnectionMemo();
    }
}

