/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.jmrix.lenz.Bundle;
import jmri.jmrix.lenz.XNetAddress;
import jmri.jmrix.lenz.XNetListener;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetSensor;
import jmri.jmrix.lenz.XNetSystemConnectionMemo;
import jmri.jmrix.lenz.XNetTrafficController;
import jmri.managers.AbstractSensorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XNetSensorManager
extends AbstractSensorManager
implements XNetListener {
    protected XNetTrafficController tc;
    private int iName;
    private static final Logger log = LoggerFactory.getLogger(XNetSensorManager.class);

    public XNetSensorManager(XNetSystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getXNetTrafficController();
        this.tc.addXNetListener(8, this);
    }

    @Override
    @Nonnull
    public XNetSystemConnectionMemo getMemo() {
        return (XNetSystemConnectionMemo)this.memo;
    }

    @Override
    public void dispose() {
        this.tc.removeXNetListener(8, this);
        super.dispose();
    }

    @Override
    @Nonnull
    protected Sensor createNewSensor(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        int bitNum = XNetAddress.getBitFromSystemName(systemName, this.getSystemPrefix());
        if (bitNum == -1) {
            throw new IllegalArgumentException("Unable to convert " + systemName + " to XNet sensor address");
        }
        String sName = String.valueOf(this.getSystemNamePrefix()) + bitNum;
        return new XNetSensor(sName, userName, this.tc, this.getSystemPrefix());
    }

    @Override
    public void message(XNetReply l) {
        log.debug("received message: {}", (Object)l);
        if (l.isFeedbackBroadcastMessage()) {
            int numDataBytes = l.getElement(0) & 0xF;
            int i = 1;
            while (i < numDataBytes) {
                if (l.getFeedbackMessageType(i) == 2) {
                    int address = l.getFeedbackEncoderMsgAddr(i);
                    log.debug("Message for feedback encoder {}", (Object)address);
                    int firstaddress = address * 8 + 1;
                    int j = 0;
                    while (j < 8) {
                        String s = String.valueOf(this.getSystemNamePrefix()) + (firstaddress + j);
                        if (this.getBySystemName(s) == null) {
                            ((XNetSensor)this.provideSensor(s)).initmessage(l);
                        } else {
                            Sensor xns = this.getBySystemName(s);
                            if (xns == null) {
                                log.error("Failed to get sensor for {}", (Object)s);
                            } else {
                                ((XNetSensor)xns).message(l);
                            }
                        }
                        ++j;
                    }
                }
                i += 2;
            }
        }
    }

    @Override
    public void message(XNetMessage l) {
    }

    @Override
    public void notifyTimeout(XNetMessage msg) {
        if (log.isDebugEnabled()) {
            log.debug("Notified of timeout on message{}", (Object)msg.toString());
        }
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) {
        if (name.contains(":")) {
            this.validateSystemNamePrefix(name, locale);
            String[] parts = name.substring(this.getSystemNamePrefix().length()).split(":");
            if (parts.length != 2) {
                throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "SystemNameInvalidAddress", name), Bundle.getMessage(locale, "SystemNameInvalidAddress", name));
            }
            try {
                int address = Integer.parseInt(parts[0]);
                if (address < 1 || address > 127) {
                    throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "SystemNameInvalidModule", name, parts[0]), Bundle.getMessage(locale, "SystemNameInvalidModule", name, parts[0]));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "SystemNameInvalidModule", name, parts[0]), Bundle.getMessage(locale, "SystemNameInvalidModule", name, parts[0]));
            }
            try {
                int bit = Integer.parseInt(parts[1]);
                if (bit < 1 || bit > 8) {
                    throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "SystemNameInvalidBit", name, parts[1]), Bundle.getMessage(locale, "SystemNameInvalidBit", name, parts[1]));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "SystemNameInvalidBit", name, parts[1]), Bundle.getMessage(locale, "SystemNameInvalidBit", name, parts[1]));
            }
            return name;
        }
        return this.validateIntegerSystemNameFormat(name, 1, 1024, locale);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return XNetAddress.validSystemNameFormat(systemName, 'S', this.getSystemPrefix());
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    @Nonnull
    public synchronized String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        if (curAddress.contains(":")) {
            int input;
            int encoderAddress;
            int seperator = curAddress.indexOf(":");
            try {
                encoderAddress = Integer.parseInt(curAddress.substring(0, seperator));
                input = Integer.parseInt(curAddress.substring(seperator + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new JmriException("Unable to convert " + curAddress + " into the cab and input format of nn:xx");
            }
            this.iName = (encoderAddress - 1) * 8 + input;
        } else {
            try {
                this.iName = Integer.parseInt(curAddress);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JmriException("Hardware Address " + curAddress + " should be a number or the cab and input format of nn:xx");
            }
        }
        return String.valueOf(prefix) + this.typeLetter() + this.iName;
    }

    @Override
    public synchronized String getNextValidAddress(@Nonnull String curAddress, @Nonnull String prefix, boolean ignoreInitialExisting) throws JmriException {
        String tmpSName = this.createSystemName(curAddress, prefix);
        Sensor s = this.getBySystemName(tmpSName);
        if (s != null || ignoreInitialExisting) {
            int x = 1;
            while (x < 10) {
                ++this.iName;
                s = this.getBySystemName(String.valueOf(prefix) + this.typeLetter() + this.iName);
                if (s == null) {
                    return Integer.toString(this.iName);
                }
                ++x;
            }
            throw new JmriException(Bundle.getMessage("InvalidNextValidTenInUse", this.getBeanTypeHandled(true), curAddress, this.iName));
        }
        return Integer.toString(this.iName);
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddInputEntryToolTip");
    }
}

