/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz;

import jmri.implementation.AbstractSensor;
import jmri.jmrix.lenz.XNetAddress;
import jmri.jmrix.lenz.XNetListener;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XNetSensor
extends AbstractSensor
implements XNetListener {
    private boolean statusRequested = false;
    private int address;
    private int baseaddress;
    private int nibble;
    private String systemName;
    protected XNetTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(XNetSensor.class);

    public XNetSensor(String systemName, String userName, XNetTrafficController controller, String prefix) {
        super(systemName, userName);
        this.tc = controller;
        this.init(systemName, prefix);
    }

    public XNetSensor(String systemName, XNetTrafficController controller, String prefix) {
        super(systemName);
        this.tc = controller;
        this.init(systemName, prefix);
    }

    private void init(String id, String prefix) {
        this.systemName = id;
        this.address = XNetAddress.getBitFromSystemName(this.systemName, prefix);
        this.baseaddress = (this.address - 1) / 8;
        int temp = (this.address - 1) % 8;
        this.nibble = temp < 4 ? 0 : 16;
        if (log.isDebugEnabled()) {
            log.debug("Created Sensor {} (Address {},  position {})", new Object[]{this.systemName, this.baseaddress, (this.address - 1) % 8 + 1});
        }
        this.tc.getFeedbackMessageCache().requestCachedStateFromLayout(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestUpdateFromLayout() {
        XNetMessage msg = XNetMessage.getFeedbackRequestMsg(this.baseaddress, this.nibble == 0);
        msg.setElement(1, this.baseaddress);
        msg.setParity();
        XNetSensor xNetSensor = this;
        synchronized (xNetSensor) {
            this.statusRequested = true;
        }
        this.tc.sendXNetMessage(msg, null);
    }

    synchronized void initmessage(XNetReply l) {
        boolean oldState = this.statusRequested;
        this.message(l);
        this.statusRequested = oldState;
    }

    @Override
    public synchronized void message(XNetReply l) {
        Boolean opt;
        if (log.isDebugEnabled()) {
            log.debug("received message: {}", (Object)l);
        }
        if ((opt = l.selectModuleFeedback(this.address)) != null) {
            if (log.isDebugEnabled()) {
                log.debug("Message for sensor {} (Address {} position {})", new Object[]{this.systemName, this.baseaddress, this.address - this.baseaddress * 8});
            }
            if (opt ^ this._inverted) {
                this.setOwnState(2);
            } else {
                this.setOwnState(4);
            }
        }
    }

    @Override
    public void message(XNetMessage l) {
    }

    @Override
    public void notifyTimeout(XNetMessage msg) {
        if (log.isDebugEnabled()) {
            log.debug("Notified of timeout on message: {}", (Object)msg);
        }
    }

    int getNumber() {
        return this.address;
    }

    int getBaseAddress() {
        return this.baseaddress;
    }

    int getNibble() {
        return this.nibble;
    }
}

