/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz;

import java.util.Optional;
import java.util.function.Function;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.lenz.Bundle;
import jmri.jmrix.lenz.FeedbackItem;
import jmri.jmrix.lenz.LenzCommandStation;
import jmri.jmrix.lenz.XNetMessage;
import jmri.util.StringUtil;

public class XNetReply
extends AbstractMRReply {
    private static final String RS_TYPE = "rsType";
    private static final String X_NET_REPLY_LI_BAUD = "XNetReplyLIBaud";
    private static final String COLUMN_STATE = "ColumnState";
    private static final String MAKE_LABEL = "MakeLabel";
    private static final String POWER_STATE_ON = "PowerStateOn";
    private static final String POWER_STATE_OFF = "PowerStateOff";
    private static final String FUNCTION_MOMENTARY = "FunctionMomentary";
    private static final String FUNCTION_CONTINUOUS = "FunctionContinuous";
    private static final String BEAN_NAME_TURNOUT = "BeanNameTurnout";
    private static final String X_NET_REPLY_NOT_OPERATED = "XNetReplyNotOperated";
    private static final String X_NET_REPLY_THROWN_LEFT = "XNetReplyThrownLeft";
    private static final String X_NET_REPLY_THROWN_RIGHT = "XNetReplyThrownRight";
    private static final String X_NET_REPLY_INVALID = "XNetReplyInvalid";
    private static final String X_NET_REPLY_CONTACT_LABEL = "XNetReplyContactLabel";
    private static final String SPEED_STEP_MODE_X = "SpeedStepModeX";
    private static final int FEEDBACK_TURNOUT_MASK = 80;
    private static final int FEEDBACK_MODULE_MASK = 112;
    private static final int FEEDBACK_TYPE_FBMODULE = 64;
    private static final int FEEDBACK_HIGH_NIBBLE = 16;

    public XNetReply() {
        this.setBinary(true);
    }

    public XNetReply(XNetReply reply) {
        super(reply);
        this.setBinary(true);
    }

    public XNetReply(XNetMessage message) {
        this.setBinary(true);
        int i = 0;
        while (i < message.getNumDataElements()) {
            this.setElement(i, message.getElement(i));
            ++i;
        }
    }

    public XNetReply(String message) {
        this.setBinary(true);
        byte[] b = StringUtil.bytesFromHexString(message);
        if (b.length == 0) {
            this._nDataChars = 0;
            this._dataChars = null;
            return;
        }
        this._nDataChars = b.length;
        this._dataChars = new int[this._nDataChars];
        int i = 0;
        while (i < b.length) {
            this.setElement(i, b[i] & 0xFF);
            ++i;
        }
    }

    public String getOpCodeHex() {
        return "0x" + Integer.toHexString(this.getOpCode());
    }

    public boolean checkParity() {
        int len = this.getNumDataElements();
        int chksum = 0;
        int loop = 0;
        while (loop < len - 1) {
            chksum ^= this.getElement(loop);
            ++loop;
        }
        return (chksum & 0xFF) == this.getElement(len - 1);
    }

    public void setParity() {
        int len = this.getNumDataElements();
        int chksum = 0;
        int loop = 0;
        while (loop < len - 1) {
            chksum ^= this.getElement(loop);
            ++loop;
        }
        this.setElement(len - 1, chksum & 0xFF);
    }

    public Integer getElementBCD(int n) {
        return Integer.decode(Integer.toHexString(this.getElement(n)));
    }

    @Override
    protected int skipPrefix(int index) {
        return -1;
    }

    public int getTurnoutMsgAddr() {
        if (this.isFeedbackMessage()) {
            return this.getTurnoutAddrFromData(this.getElement(1), this.getElement(2));
        }
        return -1;
    }

    private int getTurnoutAddrFromData(int a1, int a2) {
        if (this.getFeedbackMessageType() > 1) {
            return -1;
        }
        int address = (a1 & 0xFF) * 4 + 1;
        if ((a2 & 0x10) != 0) {
            address += 2;
        }
        return address;
    }

    public int getTurnoutMsgAddr(int startByte) {
        if (this.isFeedbackBroadcastMessage()) {
            int a1 = this.getElement(startByte);
            int a2 = this.getElement(startByte + 1);
            return this.getTurnoutAddrFromData(a1, a2);
        }
        return -1;
    }

    public int getTurnoutStatus(int turnout) {
        if (this.isFeedbackMessage() && (turnout == 0 || turnout == 1)) {
            int a2 = this.getElement(2);
            return this.createFeedbackItem(turnout, a2).getTurnoutStatus();
        }
        return -1;
    }

    public int getTurnoutStatus(int startByte, int turnout) {
        if (this.isFeedbackBroadcastMessage() && (turnout == 0 || turnout == 1)) {
            int a2 = this.getElement(startByte + 1);
            return this.createFeedbackItem(turnout, a2).getTurnoutStatus();
        }
        return -1;
    }

    public int getFeedbackEncoderMsgAddr() {
        if (this.isFeedbackMessage()) {
            int a1 = this.getElement(1);
            int messagetype = this.getFeedbackMessageType();
            if (messagetype == 2) {
                return a1 & 0xFF;
            }
            return -1;
        }
        return -1;
    }

    public final int getFeedbackMessageItems() {
        if (this.isFeedbackMessage()) {
            return 1;
        }
        if (this.isFeedbackBroadcastMessage()) {
            return (this.getElement(0) & 0xF) / 2;
        }
        return 0;
    }

    public int getFeedbackEncoderMsgAddr(int startByte) {
        if (this.isFeedbackBroadcastMessage()) {
            int a1 = this.getElement(startByte);
            int messagetype = this.getFeedbackMessageType(startByte);
            if (messagetype == 2) {
                return a1 & 0xFF;
            }
            return -1;
        }
        return -1;
    }

    public boolean isFeedbackMessage() {
        return this.getElement(0) == 66;
    }

    public boolean isFeedbackBroadcastMessage() {
        return (this.getElement(0) & 0xF0) == 64;
    }

    public int getFeedbackMessageType() {
        if (this.isFeedbackMessage()) {
            int a2 = this.getElement(2);
            return (a2 & 0x60) / 32;
        }
        return -1;
    }

    public int getFeedbackMessageType(int startByte) {
        if (this.isFeedbackBroadcastMessage()) {
            int a2 = this.getElement(startByte + 1);
            return (a2 & 0x60) / 32;
        }
        return -1;
    }

    public boolean isFeedbackMotionComplete(int startByte) {
        int messageType = this.getFeedbackMessageType(startByte);
        if (messageType == 1) {
            int a2 = this.getElement(startByte + 1);
            return (a2 & 0x80) != 128;
        }
        return false;
    }

    public int getThrottleMsgAddr() {
        if (this.isThrottleMessage()) {
            int a1 = this.getElement(2);
            int a2 = this.getElement(3);
            if (a1 == 0) {
                return a2;
            }
            return (a1 * 256 & 0xFF00) + (a2 & 0xFF) - 49152;
        }
        return -1;
    }

    public boolean isThrottleMessage() {
        int message = this.getElement(0);
        return message == 228 || message == 227 || message == 229 || message == 226 || message == 230 || message == 131 || message == 132 || message == 163 || message == 164;
    }

    public boolean isThrottleTakenOverMessage() {
        return this.getElement(0) == 227 && this.getElement(1) == 64;
    }

    public boolean isConsistMessage() {
        int message = this.getElement(0);
        return message == 225 || message == 197 || message == 198;
    }

    public boolean isOkMessage() {
        return this.getElement(0) == 1 && this.getElement(1) == 4;
    }

    public boolean isTimeSlotRestored() {
        return this.getElement(0) == 1 && this.getElement(1) == 7;
    }

    public boolean isTimeSlotRevoked() {
        return this.getElement(0) == 1 && this.getElement(1) == 5;
    }

    public boolean isCSBusyMessage() {
        return this.getElement(0) == 97 && this.getElement(1) == 129;
    }

    public boolean isCSTransferError() {
        return this.getElement(0) == 97 && this.getElement(1) == 128;
    }

    public boolean isUnsupportedError() {
        return this.getElement(0) == 97 && this.getElement(1) == 130;
    }

    public boolean isCommErrorMessage() {
        return this.getElement(0) == 1 && (this.getElement(1) == 3 || this.getElement(1) == 2 || this.getElement(1) == 1 || this.getElement(1) == 10 || this.getElement(1) == 6) || this.isTimeSlotErrorMessage();
    }

    public boolean isTimeSlotErrorMessage() {
        return this.getElement(0) == 1 && (this.getElement(1) == 8 || this.getElement(1) == 7 || this.getElement(1) == 5);
    }

    public boolean isServiceModeResponse() {
        return this.getElement(0) == 99 && (this.getElement(1) == 20 || this.getElement(1) == 21 || this.getElement(1) == 22 || this.getElement(1) == 23 || this.getElement(1) == 16);
    }

    public boolean isPagedModeResponse() {
        return this.getElement(0) == 99 && this.getElement(1) == 16;
    }

    public boolean isDirectModeResponse() {
        return this.getElement(0) == 99 && (this.getElement(1) == 20 || this.getElement(1) == 21 || this.getElement(1) == 22 || this.getElement(1) == 23);
    }

    public int getServiceModeCVNumber() {
        int cv = -1;
        if (this.isServiceModeResponse()) {
            cv = (this.getElement(1) & 0x14) == 20 ? (this.getElement(1) - 20) * 256 + this.getElement(2) : this.getElement(2);
        }
        return cv;
    }

    public int getServiceModeCVValue() {
        int value = -1;
        if (this.isServiceModeResponse()) {
            value = this.getElement(3);
        }
        return value;
    }

    @Override
    public boolean isRetransmittableErrorMsg() {
        return this.isCSBusyMessage() || this.isCommErrorMessage() || this.isCSTransferError();
    }

    @Override
    public boolean isUnsolicited() {
        return super.isUnsolicited() || this.isThrottleTakenOverMessage();
    }

    @Deprecated
    public final void resetUnsolicited() {
    }

    private int findFeedbackData(int baseAddress, int selector, int mask) {
        if (this.isFeedbackMessage()) {
            int data = this.getElement(2);
            if (this.getElement(1) == baseAddress && (data & mask) == selector) {
                return data;
            }
        } else {
            int start = 1;
            int cnt = this.getFeedbackMessageItems();
            while (cnt > 0) {
                int data = this.getElement(start + 1);
                if (this.getElement(start) == baseAddress && (data & mask) == selector) {
                    return data;
                }
                --cnt;
                start += 2;
            }
        }
        return -1;
    }

    @CheckForNull
    public Boolean selectModuleFeedback(int sensorNumber) {
        if (!this.isFeedbackBroadcastMessage() || sensorNumber == 0 || sensorNumber >= 1024) {
            return null;
        }
        int s = sensorNumber - 1;
        int baseAddress = s / 8;
        int selector2 = (s & 4) != 0 ? 80 : 64;
        int res = this.findFeedbackData(baseAddress, selector2, 112);
        return res == -1 ? null : Boolean.valueOf((res & 1 << s % 4) > 0);
    }

    public boolean onTurnoutFeedback(int accessoryNumber, Function<FeedbackItem, Boolean> proc) {
        return this.selectTurnoutFeedback(accessoryNumber).map(proc).orElse(false);
    }

    @Nonnull
    public Optional<FeedbackItem> selectTurnoutFeedback(int accessoryNumber) {
        if (!this.isFeedbackBroadcastMessage() || accessoryNumber <= 0 || accessoryNumber >= 1024) {
            return Optional.empty();
        }
        int a = accessoryNumber - 1;
        int base = a / 4;
        int selector2 = (a & 2) != 0 ? 16 : 0;
        int r = this.findFeedbackData(base, selector2, 80);
        if (r == -1) {
            return Optional.empty();
        }
        FeedbackItem item = new FeedbackItem(this, accessoryNumber, r);
        return Optional.of(item);
    }

    protected final FeedbackItem createFeedbackItem(int n, int d) {
        return new FeedbackItem(this, n, d);
    }

    @Override
    public String toMonitorString() {
        StringBuilder text;
        if (this.getElement(0) == 1) {
            switch (this.getElement(1)) {
                case 1: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyErrorPCtoLI"));
                    break;
                }
                case 2: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyErrorLItoCS"));
                    break;
                }
                case 3: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyErrorUnknown"));
                    break;
                }
                case 4: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyOkMessage"));
                    break;
                }
                case 5: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyErrorNoTimeSlot"));
                    break;
                }
                case 6: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyErrorBufferOverflow"));
                    break;
                }
                case 7: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyTimeSlotRestored"));
                    break;
                }
                case 8: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyRequestSentWhileNoTimeslot"));
                    break;
                }
                case 9: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyBadDataInRequest"));
                    break;
                }
                case 10: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyRetransmitRequest"));
                    break;
                }
                default: {
                    text = new StringBuilder(this.toString());
                    break;
                }
            }
        } else if (this.getElement(0) == 2) {
            text = new StringBuilder(Bundle.getMessage("XNetReplyLIVersion", Float.valueOf(this.getElementBCD(1).floatValue() / 10.0f), Float.valueOf(this.getElementBCD(2).floatValue() / 10.0f)));
        } else if (this.getElement(0) == 242) {
            block12 : switch (this.getElement(1)) {
                case 1: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyLIAddress", this.getElement(2)));
                    break;
                }
                case 2: {
                    switch (this.getElement(2)) {
                        case 1: {
                            text = new StringBuilder(Bundle.getMessage(X_NET_REPLY_LI_BAUD, Bundle.getMessage("LIBaud19200")));
                            break block12;
                        }
                        case 2: {
                            text = new StringBuilder(Bundle.getMessage(X_NET_REPLY_LI_BAUD, Bundle.getMessage("Baud38400")));
                            break block12;
                        }
                        case 3: {
                            text = new StringBuilder(Bundle.getMessage(X_NET_REPLY_LI_BAUD, Bundle.getMessage("Baud57600")));
                            break block12;
                        }
                        case 4: {
                            text = new StringBuilder(Bundle.getMessage(X_NET_REPLY_LI_BAUD, Bundle.getMessage("Baud115200")));
                            break block12;
                        }
                    }
                    text = new StringBuilder(Bundle.getMessage(X_NET_REPLY_LI_BAUD, Bundle.getMessage("BaudOther")));
                    break;
                }
                default: {
                    text = new StringBuilder(this.toString());
                    break;
                }
            }
        } else if (this.getElement(0) == 97) {
            switch (this.getElement(1)) {
                case 1: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyBCNormalOpsResumed"));
                    break;
                }
                case 0: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyBCEverythingOff"));
                    break;
                }
                case 2: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyBCServiceEntry"));
                    break;
                }
                case 18: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyServiceModeShort"));
                    break;
                }
                case 19: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyServiceModeDataByteNotFound"));
                    break;
                }
                case 31: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyServiceModeCSBusy"));
                    break;
                }
                case 17: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyServiceModeCSReady"));
                    break;
                }
                case 129: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyCSBusy"));
                    break;
                }
                case 130: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyCSNotSupported"));
                    break;
                }
                case 128: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyCSTransferError"));
                    break;
                }
                case 131: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyV1DHErrorNotOperated"));
                    break;
                }
                case 132: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyV1DHErrorInUse"));
                    break;
                }
                case 133: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyV1DHErrorAlreadyDH"));
                    break;
                }
                case 134: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyV1DHErrorNonZeroSpeed"));
                    break;
                }
                default: {
                    text = new StringBuilder(this.toString());
                    break;
                }
            }
        } else if (this.getElement(0) == 129 && this.getElement(1) == 0) {
            text = new StringBuilder(Bundle.getMessage("XNetReplyBCEverythingStop"));
        } else if (this.getElement(0) == 99) {
            if (this.isDirectModeResponse()) {
                text = new StringBuilder(Bundle.getMessage("XNetReplyServiceModeDirectResponse", this.getServiceModeCVNumber(), this.getServiceModeCVValue()));
            } else if (this.isPagedModeResponse()) {
                text = new StringBuilder(Bundle.getMessage("XNetReplyServiceModePagedResponse", this.getServiceModeCVNumber(), this.getServiceModeCVValue()));
            } else if (this.getElement(1) == 33) {
                String typeString;
                switch (this.getElement(3)) {
                    case 0: {
                        typeString = Bundle.getMessage("CSTypeLZ100");
                        break;
                    }
                    case 1: {
                        typeString = Bundle.getMessage("CSTypeLH200");
                        break;
                    }
                    case 2: {
                        typeString = Bundle.getMessage("CSTypeCompact");
                        break;
                    }
                    case 16: {
                        typeString = Bundle.getMessage("CSTypeMultiMaus");
                        break;
                    }
                    default: {
                        typeString = "" + this.getElement(3);
                    }
                }
                text = new StringBuilder(Bundle.getMessage("XNetReplyCSVersion", Float.valueOf(this.getElementBCD(2).floatValue() / 10.0f), typeString));
            } else {
                text = new StringBuilder(this.toString());
            }
        } else if (this.getElement(0) == 98) {
            if (this.getElement(1) == 34) {
                text = new StringBuilder(String.valueOf(Bundle.getMessage("XNetReplyCSStatus")) + " ");
                int statusByte = this.getElement(2);
                if ((statusByte & 1) == 1) {
                    text.append(Bundle.getMessage("XNetCSStatusEmergencyOff")).append("; ");
                }
                if ((statusByte & 2) == 2) {
                    text.append(Bundle.getMessage("XNetCSStatusEmergencyStop")).append("; ");
                }
                if ((statusByte & 8) == 8) {
                    text.append(Bundle.getMessage("XNetCSStatusServiceMode")).append("; ");
                }
                if ((statusByte & 0x40) == 64) {
                    text.append(Bundle.getMessage("XNetCSStatusPoweringUp")).append("; ");
                }
                if ((statusByte & 4) == 4) {
                    text.append(Bundle.getMessage("XNetCSStatusPowerModeAuto")).append("; ");
                } else {
                    text.append(Bundle.getMessage("XNetCSStatusPowerModeManual")).append("; ");
                }
                if ((statusByte & 0x80) == 128) {
                    text.append(Bundle.getMessage("XNetCSStatusRamCheck"));
                }
            } else {
                text = this.getElement(1) == 33 ? new StringBuilder(Bundle.getMessage("XNetReplyCSVersionV1", Float.valueOf(this.getElementBCD(2).floatValue() / 10.0f))) : new StringBuilder(this.toString());
            }
        } else if (this.getElement(0) == 225) {
            switch (this.getElement(1)) {
                case 129: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyDHErrorNotOperated"));
                    break;
                }
                case 130: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyDHErrorInUse"));
                    break;
                }
                case 131: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyDHErrorAlreadyDH"));
                    break;
                }
                case 132: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyDHErrorNonZeroSpeed"));
                    break;
                }
                case 133: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyDHErrorLocoNotMU"));
                    break;
                }
                case 134: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyDHErrorLocoNotMUBase"));
                    break;
                }
                case 135: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyDHErrorCanNotDelete"));
                    break;
                }
                case 136: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyDHErrorStackFull"));
                    break;
                }
                default: {
                    text = new StringBuilder(Bundle.getMessage("XNetReplyDHErrorOther", this.getElement(1) - 128));
                    break;
                }
            }
        } else if (this.getElement(0) == 228) {
            if (this.getElement(1) == 81) {
                text = new StringBuilder(String.valueOf(Bundle.getMessage("XNetReplyLocoStatus13Label")) + " ");
                int element3 = this.getElement(2);
                int element4 = this.getElement(3);
                text.append(this.parseFunctionHighMomentaryStatus(element3, element4));
            } else {
                text = new StringBuilder(String.valueOf(Bundle.getMessage("XNetReplyLocoNormalLabel")) + ",");
                text.append(this.parseSpeedAndDirection(this.getElement(1), this.getElement(2))).append(" ");
                int element3 = this.getElement(3);
                int element4 = this.getElement(4);
                text.append(this.parseFunctionStatus(element3, element4));
            }
        } else if (this.getElement(0) == 229) {
            if (this.getElement(1) == 248) {
                text = new StringBuilder(String.valueOf(Bundle.getMessage("XNetReplyLocoEliteSLabel")) + " ");
                text.append(LenzCommandStation.calcLocoAddress(this.getElement(2), this.getElement(3)));
                text.append(",").append(this.parseSpeedAndDirection(this.getElement(4), this.getElement(5))).append(" ");
            } else if (this.getElement(1) == 249) {
                text = new StringBuilder(String.valueOf(Bundle.getMessage("XNetReplyLocoEliteFLabel")) + " ");
                text.append(LenzCommandStation.calcLocoAddress(this.getElement(2), this.getElement(3))).append(" ");
                int element4 = this.getElement(4);
                int element5 = this.getElement(5);
                text.append(this.parseFunctionStatus(element4, element5));
            } else {
                text = new StringBuilder(String.valueOf(Bundle.getMessage("XNetReplyLocoMULabel")) + ",");
                text.append(this.parseSpeedAndDirection(this.getElement(1), this.getElement(2)));
                int element3 = this.getElement(3);
                int element4 = this.getElement(4);
                text.append(this.parseFunctionStatus(element3, element4));
            }
        } else if (this.getElement(0) == 226) {
            text = new StringBuilder(String.valueOf(Bundle.getMessage("XNetReplyLocoMUBaseLabel")) + ",");
            text.append(this.parseSpeedAndDirection(this.getElement(1), this.getElement(2))).append(" ");
        } else if (this.getElement(0) == 230) {
            text = new StringBuilder(String.valueOf(Bundle.getMessage("XNetReplyLocoDHLabel")) + ",");
            text.append(this.parseSpeedAndDirection(this.getElement(1), this.getElement(2))).append(" ");
            int element3 = this.getElement(3);
            int element4 = this.getElement(4);
            text.append(this.parseFunctionStatus(element3, element4));
            text.append(" ").append(Bundle.getMessage("XNetReplyLoco2DHLabel")).append(" ");
            text.append(LenzCommandStation.calcLocoAddress(this.getElement(5), this.getElement(6)));
        } else if (this.getElement(0) == 227) {
            text = new StringBuilder(String.valueOf(Bundle.getMessage("XNetReplyLocoLabel")) + " ");
            switch (this.getElement(1)) {
                case 48: {
                    text.append(Bundle.getMessage("XNetReplySearchNormalLabel")).append(" ");
                    text.append(this.getThrottleMsgAddr());
                    break;
                }
                case 49: {
                    text.append(Bundle.getMessage("XNetReplySearchDHLabel")).append(" ");
                    text.append(this.getThrottleMsgAddr());
                    break;
                }
                case 50: {
                    text.append(Bundle.getMessage("XNetReplySearchMUBaseLabel")).append(" ");
                    text.append(this.getThrottleMsgAddr());
                    break;
                }
                case 51: {
                    text.append(Bundle.getMessage("XNetReplySearchMULabel")).append(" ");
                    text.append(this.getThrottleMsgAddr());
                    break;
                }
                case 52: {
                    text.append(Bundle.getMessage("XNetReplySearchFailedLabel")).append(" ");
                    text.append(this.getThrottleMsgAddr());
                    break;
                }
                case 64: {
                    text.append(Bundle.getMessage(RS_TYPE)).append(" ");
                    text.append(this.getThrottleMsgAddr()).append(" ");
                    text.append(Bundle.getMessage("XNetReplyLocoOperated"));
                    break;
                }
                case 80: {
                    this.locoFunctionStatusText(text);
                    break;
                }
                case 82: {
                    this.locoFunctionStatusHighText(text);
                    break;
                }
                default: {
                    text = new StringBuilder(this.toString());
                    break;
                }
            }
        } else if (this.isFeedbackBroadcastMessage()) {
            text = new StringBuilder().append(Bundle.getMessage("XNetReplyFeedbackLabel")).append(" ");
            int numDataBytes = this.getElement(0) & 0xF;
            int i = 1;
            while (i < numDataBytes) {
                switch (this.getFeedbackMessageType(i)) {
                    case 0: {
                        text.append(this.getTurnoutReplyMonitorString(i, "TurnoutWoFeedback"));
                        break;
                    }
                    case 1: {
                        text.append(this.getTurnoutReplyMonitorString(i, "TurnoutWFeedback"));
                        break;
                    }
                    case 2: {
                        text.append(Bundle.getMessage("XNetReplyFeedbackEncoder")).append(" ").append(this.getFeedbackEncoderMsgAddr(i) + 1);
                        boolean highnibble = (this.getElement(i + 1) & 0x10) == 16;
                        text.append(" ").append(Bundle.getMessage(X_NET_REPLY_CONTACT_LABEL)).append(" ").append(highnibble ? 5 : 1);
                        text.append(" ").append(Bundle.getMessage(MAKE_LABEL, Bundle.getMessage(COLUMN_STATE))).append(" ").append((this.getElement(i + 1) & 1) == 1 ? Bundle.getMessage(POWER_STATE_ON) : Bundle.getMessage(POWER_STATE_OFF));
                        text.append("; ").append(Bundle.getMessage(X_NET_REPLY_CONTACT_LABEL)).append(" ").append(highnibble ? 6 : 2);
                        text.append(" ").append(Bundle.getMessage(MAKE_LABEL, Bundle.getMessage(COLUMN_STATE))).append(" ").append((this.getElement(i + 1) & 2) == 2 ? Bundle.getMessage(POWER_STATE_ON) : Bundle.getMessage(POWER_STATE_OFF));
                        text.append("; ").append(Bundle.getMessage(X_NET_REPLY_CONTACT_LABEL)).append(" ").append(highnibble ? 7 : 3);
                        text.append(" ").append(Bundle.getMessage(MAKE_LABEL, Bundle.getMessage(COLUMN_STATE))).append(" ").append((this.getElement(i + 1) & 4) == 4 ? Bundle.getMessage(POWER_STATE_ON) : Bundle.getMessage(POWER_STATE_OFF));
                        text.append("; ").append(Bundle.getMessage(X_NET_REPLY_CONTACT_LABEL)).append(" ").append(highnibble ? 8 : 4);
                        text.append(" ").append(Bundle.getMessage(MAKE_LABEL, Bundle.getMessage(COLUMN_STATE))).append(" ").append((this.getElement(i + 1) & 8) == 8 ? Bundle.getMessage(POWER_STATE_ON) : Bundle.getMessage(POWER_STATE_OFF));
                        text.append("; ");
                        break;
                    }
                    default: {
                        text.append(this.getElement(i)).append(" ").append(this.getElement(i + 1));
                    }
                }
                i += 2;
            }
        } else {
            text = new StringBuilder(this.toString());
        }
        return text.toString();
    }

    private void locoFunctionStatusHighText(StringBuilder text) {
        text.append(Bundle.getMessage(RS_TYPE)).append(" ");
        text.append(Bundle.getMessage("XNetReplyF13StatusLabel")).append(" ");
        int element3 = this.getElement(2);
        int element4 = this.getElement(3);
        text.append(this.parseFunctionHighStatus(element3, element4));
    }

    private void locoFunctionStatusText(StringBuilder text) {
        text.append(Bundle.getMessage(RS_TYPE)).append(" ");
        text.append(Bundle.getMessage("XNetReplyFStatusLabel")).append(" ");
        int element3 = this.getElement(2);
        int element4 = this.getElement(3);
        text.append(this.parseFunctionMomentaryStatus(element3, element4));
    }

    private String getTurnoutReplyMonitorString(int startByte, String typeBundleKey) {
        StringBuilder text = new StringBuilder();
        int turnoutMsgAddr = this.getTurnoutMsgAddr(startByte);
        Optional<FeedbackItem> feedBackOdd = this.selectTurnoutFeedback(turnoutMsgAddr);
        if (feedBackOdd.isPresent()) {
            FeedbackItem feedbackItem = feedBackOdd.get();
            text.append(this.singleTurnoutMonitorMessage(Bundle.getMessage(typeBundleKey), turnoutMsgAddr, feedbackItem));
            text.append(";");
            FeedbackItem pairedItem = feedbackItem.pairedAccessoryItem();
            text.append(this.singleTurnoutMonitorMessage("", turnoutMsgAddr + 1, pairedItem));
        }
        return text.toString();
    }

    private String singleTurnoutMonitorMessage(String prefix, int turnoutMsgAddr, FeedbackItem feedbackItem) {
        StringBuilder outputBuilder = new StringBuilder();
        outputBuilder.append(prefix).append(" ").append(Bundle.getMessage(MAKE_LABEL, Bundle.getMessage(BEAN_NAME_TURNOUT))).append(" ").append(turnoutMsgAddr).append(" ").append(Bundle.getMessage(MAKE_LABEL, Bundle.getMessage(COLUMN_STATE))).append(" ");
        switch (feedbackItem.getAccessoryStatus()) {
            case 0: {
                outputBuilder.append(Bundle.getMessage(X_NET_REPLY_NOT_OPERATED));
                break;
            }
            case 1: {
                outputBuilder.append(Bundle.getMessage(X_NET_REPLY_THROWN_LEFT));
                break;
            }
            case 2: {
                outputBuilder.append(Bundle.getMessage(X_NET_REPLY_THROWN_RIGHT));
                break;
            }
            default: {
                outputBuilder.append(Bundle.getMessage(X_NET_REPLY_INVALID));
            }
        }
        if (feedbackItem.getType() == 1) {
            outputBuilder.append(" ");
            if (feedbackItem.isMotionComplete()) {
                outputBuilder.append(Bundle.getMessage("XNetReplyMotionComplete"));
            } else {
                outputBuilder.append(Bundle.getMessage("XNetReplyMotionIncomplete"));
            }
        }
        return outputBuilder.toString();
    }

    protected String parseSpeedAndDirection(int element1, int element2) {
        int speedVal;
        String text = "";
        text = (element2 & 0x80) == 128 ? String.valueOf(text) + Bundle.getMessage("Forward") + "," : String.valueOf(text) + Bundle.getMessage("Reverse") + ",";
        if ((element1 & 4) == 4) {
            speedVal = element2 & 0x7F;
            speedVal = speedVal >= 1 ? --speedVal : 0;
            text = String.valueOf(text) + Bundle.getMessage(SPEED_STEP_MODE_X, 128) + ",";
        } else if ((element1 & 2) == 2) {
            speedVal = ((element2 & 0xF) << 1) + ((element2 & 0x10) >> 4);
            speedVal = speedVal >= 3 ? (speedVal -= 3) : 0;
            text = String.valueOf(text) + Bundle.getMessage(SPEED_STEP_MODE_X, 28) + ",";
        } else if ((element1 & 1) == 1) {
            speedVal = ((element2 & 0xF) << 1) + ((element2 & 0x10) >> 4);
            speedVal = speedVal >= 3 ? (speedVal -= 3) : 0;
            text = String.valueOf(text) + Bundle.getMessage(SPEED_STEP_MODE_X, 27) + ",";
        } else {
            speedVal = element2 & 0xF;
            speedVal = speedVal >= 1 ? --speedVal : 0;
            text = String.valueOf(text) + Bundle.getMessage(SPEED_STEP_MODE_X, 14) + ",";
        }
        text = String.valueOf(text) + Bundle.getMessage("SpeedStepLabel") + " " + speedVal + ". ";
        text = (element1 & 8) == 8 ? String.valueOf(text) + Bundle.getMessage("XNetReplyAddressInUse") : String.valueOf(text) + Bundle.getMessage("XNetReplyAddressFree");
        return text;
    }

    protected String parseFunctionStatus(int element3, int element4) {
        String text = "";
        text = (element3 & 0x10) != 0 ? String.valueOf(text) + "F0 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F0 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element3 & 1) != 0 ? String.valueOf(text) + "F1 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F1 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element3 & 2) != 0 ? String.valueOf(text) + "F2 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F2 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element3 & 4) != 0 ? String.valueOf(text) + "F3 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F3 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element3 & 8) != 0 ? String.valueOf(text) + "F4 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F4 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 1) != 0 ? String.valueOf(text) + "F5 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F5 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 2) != 0 ? String.valueOf(text) + "F6 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F6 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 4) != 0 ? String.valueOf(text) + "F7 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F7 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 8) != 0 ? String.valueOf(text) + "F8 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F8 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 0x10) != 0 ? String.valueOf(text) + "F9 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F9 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 0x20) != 0 ? String.valueOf(text) + "F10 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F10 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 0x40) != 0 ? String.valueOf(text) + "F11 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F11 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 0x80) != 0 ? String.valueOf(text) + "F12 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F12 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        return text;
    }

    protected String parseFunctionHighStatus(int element3, int element4) {
        String text = "";
        text = (element3 & 1) != 0 ? String.valueOf(text) + "F13 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F13 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element3 & 2) != 0 ? String.valueOf(text) + "F14 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F14 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element3 & 4) != 0 ? String.valueOf(text) + "F15 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F15 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element3 & 8) != 0 ? String.valueOf(text) + "F16 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F16 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element3 & 0x10) != 0 ? String.valueOf(text) + "F17 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F17 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element3 & 0x20) != 0 ? String.valueOf(text) + "F18 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F18 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element3 & 0x40) != 0 ? String.valueOf(text) + "F19 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F19 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element3 & 0x80) != 0 ? String.valueOf(text) + "F20 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F20 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 1) != 0 ? String.valueOf(text) + "F21 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F21 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 2) != 0 ? String.valueOf(text) + "F22 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F22 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 4) != 0 ? String.valueOf(text) + "F23 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F23 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 8) != 0 ? String.valueOf(text) + "F24 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F24 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 0x10) != 0 ? String.valueOf(text) + "F25 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F25 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 0x20) != 0 ? String.valueOf(text) + "F26 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F26 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 0x40) != 0 ? String.valueOf(text) + "F27 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F27 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 0x80) != 0 ? String.valueOf(text) + "F28 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F28 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        return text;
    }

    protected String parseFunctionMomentaryStatus(int element3, int element4) {
        String text = "";
        text = (element3 & 0x10) != 0 ? String.valueOf(text) + "F0 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; " : String.valueOf(text) + "F0 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; ";
        text = (element3 & 1) != 0 ? String.valueOf(text) + "F1 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; " : String.valueOf(text) + "F1 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; ";
        text = (element3 & 2) != 0 ? String.valueOf(text) + "F2 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; " : String.valueOf(text) + "F2 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; ";
        text = (element3 & 4) != 0 ? String.valueOf(text) + "F3 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; " : String.valueOf(text) + "F3 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; ";
        text = (element3 & 8) != 0 ? String.valueOf(text) + "F4 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; " : String.valueOf(text) + "F4 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; ";
        text = (element4 & 1) != 0 ? String.valueOf(text) + "F5 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; " : String.valueOf(text) + "F5 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; ";
        text = (element4 & 2) != 0 ? String.valueOf(text) + "F6 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; " : String.valueOf(text) + "F6 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; ";
        text = (element4 & 4) != 0 ? String.valueOf(text) + "F7 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; " : String.valueOf(text) + "F7 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; ";
        text = (element4 & 8) != 0 ? String.valueOf(text) + "F8 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; " : String.valueOf(text) + "F8 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; ";
        text = (element4 & 0x10) != 0 ? String.valueOf(text) + "F9 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; " : String.valueOf(text) + "F9 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; ";
        text = (element4 & 0x20) != 0 ? String.valueOf(text) + "F10 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; " : String.valueOf(text) + "F10 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; ";
        text = (element4 & 0x40) != 0 ? String.valueOf(text) + "F11 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; " : String.valueOf(text) + "F11 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; ";
        text = (element4 & 0x80) != 0 ? String.valueOf(text) + "F12 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; " : String.valueOf(text) + "F12 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; ";
        return text;
    }

    protected String parseFunctionHighMomentaryStatus(int element3, int element4) {
        String text = "";
        text = (element3 & 1) != 0 ? String.valueOf(text) + "F13 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; " : String.valueOf(text) + "F13 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; ";
        text = (element3 & 2) != 0 ? String.valueOf(text) + "F14 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; " : String.valueOf(text) + "F14 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; ";
        text = (element3 & 4) != 0 ? String.valueOf(text) + "F15 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; " : String.valueOf(text) + "F15 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; ";
        text = (element3 & 8) != 0 ? String.valueOf(text) + "F16 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; " : String.valueOf(text) + "F16 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; ";
        text = (element3 & 0x10) != 0 ? String.valueOf(text) + "F17 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; " : String.valueOf(text) + "F17 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; ";
        text = (element3 & 0x20) != 0 ? String.valueOf(text) + "F18 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; " : String.valueOf(text) + "F18 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; ";
        text = (element3 & 0x40) != 0 ? String.valueOf(text) + "F19 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; " : String.valueOf(text) + "F19 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; ";
        text = (element3 & 0x80) != 0 ? String.valueOf(text) + "F20 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; " : String.valueOf(text) + "F20 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; ";
        text = (element4 & 1) != 0 ? String.valueOf(text) + "F21 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; " : String.valueOf(text) + "F21 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; ";
        text = (element4 & 2) != 0 ? String.valueOf(text) + "F22 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; " : String.valueOf(text) + "F22 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; ";
        text = (element4 & 4) != 0 ? String.valueOf(text) + "F23 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; " : String.valueOf(text) + "F23 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; ";
        text = (element4 & 8) != 0 ? String.valueOf(text) + "F24 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; " : String.valueOf(text) + "F24 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; ";
        text = (element4 & 0x10) != 0 ? String.valueOf(text) + "F25 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; " : String.valueOf(text) + "F25 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; ";
        text = (element4 & 0x20) != 0 ? String.valueOf(text) + "F26 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; " : String.valueOf(text) + "F26 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; ";
        text = (element4 & 0x40) != 0 ? String.valueOf(text) + "F27 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; " : String.valueOf(text) + "F27 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; ";
        text = (element4 & 0x80) != 0 ? String.valueOf(text) + "F28 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; " : String.valueOf(text) + "F28 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; ";
        return text;
    }
}

