/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz;

import jmri.JmriException;
import jmri.jmrix.lenz.XNetListener;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetSystemConnectionMemo;
import jmri.jmrix.lenz.XNetTrafficController;
import jmri.managers.AbstractPowerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XNetPowerManager
extends AbstractPowerManager<XNetSystemConnectionMemo>
implements XNetListener {
    XNetTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(XNetPowerManager.class);

    public XNetPowerManager(XNetSystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getXNetTrafficController();
        this.tc.addXNetListener(2, this);
        this.tc.sendXNetMessage(XNetMessage.getCSStatusRequestMessage(), this);
    }

    @Override
    public boolean implementsIdle() {
        return true;
    }

    @Override
    public void setPower(int v) throws JmriException {
        int old = this.power;
        this.power = 1;
        this.checkTC();
        switch (v) {
            case 2: {
                this.tc.sendXNetMessage(XNetMessage.getResumeOperationsMsg(), this);
                break;
            }
            case 4: {
                this.tc.sendXNetMessage(XNetMessage.getEmergencyOffMsg(), this);
                break;
            }
            case 8: {
                this.tc.sendXNetMessage(XNetMessage.getEmergencyStopMsg(), this);
                break;
            }
        }
        this.firePowerPropertyChange(old, this.power);
    }

    @Override
    public void dispose() {
        this.tc.removeXNetListener(2, this);
        this.tc = null;
    }

    private void checkTC() throws JmriException {
        if (this.tc == null) {
            throw new JmriException("attempt to use PowerManager after dispose");
        }
    }

    @Override
    public void message(XNetReply m) {
        int old = this.power;
        log.debug("Message received: {}", (Object)m);
        if (m.getElement(0) == 97 && m.getElement(1) == 1) {
            this.power = 2;
        } else if (m.getElement(0) == 97 && m.getElement(1) == 0) {
            this.power = 4;
        } else if (m.getElement(0) == 129 && m.getElement(1) == 0) {
            this.power = 8;
        } else if (m.getElement(0) == 97 && m.getElement(1) == 2) {
            this.power = 4;
        } else if (m.getElement(0) == 98 && m.getElement(1) == 34) {
            int statusByte = m.getElement(2);
            this.power = (statusByte & 1) == 1 ? 4 : ((statusByte & 2) == 2 ? 8 : ((statusByte & 8) == 8 ? 4 : ((statusByte & 0x40) == 64 ? 4 : 2)));
        }
        this.firePowerPropertyChange(old, this.power);
    }

    @Override
    public void message(XNetMessage l) {
    }

    @Override
    public void notifyTimeout(XNetMessage msg) {
        log.debug("Notified of timeout on message{}", (Object)msg);
    }
}

