/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz;

import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.lenz.LenzCommandStation;
import jmri.jmrix.lenz.XNetListener;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetPortController;
import jmri.jmrix.lenz.XNetTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XNetPacketizer
extends XNetTrafficController {
    private static final Logger log = LoggerFactory.getLogger(XNetPacketizer.class);

    public XNetPacketizer(LenzCommandStation pCommandStation) {
        super(pCommandStation);
    }

    @Override
    public void sendXNetMessage(XNetMessage m, XNetListener reply) {
        if (m.length() != 0) {
            this.sendMessage(m, reply);
            Thread.yield();
        }
    }

    @Override
    protected void addTrailerToOutput(byte[] msg, int offset, AbstractMRMessage m) {
        if (m.getNumDataElements() == 0) {
            return;
        }
        ((XNetMessage)m).setParity();
        msg[offset - 1] = (byte)m.getElement(m.getNumDataElements() - 1);
    }

    @Override
    public boolean portReadyToSend(AbstractPortController p) {
        if (!(p instanceof XNetPortController)) {
            return false;
        }
        if (((XNetPortController)((Object)p)).okToSend()) {
            ((XNetPortController)((Object)p)).setOutputBufferEmpty(false);
            return true;
        }
        log.debug("XpressNet port not ready to receive");
        return false;
    }
}

