/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.AddressedProgrammer;
import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.AbstractProgrammer;
import jmri.jmrix.lenz.LenzCommandStation;
import jmri.jmrix.lenz.XNetListener;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetTrafficController;
import jmri.util.WaitHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XNetOpsModeProgrammer
extends AbstractProgrammer
implements XNetListener,
AddressedProgrammer {
    protected final int mAddressHigh;
    protected final int mAddressLow;
    protected final int mAddress;
    protected int progState = 0;
    protected int value;
    protected ProgListener progListener = null;
    protected static final int NOTPROGRAMMING = 0;
    protected static final int REQUESTSENT = 1;
    protected XNetTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(XNetOpsModeProgrammer.class);

    public XNetOpsModeProgrammer(int pAddress, XNetTrafficController controller) {
        this.tc = controller;
        if (log.isDebugEnabled()) {
            log.debug("Creating Ops Mode Programmer for Address {}", (Object)pAddress);
        }
        this.mAddressLow = LenzCommandStation.getDCCAddressLow(pAddress);
        this.mAddressHigh = LenzCommandStation.getDCCAddressHigh(pAddress);
        this.mAddress = pAddress;
        if (log.isDebugEnabled()) {
            log.debug("High Address: {} Low Address: {}", (Object)this.mAddressHigh, (Object)this.mAddressLow);
        }
        this.tc.addXNetListener(3, this);
    }

    @Override
    public synchronized void writeCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        XNetMessage msg = XNetMessage.getWriteOpsModeCVMsg(this.mAddressHigh, this.mAddressLow, CV, val);
        this.tc.sendXNetMessage(msg, this);
        this.progListener = p;
        this.value = val;
        this.progState = 1;
        this.restartTimer(msg.getTimeout());
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        XNetMessage msg = XNetMessage.getVerifyOpsModeCVMsg(this.mAddressHigh, this.mAddressLow, CV, this.value);
        this.tc.sendXNetMessage(msg, this);
        this.notifyProgListenerEnd(p, CV, 8);
    }

    @Override
    public void confirmCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        XNetMessage msg = XNetMessage.getVerifyOpsModeCVMsg(this.mAddressHigh, this.mAddressLow, CV, val);
        this.tc.sendXNetMessage(msg, this);
        this.notifyProgListenerEnd(p, val, 8);
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        ArrayList<ProgrammingMode> ret = new ArrayList<ProgrammingMode>();
        ret.add(ProgrammingMode.OPSBYTEMODE);
        return ret;
    }

    @Override
    public boolean getCanRead() {
        return super.getCanRead();
    }

    @Override
    public synchronized void message(XNetReply l) {
        if (this.progState != 0 && this.progState == 1) {
            if (l.isOkMessage()) {
                new WaitHandler(this, 250L);
                this.progState = 0;
                this.stopTimer();
                this.notifyProgListenerEnd(this.progListener, this.value, 0);
            } else if (!l.isRetransmittableErrorMsg()) {
                if (l.getElement(0) == 97 && l.getElement(1) == 130) {
                    this.progState = 0;
                    this.stopTimer();
                    this.notifyProgListenerEnd(this.progListener, this.value, 8);
                } else {
                    this.progState = 0;
                    this.stopTimer();
                    this.notifyProgListenerEnd(this.progListener, this.value, 1);
                }
            }
        }
    }

    @Override
    public boolean getLongAddress() {
        return true;
    }

    @Override
    public int getAddressNumber() {
        return this.mAddress;
    }

    @Override
    public String getAddress() {
        return this.getAddressNumber() + " " + this.getLongAddress();
    }

    @Override
    public synchronized void message(XNetMessage l) {
    }

    @Override
    public void notifyTimeout(XNetMessage msg) {
        if (log.isDebugEnabled()) {
            log.debug("Notified of timeout on message{}", (Object)msg.toString());
        }
    }

    @Override
    protected synchronized void timeout() {
        if (this.progState != 0) {
            if (log.isDebugEnabled()) {
                log.debug("timeout!");
            }
            this.progState = 0;
            if (this.getCanRead()) {
                this.notifyProgListenerEnd(this.progListener, this.value, 128);
            } else {
                this.notifyProgListenerEnd(this.progListener, this.value, 0);
            }
        }
    }
}

