/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz;

import java.io.Serializable;
import jmri.SpeedStepMode;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.lenz.Bundle;
import jmri.jmrix.lenz.LenzCommandStation;
import jmri.jmrix.lenz.XNetReply;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XNetMessage
extends AbstractMRMessage
implements Serializable {
    private static final String X_NET_MESSAGE_REQUEST_LI_BAUD = "XNetMessageRequestLIBaud";
    private static final String X_NET_MESSAGE_REQUEST_SERVICE_MODE_READ_DIRECT_V_36 = "XNetMessageRequestServiceModeReadDirectV36";
    private static final String X_NET_MESSAGE_REQUEST_SERVICE_MODE_WRITE_DIRECT_V_36 = "XNetMessageRequestServiceModeWriteDirectV36";
    private static final String FORWARD = "Forward";
    private static final String REVERSE = "Reverse";
    private static final String X_NET_MESSAGE_SET_SPEED = "XNetMessageSetSpeed";
    private static final String X_NET_MESSAGE_SET_DIRECTION = "XNetMessageSetDirection";
    private static final String X_NET_MESSAGE_SET_FUNCTION_GROUP_X = "XNetMessageSetFunctionGroupX";
    private static final String POWER_STATE_ON = "PowerStateOn";
    private static final String POWER_STATE_OFF = "PowerStateOff";
    private static final String SPEED_STEP_MODE_X = "SpeedStepModeX";
    private static final String X_NET_MESSAGE_SET_FUNCTION_GROUP_X_MOMENTARY = "XNetMessageSetFunctionGroupXMomentary";
    private static final String FUNCTION_CONTINUOUS = "FunctionContinuous";
    private static final String FUNCTION_MOMENTARY = "FunctionMomentary";
    private static int _nRetries = 5;
    protected static final int XNetProgrammingTimeout = 10000;
    private static int XNetMessageTimeout = 5000;
    private boolean broadcastReply = false;
    private static final Logger log = LoggerFactory.getLogger(XNetMessage.class);

    public XNetMessage(int len) {
        super(len);
        if (len > 15) {
            log.error("Invalid length in ctor: {}", (Object)len);
            throw new IllegalArgumentException("Invalid length in ctor: " + len);
        }
        this.setBinary(true);
        this.setRetries(_nRetries);
        this.setTimeout(XNetMessageTimeout);
        this._nDataChars = len;
    }

    public XNetMessage(XNetMessage message) {
        super(message);
        this.setBinary(true);
        this.setRetries(_nRetries);
        this.setTimeout(XNetMessageTimeout);
    }

    public XNetMessage(XNetReply message) {
        super(message.getNumDataElements());
        this.setBinary(true);
        this.setRetries(_nRetries);
        this.setTimeout(XNetMessageTimeout);
        int i = 0;
        while (i < message.getNumDataElements()) {
            this.setElement(i, message.getElement(i));
            ++i;
        }
    }

    public XNetMessage(String s) {
        this.setBinary(true);
        this.setRetries(_nRetries);
        this.setTimeout(XNetMessageTimeout);
        byte[] b = StringUtil.bytesFromHexString(s);
        if (b.length == 0) {
            this._nDataChars = 0;
            this._dataChars = null;
            return;
        }
        this._nDataChars = b.length;
        this._dataChars = new int[this._nDataChars];
        int i = 0;
        while (i < b.length) {
            this.setElement(i, b[i]);
            ++i;
        }
    }

    @Override
    public void setOpCode(int i) {
        if (i > 15 || i < 0) {
            log.error("Opcode invalid: {}", (Object)i);
        }
        this.setElement(0, i * 16 & 0xF0 | this.getNumDataElements() - 2 & 0xF);
    }

    @Override
    public int getOpCode() {
        return this.getElement(0) / 16 & 0xF;
    }

    @Override
    public String getOpCodeHex() {
        return "0x" + Integer.toHexString(this.getOpCode());
    }

    public boolean checkParity() {
        int len = this.getNumDataElements();
        int chksum = 0;
        int loop = 0;
        while (loop < len - 1) {
            chksum ^= this.getElement(loop);
            ++loop;
        }
        return (chksum & 0xFF) == this.getElement(len - 1);
    }

    public void setParity() {
        int len = this.getNumDataElements();
        int chksum = 0;
        int loop = 0;
        while (loop < len - 1) {
            chksum ^= this.getElement(loop);
            ++loop;
        }
        this.setElement(len - 1, chksum & 0xFF);
    }

    public Integer getElementBCD(int n) {
        return Integer.decode(Integer.toHexString(this.getElement(n)));
    }

    public int length() {
        return this._nDataChars;
    }

    public static void setXNetMessageRetries(int t) {
        _nRetries = t;
    }

    public static void setXNetMessageTimeout(int t) {
        XNetMessageTimeout = t;
    }

    @Override
    public boolean replyExpected() {
        return !this.broadcastReply;
    }

    public void setBroadcastReply() {
        this.broadcastReply = true;
    }

    public static XNetMessage getNMRAXNetMsg(byte[] packet) {
        XNetMessage msg = new XNetMessage(packet.length + 2);
        msg.setOpCode(14);
        msg.setElement(1, 48);
        int i = 0;
        while (i < packet.length) {
            msg.setElement(i + 2, packet[i] & 0xFF);
            ++i;
        }
        msg.setParity();
        return msg;
    }

    public static XNetMessage getTurnoutCommandMsg(int pNumber, boolean pClose, boolean pThrow, boolean pOn) {
        XNetMessage l = new XNetMessage(4);
        l.setElement(0, 82);
        int hiadr = (pNumber - 1) / 4;
        int loadr = (pNumber - 1 - hiadr * 4) * 2;
        loadr = !pOn ? (loadr |= 0x80) : (loadr |= 0x88);
        if (pThrow) {
            loadr |= 1;
        }
        if (pClose && pThrow) {
            log.error("XpressNet turnout logic can't handle both THROWN and CLOSED yet");
        }
        l.setElement(1, hiadr);
        l.setElement(2, loadr);
        l.setParity();
        return l;
    }

    public static XNetMessage getFeedbackRequestMsg(int pNumber, boolean pLowerNibble) {
        XNetMessage l = new XNetMessage(4);
        l.setBroadcastReply();
        l.setElement(0, 66);
        l.setElement(1, (pNumber - 1) / 4);
        if (pLowerNibble) {
            l.setElement(2, 128);
        } else {
            l.setElement(2, 129);
        }
        l.setParity();
        return l;
    }

    public static XNetMessage getServiceModeResultsMsg() {
        XNetMessage m = new XNetMessage(3);
        m.setNeededMode(4);
        m.setTimeout(10000);
        m.setElement(0, 33);
        m.setElement(1, 16);
        m.setParity();
        return m;
    }

    public static XNetMessage getExitProgModeMsg() {
        XNetMessage m = new XNetMessage(3);
        m.setNeededMode(4);
        m.setElement(0, 33);
        m.setElement(1, 129);
        m.setParity();
        return m;
    }

    public static XNetMessage getReadPagedCVMsg(int cv) {
        XNetMessage m = new XNetMessage(4);
        m.setNeededMode(4);
        m.setTimeout(10000);
        m.setElement(0, 34);
        m.setElement(1, 20);
        m.setElement(2, 0xFF & cv);
        m.setParity();
        return m;
    }

    public static XNetMessage getReadDirectCVMsg(int cv) {
        XNetMessage m = new XNetMessage(4);
        m.setNeededMode(4);
        m.setTimeout(10000);
        m.setElement(0, 34);
        if (cv < 256) {
            m.setElement(1, 21);
        } else if (cv == 1024) {
            m.setElement(1, 24);
        } else {
            m.setElement(1, 0x18 | (cv & 0x300) >> 8);
        }
        m.setElement(2, 0xFF & cv);
        m.setParity();
        return m;
    }

    public static XNetMessage getWritePagedCVMsg(int cv, int val) {
        XNetMessage m = new XNetMessage(5);
        m.setNeededMode(4);
        m.setTimeout(10000);
        m.setElement(0, 35);
        m.setElement(1, 23);
        m.setElement(2, 0xFF & cv);
        m.setElement(3, val);
        m.setParity();
        return m;
    }

    public static XNetMessage getWriteDirectCVMsg(int cv, int val) {
        XNetMessage m = new XNetMessage(5);
        m.setNeededMode(4);
        m.setTimeout(10000);
        m.setElement(0, 35);
        if (cv < 256) {
            m.setElement(1, 22);
        } else if (cv == 1024) {
            m.setElement(1, 28);
        } else {
            m.setElement(1, 0x1C | (cv & 0x300) >> 8);
        }
        m.setElement(2, 0xFF & cv);
        m.setElement(3, val);
        m.setParity();
        return m;
    }

    public static XNetMessage getReadRegisterMsg(int reg) {
        if (reg > 8) {
            log.error("register number too large: {}", (Object)reg);
        }
        XNetMessage m = new XNetMessage(4);
        m.setNeededMode(4);
        m.setTimeout(10000);
        m.setElement(0, 34);
        m.setElement(1, 17);
        m.setElement(2, 0xF & reg);
        m.setParity();
        return m;
    }

    public static XNetMessage getWriteRegisterMsg(int reg, int val) {
        if (reg > 8) {
            log.error("register number too large: {}", (Object)reg);
        }
        XNetMessage m = new XNetMessage(5);
        m.setNeededMode(4);
        m.setTimeout(10000);
        m.setElement(0, 35);
        m.setElement(1, 18);
        m.setElement(2, 0xF & reg);
        m.setElement(3, val);
        m.setParity();
        return m;
    }

    public static XNetMessage getWriteOpsModeCVMsg(int AH, int AL2, int cv, int val) {
        XNetMessage m = new XNetMessage(8);
        m.setElement(0, 230);
        m.setElement(1, 48);
        m.setElement(2, AH);
        m.setElement(3, AL2);
        int temp = cv - 1 & 0x300;
        m.setElement(4, 236 + (temp /= 255));
        m.setElement(5, (0xFF & cv) - 1);
        m.setElement(6, val);
        m.setParity();
        return m;
    }

    public static XNetMessage getVerifyOpsModeCVMsg(int AH, int AL2, int cv, int val) {
        XNetMessage m = new XNetMessage(8);
        m.setElement(0, 230);
        m.setElement(1, 48);
        m.setElement(2, AH);
        m.setElement(3, AL2);
        int temp = cv - 1 & 0x300;
        m.setElement(4, 228 + (temp /= 255));
        m.setElement(5, (0xFF & cv) - 1);
        m.setElement(6, val);
        m.setParity();
        return m;
    }

    public static XNetMessage getBitWriteOpsModeCVMsg(int AH, int AL2, int cv, int bit, boolean value) {
        XNetMessage m = new XNetMessage(8);
        m.setElement(0, 230);
        m.setElement(1, 48);
        m.setElement(2, AH);
        m.setElement(3, AL2);
        int temp = cv - 1 & 0x300;
        m.setElement(4, 232 + (temp /= 255));
        m.setElement(5, (0xFF & cv) - 1);
        if (value) {
            m.setElement(6, 0xE8 | bit & 0xFF);
        } else {
            m.setElement(6, 0xE0 | bit & 0xFF);
        }
        m.setParity();
        return m;
    }

    public static XNetMessage getBitVerifyOpsModeCVMsg(int AH, int AL2, int cv, int bit, boolean value) {
        XNetMessage m = new XNetMessage(8);
        m.setElement(0, 230);
        m.setElement(1, 48);
        m.setElement(2, AH);
        m.setElement(3, AL2);
        int temp = cv - 1 & 0x300;
        m.setElement(4, 232 + (temp /= 255));
        m.setElement(5, (0xFF & cv) - 1);
        if (value) {
            m.setElement(6, 0xF8 | bit & 0xFF);
        } else {
            m.setElement(6, 0xF0 | bit & 0xFF);
        }
        m.setParity();
        return m;
    }

    public static XNetMessage getBuildDoubleHeaderMsg(int address1, int address2) {
        XNetMessage msg = new XNetMessage(7);
        msg.setElement(0, 229);
        msg.setElement(1, 67);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address1));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address1));
        msg.setElement(4, LenzCommandStation.getDCCAddressHigh(address2));
        msg.setElement(5, LenzCommandStation.getDCCAddressLow(address2));
        msg.setParity();
        return msg;
    }

    public static XNetMessage getDisolveDoubleHeaderMsg(int address) {
        return XNetMessage.getBuildDoubleHeaderMsg(address, 0);
    }

    public static XNetMessage getAddLocoToConsistMsg(int consist, int address, boolean isNormalDir) {
        XNetMessage msg = new XNetMessage(6);
        msg.setElement(0, 228);
        if (isNormalDir) {
            msg.setElement(1, 64);
        } else {
            msg.setElement(1, 65);
        }
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        msg.setElement(4, consist);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getRemoveLocoFromConsistMsg(int consist, int address) {
        XNetMessage msg = new XNetMessage(6);
        msg.setElement(0, 228);
        msg.setElement(1, 66);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        msg.setElement(4, consist);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getNextAddressOnStackMsg(int address, boolean searchForward) {
        XNetMessage msg = new XNetMessage(5);
        msg.setElement(0, 227);
        if (searchForward) {
            msg.setElement(1, 5);
        } else {
            msg.setElement(1, 6);
        }
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        msg.setParity();
        return msg;
    }

    public static XNetMessage getDBSearchMsgConsistAddress(int address, boolean searchForward) {
        XNetMessage msg = new XNetMessage(4);
        msg.setElement(0, 226);
        if (searchForward) {
            msg.setElement(1, 3);
        } else {
            msg.setElement(1, 4);
        }
        msg.setElement(2, address);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getDBSearchMsgNextMULoco(int consist, int address, boolean searchForward) {
        XNetMessage msg = new XNetMessage(6);
        msg.setElement(0, 228);
        if (searchForward) {
            msg.setElement(1, 1);
        } else {
            msg.setElement(1, 2);
        }
        msg.setElement(2, consist);
        msg.setElement(3, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(4, LenzCommandStation.getDCCAddressLow(address));
        msg.setParity();
        return msg;
    }

    public static XNetMessage getDeleteAddressOnStackMsg(int address) {
        XNetMessage msg = new XNetMessage(5);
        msg.setElement(0, 227);
        msg.setElement(1, 68);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        msg.setParity();
        return msg;
    }

    public static XNetMessage getLocomotiveInfoRequestMsg(int address) {
        XNetMessage msg = new XNetMessage(5);
        msg.setElement(0, 227);
        msg.setElement(1, 0);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        msg.setParity();
        return msg;
    }

    public static XNetMessage getLocomotiveFunctionStatusMsg(int address) {
        XNetMessage msg = new XNetMessage(5);
        msg.setElement(0, 227);
        msg.setElement(1, 7);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        msg.setParity();
        return msg;
    }

    public static XNetMessage getLocomotiveFunctionHighOnStatusMsg(int address) {
        XNetMessage msg = new XNetMessage(5);
        msg.setElement(0, 227);
        msg.setElement(1, 9);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        msg.setParity();
        return msg;
    }

    public static XNetMessage getLocomotiveFunctionHighMomStatusMsg(int address) {
        XNetMessage msg = new XNetMessage(5);
        msg.setElement(0, 227);
        msg.setElement(1, 8);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        msg.setParity();
        return msg;
    }

    public static XNetMessage getAddressedEmergencyStop(int address) {
        XNetMessage msg = new XNetMessage(4);
        msg.setElement(0, 146);
        msg.setElement(1, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(2, LenzCommandStation.getDCCAddressLow(address));
        msg.setParity();
        return msg;
    }

    public static XNetMessage getSpeedAndDirectionMsg(int address, SpeedStepMode speedStepMode, float speed, boolean isForward) {
        XNetMessage msg = new XNetMessage(6);
        msg.setElement(0, 228);
        int element4value = 0;
        if (speedStepMode == SpeedStepMode.NMRA_DCC_128) {
            msg.setElement(1, 19);
            int speedVal = Math.round(speed * 126.0f);
            if (speedVal >= 1) {
                element4value = speedVal + 1;
            }
        } else if (speedStepMode == SpeedStepMode.NMRA_DCC_28) {
            msg.setElement(1, 18);
            int speedVal = Math.round(speed * 28.0f);
            if (speedVal >= 1) {
                speedVal += 3;
            }
            element4value = ((speedVal & 0x1E) >> 1) + ((speedVal & 1) << 4);
        } else if (speedStepMode == SpeedStepMode.NMRA_DCC_27) {
            msg.setElement(1, 17);
            int speedVal = Math.round(speed * 27.0f);
            if (speedVal >= 1) {
                speedVal += 3;
            }
            element4value = ((speedVal & 0x1E) >> 1) + ((speedVal & 1) << 4);
        } else {
            msg.setElement(1, 16);
            element4value = (int)(speed * 14.0f);
            int speedVal = Math.round(speed * 14.0f);
            if (speedVal >= 1) {
                ++element4value;
            }
        }
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        if (isForward) {
            element4value += 128;
        }
        msg.setElement(4, element4value);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getFunctionGroup1OpsMsg(int address, boolean f0, boolean f1, boolean f2, boolean f3, boolean f4) {
        XNetMessage msg = new XNetMessage(6);
        msg.setElement(0, 228);
        msg.setElement(1, 32);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        int element4value = 0;
        if (f0) {
            element4value += 16;
        }
        if (f1) {
            ++element4value;
        }
        if (f2) {
            element4value += 2;
        }
        if (f3) {
            element4value += 4;
        }
        if (f4) {
            element4value += 8;
        }
        msg.setElement(4, element4value);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getFunctionGroup1SetMomMsg(int address, boolean f0, boolean f1, boolean f2, boolean f3, boolean f4) {
        XNetMessage msg = new XNetMessage(6);
        msg.setElement(0, 228);
        msg.setElement(1, 36);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        int element4value = 0;
        if (f0) {
            element4value += 16;
        }
        if (f1) {
            ++element4value;
        }
        if (f2) {
            element4value += 2;
        }
        if (f3) {
            element4value += 4;
        }
        if (f4) {
            element4value += 8;
        }
        msg.setElement(4, element4value);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getFunctionGroup2OpsMsg(int address, boolean f5, boolean f6, boolean f7, boolean f8) {
        XNetMessage msg = new XNetMessage(6);
        msg.setElement(0, 228);
        msg.setElement(1, 33);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        int element4value = 0;
        if (f5) {
            ++element4value;
        }
        if (f6) {
            element4value += 2;
        }
        if (f7) {
            element4value += 4;
        }
        if (f8) {
            element4value += 8;
        }
        msg.setElement(4, element4value);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getFunctionGroup2SetMomMsg(int address, boolean f5, boolean f6, boolean f7, boolean f8) {
        XNetMessage msg = new XNetMessage(6);
        msg.setElement(0, 228);
        msg.setElement(1, 37);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        int element4value = 0;
        if (f5) {
            ++element4value;
        }
        if (f6) {
            element4value += 2;
        }
        if (f7) {
            element4value += 4;
        }
        if (f8) {
            element4value += 8;
        }
        msg.setElement(4, element4value);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getFunctionGroup3OpsMsg(int address, boolean f9, boolean f10, boolean f11, boolean f12) {
        XNetMessage msg = new XNetMessage(6);
        msg.setElement(0, 228);
        msg.setElement(1, 34);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        int element4value = 0;
        if (f9) {
            ++element4value;
        }
        if (f10) {
            element4value += 2;
        }
        if (f11) {
            element4value += 4;
        }
        if (f12) {
            element4value += 8;
        }
        msg.setElement(4, element4value);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getFunctionGroup3SetMomMsg(int address, boolean f9, boolean f10, boolean f11, boolean f12) {
        XNetMessage msg = new XNetMessage(6);
        msg.setElement(0, 228);
        msg.setElement(1, 38);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        int element4value = 0;
        if (f9) {
            ++element4value;
        }
        if (f10) {
            element4value += 2;
        }
        if (f11) {
            element4value += 4;
        }
        if (f12) {
            element4value += 8;
        }
        msg.setElement(4, element4value);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getFunctionGroup4OpsMsg(int address, boolean f13, boolean f14, boolean f15, boolean f16, boolean f17, boolean f18, boolean f19, boolean f20) {
        XNetMessage msg = new XNetMessage(6);
        msg.setElement(0, 228);
        msg.setElement(1, 35);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        int element4value = 0;
        if (f13) {
            ++element4value;
        }
        if (f14) {
            element4value += 2;
        }
        if (f15) {
            element4value += 4;
        }
        if (f16) {
            element4value += 8;
        }
        if (f17) {
            element4value += 16;
        }
        if (f18) {
            element4value += 32;
        }
        if (f19) {
            element4value += 64;
        }
        if (f20) {
            element4value += 128;
        }
        msg.setElement(4, element4value);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getFunctionGroup4SetMomMsg(int address, boolean f13, boolean f14, boolean f15, boolean f16, boolean f17, boolean f18, boolean f19, boolean f20) {
        XNetMessage msg = new XNetMessage(6);
        msg.setElement(0, 228);
        msg.setElement(1, 39);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        int element4value = 0;
        if (f13) {
            ++element4value;
        }
        if (f14) {
            element4value += 2;
        }
        if (f15) {
            element4value += 4;
        }
        if (f16) {
            element4value += 8;
        }
        if (f17) {
            element4value += 16;
        }
        if (f18) {
            element4value += 32;
        }
        if (f19) {
            element4value += 64;
        }
        if (f20) {
            element4value += 128;
        }
        msg.setElement(4, element4value);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getFunctionGroup5OpsMsg(int address, boolean f21, boolean f22, boolean f23, boolean f24, boolean f25, boolean f26, boolean f27, boolean f28) {
        XNetMessage msg = new XNetMessage(6);
        msg.setElement(0, 228);
        msg.setElement(1, 40);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        int element4value = 0;
        if (f21) {
            ++element4value;
        }
        if (f22) {
            element4value += 2;
        }
        if (f23) {
            element4value += 4;
        }
        if (f24) {
            element4value += 8;
        }
        if (f25) {
            element4value += 16;
        }
        if (f26) {
            element4value += 32;
        }
        if (f27) {
            element4value += 64;
        }
        if (f28) {
            element4value += 128;
        }
        msg.setElement(4, element4value);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getFunctionGroup5SetMomMsg(int address, boolean f21, boolean f22, boolean f23, boolean f24, boolean f25, boolean f26, boolean f27, boolean f28) {
        XNetMessage msg = new XNetMessage(6);
        msg.setElement(0, 228);
        msg.setElement(1, 44);
        msg.setElement(2, LenzCommandStation.getDCCAddressHigh(address));
        msg.setElement(3, LenzCommandStation.getDCCAddressLow(address));
        int element4value = 0;
        if (f21) {
            ++element4value;
        }
        if (f22) {
            element4value += 2;
        }
        if (f23) {
            element4value += 4;
        }
        if (f24) {
            element4value += 8;
        }
        if (f25) {
            element4value += 16;
        }
        if (f26) {
            element4value += 32;
        }
        if (f27) {
            element4value += 64;
        }
        if (f28) {
            element4value += 128;
        }
        msg.setElement(4, element4value);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getResumeOperationsMsg() {
        XNetMessage msg = new XNetMessage(3);
        msg.setElement(0, 33);
        msg.setElement(1, 129);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getEmergencyOffMsg() {
        XNetMessage msg = new XNetMessage(3);
        msg.setElement(0, 33);
        msg.setElement(1, 128);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getEmergencyStopMsg() {
        XNetMessage msg = new XNetMessage(2);
        msg.setElement(0, 128);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getCSVersionRequestMessage() {
        XNetMessage msg = new XNetMessage(3);
        msg.setElement(0, 33);
        msg.setElement(1, 33);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getCSStatusRequestMessage() {
        XNetMessage msg = new XNetMessage(3);
        msg.setElement(0, 33);
        msg.setElement(1, 36);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getCSAutoStartMessage(boolean autoMode) {
        XNetMessage msg = new XNetMessage(4);
        msg.setElement(0, 34);
        msg.setElement(1, 34);
        if (autoMode) {
            msg.setElement(2, 4);
        } else {
            msg.setElement(2, 0);
        }
        msg.setParity();
        return msg;
    }

    public static XNetMessage getLIVersionRequestMessage() {
        XNetMessage msg = new XNetMessage(2);
        msg.setElement(0, 240);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getLIAddressRequestMsg(int address) {
        XNetMessage msg = new XNetMessage(4);
        msg.setElement(0, 242);
        msg.setElement(1, 1);
        msg.setElement(2, address);
        msg.setParity();
        return msg;
    }

    public static XNetMessage getLISpeedRequestMsg(int speed) {
        XNetMessage msg = new XNetMessage(4);
        msg.setElement(0, 242);
        msg.setElement(1, 2);
        msg.setElement(2, speed);
        msg.setParity();
        return msg;
    }

    @Override
    public String toMonitorString() {
        String text;
        if (this.getElement(0) == 240) {
            text = Bundle.getMessage("XNetMessageRequestLIVersion");
        } else if (this.getElement(0) == 242) {
            block0 : switch (this.getElement(1)) {
                case 1: {
                    text = Bundle.getMessage("XNetMessageRequestLIAddress", this.getElement(2));
                    break;
                }
                case 2: {
                    switch (this.getElement(2)) {
                        case 1: {
                            text = Bundle.getMessage(X_NET_MESSAGE_REQUEST_LI_BAUD, Bundle.getMessage("LIBaud19200"));
                            break block0;
                        }
                        case 2: {
                            text = Bundle.getMessage(X_NET_MESSAGE_REQUEST_LI_BAUD, Bundle.getMessage("Baud38400"));
                            break block0;
                        }
                        case 3: {
                            text = Bundle.getMessage(X_NET_MESSAGE_REQUEST_LI_BAUD, Bundle.getMessage("Baud57600"));
                            break block0;
                        }
                        case 4: {
                            text = Bundle.getMessage(X_NET_MESSAGE_REQUEST_LI_BAUD, Bundle.getMessage("Baud115200"));
                            break block0;
                        }
                    }
                    text = Bundle.getMessage(X_NET_MESSAGE_REQUEST_LI_BAUD, Bundle.getMessage("BaudOther"));
                    break;
                }
                default: {
                    text = this.toString();
                    break;
                }
            }
        } else if (this.getElement(0) == 33) {
            switch (this.getElement(1)) {
                case 128: {
                    text = Bundle.getMessage("XNetMessageRequestEmergencyOff");
                    break;
                }
                case 129: {
                    text = Bundle.getMessage("XNetMessageRequestNormalOps");
                    break;
                }
                case 16: {
                    text = Bundle.getMessage("XNetMessageRequestServiceModeResult");
                    break;
                }
                case 33: {
                    text = Bundle.getMessage("XNetMessageRequestCSVersion");
                    break;
                }
                case 36: {
                    text = Bundle.getMessage("XNetMessageRequestCSStatus");
                    break;
                }
                default: {
                    text = this.toString();
                    break;
                }
            }
        } else if (this.getElement(0) == 34 && this.getElement(1) == 34 && this.getElement(2) == 4) {
            text = Bundle.getMessage("XNetMessageRequestCSPowerModeAuto");
        } else if (this.getElement(0) == 34 && this.getElement(1) == 34 && this.getElement(2) == 0) {
            text = Bundle.getMessage("XNetMessageRequestCSPowerModeManual");
        } else if (this.getElement(0) == 34) {
            switch (this.getElement(1)) {
                case 17: {
                    text = Bundle.getMessage("XNetMessageRequestServiceModeReadRegister", this.getElement(2));
                    break;
                }
                case 21: {
                    text = Bundle.getMessage("XNetMessageRequestServiceModeReadDirect", this.getElement(2));
                    break;
                }
                case 20: {
                    text = Bundle.getMessage("XNetMessageRequestServiceModeReadPaged", this.getElement(2));
                    break;
                }
                case 24: {
                    text = Bundle.getMessage(X_NET_MESSAGE_REQUEST_SERVICE_MODE_READ_DIRECT_V_36, this.getElement(2) == 0 ? 1024 : this.getElement(2));
                    break;
                }
                case 25: {
                    text = Bundle.getMessage(X_NET_MESSAGE_REQUEST_SERVICE_MODE_READ_DIRECT_V_36, 256 + this.getElement(2));
                    break;
                }
                case 26: {
                    text = Bundle.getMessage(X_NET_MESSAGE_REQUEST_SERVICE_MODE_READ_DIRECT_V_36, 512 + this.getElement(2));
                    break;
                }
                case 27: {
                    text = Bundle.getMessage(X_NET_MESSAGE_REQUEST_SERVICE_MODE_READ_DIRECT_V_36, 768 + this.getElement(2));
                    break;
                }
                default: {
                    text = this.toString();
                    break;
                }
            }
        } else if (this.getElement(0) == 35) {
            switch (this.getElement(1)) {
                case 18: {
                    text = Bundle.getMessage("XNetMessageRequestServiceModeWriteRegister", this.getElement(2), this.getElement(3));
                    break;
                }
                case 22: {
                    text = Bundle.getMessage("XNetMessageRequestServiceModeWriteDirect", this.getElement(2), this.getElement(3));
                    break;
                }
                case 23: {
                    text = Bundle.getMessage("XNetMessageRequestServiceModeWritePaged", this.getElement(2), this.getElement(3));
                    break;
                }
                case 28: {
                    text = Bundle.getMessage(X_NET_MESSAGE_REQUEST_SERVICE_MODE_WRITE_DIRECT_V_36, this.getElement(2) == 0 ? 1024 : this.getElement(2), this.getElement(3));
                    break;
                }
                case 29: {
                    text = Bundle.getMessage(X_NET_MESSAGE_REQUEST_SERVICE_MODE_WRITE_DIRECT_V_36, 256 + this.getElement(2), this.getElement(3));
                    break;
                }
                case 30: {
                    text = Bundle.getMessage(X_NET_MESSAGE_REQUEST_SERVICE_MODE_WRITE_DIRECT_V_36, 512 + this.getElement(2), this.getElement(3));
                    break;
                }
                case 31: {
                    text = Bundle.getMessage(X_NET_MESSAGE_REQUEST_SERVICE_MODE_WRITE_DIRECT_V_36, 768 + this.getElement(2), this.getElement(3));
                    break;
                }
                default: {
                    text = this.toString();
                    break;
                }
            }
        } else if (this.getElement(0) == 230) {
            switch (this.getElement(1)) {
                case 48: {
                    if ((this.getElement(4) & 0xEC) == 236 || (this.getElement(4) & 0xE4) == 228) {
                        String message = "";
                        if ((this.getElement(4) & 0xEC) == 236) {
                            message = "XNetMessageOpsModeByteWrite";
                        } else if ((this.getElement(4) & 0xE4) == 228) {
                            message = "XNetMessageOpsModeByteVerify";
                        }
                        text = Bundle.getMessage(message, this.getElement(6), 1 + this.getElement(5) + ((this.getElement(4) & 3) << 8), LenzCommandStation.calcLocoAddress(this.getElement(2), this.getElement(3)));
                        break;
                    }
                    if ((this.getElement(4) & 0xE8) == 232) {
                        String message = (this.getElement(6) & 0x10) == 16 ? "XNetMessageOpsModeBitVerify" : "XNetMessageOpsModeBitWrite";
                        text = Bundle.getMessage(message, (this.getElement(6) & 8) >> 3, 1 + this.getElement(5) + ((this.getElement(4) & 3) << 8), this.getElement(6) & 7, LenzCommandStation.calcLocoAddress(this.getElement(2), this.getElement(3)));
                        break;
                    }
                }
                default: {
                    text = this.toString();
                    break;
                }
            }
        } else if (this.getElement(0) == 228) {
            text = "Mobile Decoder Operations Request: ";
            switch (this.getElement(1)) {
                case 16: {
                    String direction = (this.getElement(4) & 0x80) != 0 ? Bundle.getMessage(FORWARD) : Bundle.getMessage(REVERSE);
                    text = String.valueOf(text) + Bundle.getMessage(X_NET_MESSAGE_SET_SPEED, LenzCommandStation.calcLocoAddress(this.getElement(2), this.getElement(3))) + " " + (this.getElement(4) & 0xF) + " " + Bundle.getMessage(X_NET_MESSAGE_SET_DIRECTION, direction);
                    text = String.valueOf(text) + " " + Bundle.getMessage(SPEED_STEP_MODE_X, 14) + ".";
                    break;
                }
                case 17: {
                    int speed;
                    text = String.valueOf(text) + Bundle.getMessage(X_NET_MESSAGE_SET_SPEED, LenzCommandStation.calcLocoAddress(this.getElement(2), this.getElement(3))) + " ";
                    if (log.isDebugEnabled()) {
                        log.debug("{}", (Object)LenzCommandStation.calcLocoAddress(this.getElement(2), this.getElement(3)));
                        log.debug(text);
                    }
                    if ((speed = ((this.getElement(4) & 0x10) >> 4) + ((this.getElement(4) & 0xF) << 1)) >= 3) {
                        speed -= 3;
                    }
                    text = String.valueOf(text) + speed;
                    text = (this.getElement(4) & 0x80) != 0 ? String.valueOf(text) + " " + Bundle.getMessage(X_NET_MESSAGE_SET_DIRECTION, Bundle.getMessage(FORWARD)) : String.valueOf(text) + " " + Bundle.getMessage(X_NET_MESSAGE_SET_DIRECTION, Bundle.getMessage(REVERSE));
                    text = String.valueOf(text) + " " + Bundle.getMessage(SPEED_STEP_MODE_X, 27) + ".";
                    break;
                }
                case 18: {
                    text = String.valueOf(text) + Bundle.getMessage(X_NET_MESSAGE_SET_SPEED, LenzCommandStation.calcLocoAddress(this.getElement(2), this.getElement(3))) + " ";
                    int speed = ((this.getElement(4) & 0x10) >> 4) + ((this.getElement(4) & 0xF) << 1);
                    if (speed >= 3) {
                        speed -= 3;
                    }
                    text = String.valueOf(text) + speed;
                    text = (this.getElement(4) & 0x80) != 0 ? String.valueOf(text) + " " + Bundle.getMessage(X_NET_MESSAGE_SET_DIRECTION, Bundle.getMessage(FORWARD)) : String.valueOf(text) + " " + Bundle.getMessage(X_NET_MESSAGE_SET_DIRECTION, Bundle.getMessage(REVERSE));
                    text = String.valueOf(text) + " " + Bundle.getMessage(SPEED_STEP_MODE_X, 28) + ".";
                    break;
                }
                case 19: {
                    String direction = (this.getElement(4) & 0x80) != 0 ? Bundle.getMessage(FORWARD) : Bundle.getMessage(REVERSE);
                    text = String.valueOf(text) + Bundle.getMessage(X_NET_MESSAGE_SET_SPEED, LenzCommandStation.calcLocoAddress(this.getElement(2), this.getElement(3))) + " " + (this.getElement(4) & 0x7F) + " " + Bundle.getMessage(X_NET_MESSAGE_SET_DIRECTION, direction);
                    text = String.valueOf(text) + " " + Bundle.getMessage(SPEED_STEP_MODE_X, 128) + ".";
                    break;
                }
                case 32: {
                    text = String.valueOf(text) + this.buildSetFunctionGroup1MonitorString();
                    break;
                }
                case 33: {
                    text = String.valueOf(text) + this.buildSetFunctionGroup2MonitorString();
                    break;
                }
                case 34: {
                    text = String.valueOf(text) + this.buildSetFunctionGroup3MonitorString();
                    break;
                }
                case 35: {
                    text = String.valueOf(text) + this.buildSetFunctionGroup4MonitorString();
                    break;
                }
                case 40: {
                    text = String.valueOf(text) + this.buildSetFunctionGroup5MonitorString();
                    break;
                }
                case 36: {
                    text = String.valueOf(text) + this.buildSetFunctionGroup1MomentaryMonitorString();
                    break;
                }
                case 37: {
                    text = String.valueOf(text) + this.buildSetFunctionGroup2MomentaryMonitorString();
                    break;
                }
                case 38: {
                    text = String.valueOf(text) + this.buildSetFunctionGroup3MomentaryMonitorString();
                    break;
                }
                case 39: {
                    text = String.valueOf(text) + this.buildSetFunctionGroup4MomentaryMonitorString();
                    break;
                }
                case 44: {
                    text = String.valueOf(text) + this.buildSetFunctionGroup5MomentaryMonitorString();
                    break;
                }
                case 64: {
                    text = Bundle.getMessage("XNetMessageAddToConsistDirNormalRequest", LenzCommandStation.calcLocoAddress(this.getElement(2), this.getElement(3)), this.getElement(4));
                    break;
                }
                case 65: {
                    text = Bundle.getMessage("XNetMessageAddToConsistDirReverseRequest", LenzCommandStation.calcLocoAddress(this.getElement(2), this.getElement(3)), this.getElement(4));
                    break;
                }
                case 66: {
                    text = Bundle.getMessage("XNetMessageRemoveFromConsistRequest", LenzCommandStation.calcLocoAddress(this.getElement(2), this.getElement(3)), this.getElement(4));
                    break;
                }
                case 1: {
                    text = Bundle.getMessage("XNetMessageSearchCSStackForwardNextMULoco", this.getElement(2), LenzCommandStation.calcLocoAddress(this.getElement(3), this.getElement(4)));
                    break;
                }
                case 2: {
                    text = Bundle.getMessage("XNetMessageSearchCSStackBackwardNextMULoco", this.getElement(2), LenzCommandStation.calcLocoAddress(this.getElement(3), this.getElement(4)));
                    break;
                }
                default: {
                    text = this.toString();
                    break;
                }
            }
        } else if (this.getElement(0) == 146) {
            text = Bundle.getMessage("XNetMessageAddressedEmergencyStopRequest", LenzCommandStation.calcLocoAddress(this.getElement(1), this.getElement(2)));
        } else if (this.getElement(0) == 229 && this.getElement(1) == 67) {
            int loco1 = LenzCommandStation.calcLocoAddress(this.getElement(2), this.getElement(3));
            int loco2 = LenzCommandStation.calcLocoAddress(this.getElement(4), this.getElement(5));
            text = loco2 == 0 ? Bundle.getMessage("XNetMessageDisolveDoubleHeaderRequest", loco1) : Bundle.getMessage("XNetMessageBuildDoubleHeaderRequest", loco1, loco2);
        } else if (this.getElement(0) == 227) {
            switch (this.getElement(1)) {
                case 7: {
                    text = Bundle.getMessage("XNetMessageRequestLocoFunctionMomStatus", LenzCommandStation.calcLocoAddress(this.getElement(2), this.getElement(3)));
                    break;
                }
                case 9: {
                    text = Bundle.getMessage("XNetMessageRequestLocoFunctionHighStatus", LenzCommandStation.calcLocoAddress(this.getElement(2), this.getElement(3)));
                    break;
                }
                case 8: {
                    text = Bundle.getMessage("XNetMessageRequestLocoFunctionHighMomStatus", LenzCommandStation.calcLocoAddress(this.getElement(2), this.getElement(3)));
                    break;
                }
                case 0: {
                    text = Bundle.getMessage("XNetMessageRequestLocoInfo", LenzCommandStation.calcLocoAddress(this.getElement(2), this.getElement(3)));
                    break;
                }
                case 5: {
                    text = Bundle.getMessage("XNetMessageSearchCSStackForward", LenzCommandStation.calcLocoAddress(this.getElement(2), this.getElement(3)));
                    break;
                }
                case 6: {
                    text = Bundle.getMessage("XNetMessageSearchCSStackBackward", LenzCommandStation.calcLocoAddress(this.getElement(2), this.getElement(3)));
                    break;
                }
                case 68: {
                    text = Bundle.getMessage("XNetMessageDeleteAddressOnStack", LenzCommandStation.calcLocoAddress(this.getElement(2), this.getElement(3)));
                    break;
                }
                default: {
                    text = this.toString();
                    break;
                }
            }
        } else if (this.getElement(0) == 226) {
            text = this.getElement(1) == 3 ? Bundle.getMessage("XNetMessageSearchCSStackForwardConsistAddress", this.getElement(2)) : (this.getElement(1) == 4 ? Bundle.getMessage("XNetMessageSearchCSStackBackwardConsistAddress", this.getElement(2)) : this.toString());
        } else if (this.getElement(0) == 66) {
            String nibblekey = (this.getElement(2) & 1) == 1 ? "FeedbackEncoderUpperNibble" : "FeedbackEncoderLowerNibble";
            text = Bundle.getMessage("XNetMessageFeedbackRequest", this.getElement(1), Bundle.getMessage(nibblekey));
        } else if (this.getElement(0) == 82) {
            String messageKey = (this.getElement(2) & 8) == 8 ? "XNetMessageAccessoryDecoderOnRequest" : "XNetMessageAccessoryDecoderOffRequest";
            int baseaddress = this.getElement(1);
            int subaddress = (this.getElement(2) & 6) >> 1;
            int address = baseaddress * 4 + subaddress + 1;
            int output = this.getElement(2) & 1;
            text = Bundle.getMessage(messageKey, address, baseaddress, subaddress, output);
        } else {
            text = this.getElement(0) == 128 ? Bundle.getMessage("XNetMessageRequestEmergencyStop") : this.toString();
        }
        return text;
    }

    private String buildSetFunctionGroup1MonitorString() {
        String text = String.valueOf(Bundle.getMessage(X_NET_MESSAGE_SET_FUNCTION_GROUP_X, 1)) + " " + LenzCommandStation.calcLocoAddress(this.getElement(2), this.getElement(3)) + " ";
        int element4 = this.getElement(4);
        text = (element4 & 0x10) != 0 ? String.valueOf(text) + "F0 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F0 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 1) != 0 ? String.valueOf(text) + "F1 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F1 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 2) != 0 ? String.valueOf(text) + "F2 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F2 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 4) != 0 ? String.valueOf(text) + "F3 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F3 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 8) != 0 ? String.valueOf(text) + "F4 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F4 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        return text;
    }

    private String buildSetFunctionGroup2MonitorString() {
        String text = String.valueOf(Bundle.getMessage(X_NET_MESSAGE_SET_FUNCTION_GROUP_X, 2)) + " " + LenzCommandStation.calcLocoAddress(this.getElement(2), this.getElement(3)) + " ";
        int element4 = this.getElement(4);
        text = (element4 & 1) != 0 ? String.valueOf(text) + "F5 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F5 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 2) != 0 ? String.valueOf(text) + "F6 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F6 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 4) != 0 ? String.valueOf(text) + "F7 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F7 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 8) != 0 ? String.valueOf(text) + "F8 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F8 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        return text;
    }

    private String buildSetFunctionGroup3MonitorString() {
        String text = String.valueOf(Bundle.getMessage(X_NET_MESSAGE_SET_FUNCTION_GROUP_X, 3)) + " " + LenzCommandStation.calcLocoAddress(this.getElement(2), this.getElement(3)) + " ";
        int element4 = this.getElement(4);
        text = (element4 & 1) != 0 ? String.valueOf(text) + "F9 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F9 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 2) != 0 ? String.valueOf(text) + "F10 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F10 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 4) != 0 ? String.valueOf(text) + "F11 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F11 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 8) != 0 ? String.valueOf(text) + "F12 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F12 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        return text;
    }

    private String buildSetFunctionGroup4MonitorString() {
        String text = String.valueOf(Bundle.getMessage(X_NET_MESSAGE_SET_FUNCTION_GROUP_X, 4)) + " " + LenzCommandStation.calcLocoAddress(this.getElement(2), this.getElement(3)) + " ";
        int element4 = this.getElement(4);
        text = (element4 & 1) != 0 ? String.valueOf(text) + "F13 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F13 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 2) != 0 ? String.valueOf(text) + "F14 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F14 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 4) != 0 ? String.valueOf(text) + "F15 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F15 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 8) != 0 ? String.valueOf(text) + "F16 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F16 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 0x10) != 0 ? String.valueOf(text) + "F17 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F17 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 0x20) != 0 ? String.valueOf(text) + "F18 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F18 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 0x40) != 0 ? String.valueOf(text) + "F19 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F19 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 0x80) != 0 ? String.valueOf(text) + "F20 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F20 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        return text;
    }

    private String buildSetFunctionGroup5MonitorString() {
        String text = String.valueOf(Bundle.getMessage(X_NET_MESSAGE_SET_FUNCTION_GROUP_X, 5)) + " " + LenzCommandStation.calcLocoAddress(this.getElement(2), this.getElement(3)) + " ";
        int element4 = this.getElement(4);
        text = (element4 & 1) != 0 ? String.valueOf(text) + "F21 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F21 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 2) != 0 ? String.valueOf(text) + "F22 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F22 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 4) != 0 ? String.valueOf(text) + "F23 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F23 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 8) != 0 ? String.valueOf(text) + "F24 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F24 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 0x10) != 0 ? String.valueOf(text) + "F25 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F25 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 0x20) != 0 ? String.valueOf(text) + "F26 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F26 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 0x40) != 0 ? String.valueOf(text) + "F27 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F27 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        text = (element4 & 0x80) != 0 ? String.valueOf(text) + "F28 " + Bundle.getMessage(POWER_STATE_ON) + "; " : String.valueOf(text) + "F28 " + Bundle.getMessage(POWER_STATE_OFF) + "; ";
        return text;
    }

    private String buildSetFunctionGroup1MomentaryMonitorString() {
        String text = String.valueOf(Bundle.getMessage(X_NET_MESSAGE_SET_FUNCTION_GROUP_X_MOMENTARY, 1)) + " " + LenzCommandStation.calcLocoAddress(this.getElement(2), this.getElement(3)) + " ";
        int element4 = this.getElement(4);
        text = (element4 & 0x10) == 0 ? String.valueOf(text) + "F0 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : String.valueOf(text) + "F0 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 1) == 0 ? String.valueOf(text) + "F1 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : String.valueOf(text) + "F1 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 2) == 0 ? String.valueOf(text) + "F2 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : String.valueOf(text) + "F2 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 4) == 0 ? String.valueOf(text) + "F3 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : String.valueOf(text) + "F3 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 8) == 0 ? String.valueOf(text) + "F4 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : String.valueOf(text) + "F4 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        return text;
    }

    private String buildSetFunctionGroup2MomentaryMonitorString() {
        String text = String.valueOf(Bundle.getMessage(X_NET_MESSAGE_SET_FUNCTION_GROUP_X_MOMENTARY, 2)) + " " + LenzCommandStation.calcLocoAddress(this.getElement(2), this.getElement(3)) + " ";
        int element4 = this.getElement(4);
        text = (element4 & 1) == 0 ? String.valueOf(text) + "F5 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : String.valueOf(text) + "F5 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 2) == 0 ? String.valueOf(text) + "F6 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : String.valueOf(text) + "F6 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 4) == 0 ? String.valueOf(text) + "F7 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : String.valueOf(text) + "F7 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 8) == 0 ? String.valueOf(text) + "F8 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : String.valueOf(text) + "F8 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        return text;
    }

    private String buildSetFunctionGroup3MomentaryMonitorString() {
        String text = String.valueOf(Bundle.getMessage(X_NET_MESSAGE_SET_FUNCTION_GROUP_X_MOMENTARY, 3)) + " " + LenzCommandStation.calcLocoAddress(this.getElement(2), this.getElement(3)) + " ";
        int element4 = this.getElement(4);
        text = (element4 & 1) == 0 ? String.valueOf(text) + "F9 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : String.valueOf(text) + "F9 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 2) == 0 ? String.valueOf(text) + "F10 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : String.valueOf(text) + "F10 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 4) == 0 ? String.valueOf(text) + "F11 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : String.valueOf(text) + "F11 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 8) == 0 ? String.valueOf(text) + "F12 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : String.valueOf(text) + "F12 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        return text;
    }

    private String buildSetFunctionGroup4MomentaryMonitorString() {
        String text = String.valueOf(Bundle.getMessage(X_NET_MESSAGE_SET_FUNCTION_GROUP_X_MOMENTARY, 4)) + " " + LenzCommandStation.calcLocoAddress(this.getElement(2), this.getElement(3)) + " ";
        int element4 = this.getElement(4);
        text = (element4 & 1) == 0 ? String.valueOf(text) + "F13 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : String.valueOf(text) + "F13 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 2) == 0 ? String.valueOf(text) + "F14 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : String.valueOf(text) + "F14 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 4) == 0 ? String.valueOf(text) + "F15 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : String.valueOf(text) + "F15 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 8) == 0 ? String.valueOf(text) + "F16 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : String.valueOf(text) + "F16 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 0x10) == 0 ? String.valueOf(text) + "F17 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : String.valueOf(text) + "F17 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 0x20) == 0 ? String.valueOf(text) + "F18 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : String.valueOf(text) + "F18 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 0x40) == 0 ? String.valueOf(text) + "F19 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : String.valueOf(text) + "F19 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 0x80) == 0 ? String.valueOf(text) + "F20 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : String.valueOf(text) + "F20 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        return text;
    }

    private String buildSetFunctionGroup5MomentaryMonitorString() {
        String text = String.valueOf(Bundle.getMessage(X_NET_MESSAGE_SET_FUNCTION_GROUP_X_MOMENTARY, 5)) + " " + LenzCommandStation.calcLocoAddress(this.getElement(2), this.getElement(3)) + " ";
        int element4 = this.getElement(4);
        text = (element4 & 1) == 0 ? String.valueOf(text) + "F21 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : String.valueOf(text) + "F21 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 2) == 0 ? String.valueOf(text) + "F22 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : String.valueOf(text) + "F22 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 4) == 0 ? String.valueOf(text) + "F23 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : String.valueOf(text) + "F23 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 8) == 0 ? String.valueOf(text) + "F24 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : String.valueOf(text) + "F24 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 0x10) == 0 ? String.valueOf(text) + "F25 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : String.valueOf(text) + "F25 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 0x20) == 0 ? String.valueOf(text) + "F26 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : String.valueOf(text) + "F26 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 0x40) == 0 ? String.valueOf(text) + "F27 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : String.valueOf(text) + "F27 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        text = (element4 & 0x80) == 0 ? String.valueOf(text) + "F28 " + Bundle.getMessage(FUNCTION_CONTINUOUS) + "; " : String.valueOf(text) + "F28 " + Bundle.getMessage(FUNCTION_MOMENTARY) + "; ";
        return text;
    }
}

