/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.Light;
import jmri.Manager;
import jmri.jmrix.lenz.Bundle;
import jmri.jmrix.lenz.XNetAddress;
import jmri.jmrix.lenz.XNetLight;
import jmri.jmrix.lenz.XNetSystemConnectionMemo;
import jmri.jmrix.lenz.XNetTrafficController;
import jmri.managers.AbstractLightManager;

public class XNetLightManager
extends AbstractLightManager {
    private XNetTrafficController tc;

    public XNetLightManager(XNetSystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getXNetTrafficController();
    }

    @Override
    @Nonnull
    public XNetSystemConnectionMemo getMemo() {
        return (XNetSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Light createNewLight(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        int bitNum = XNetAddress.getBitFromSystemName(systemName, this.getSystemPrefix());
        if (bitNum == -1) {
            throw new IllegalArgumentException("Invalid Bit from System Name: " + systemName);
        }
        String sName = String.valueOf(this.getSystemNamePrefix()) + bitNum;
        return new XNetLight(this.tc, this, sName, userName);
    }

    public int getBitFromSystemName(@Nonnull String systemName) {
        return XNetAddress.getBitFromSystemName(systemName, this.getSystemPrefix());
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) {
        return this.validateIntegerSystemNameFormat(name, 1, 1024, locale);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return this.getBitFromSystemName(systemName) != 0 ? Manager.NameValidity.VALID : Manager.NameValidity.INVALID;
    }

    @Override
    public boolean validSystemNameConfig(@Nonnull String systemName) {
        return true;
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddOutputEntryToolTip");
    }
}

