/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz;

import jmri.jmrix.lenz.XNetListener;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetSensor;
import jmri.jmrix.lenz.XNetTrafficController;
import jmri.jmrix.lenz.XNetTurnout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XNetFeedbackMessageCache
implements XNetListener {
    protected XNetTrafficController tc;
    private final XNetReply[] messageCache = new XNetReply[512];
    private final byte[] messagePending = new byte[64];
    private static final Logger log = LoggerFactory.getLogger(XNetFeedbackMessageCache.class);

    public XNetFeedbackMessageCache(XNetTrafficController controller) {
        this.tc = controller;
        this.tc.addXNetListener(8, this);
    }

    public void requestCachedStateFromLayout(XNetTurnout turnout) {
        int pNumber = turnout.getNumber();
        log.debug("asking for cached feedback for turnout {}.", (Object)pNumber);
        if (this.requestCachedState(2, --pNumber, turnout)) {
            turnout.requestUpdateFromLayout();
        }
    }

    public synchronized void requestCachedStateFromLayout(XNetSensor sensor) {
        int pNumber = sensor.getNumber();
        log.debug("asking for cached feedback for sensor {}.", (Object)pNumber);
        if (this.requestCachedState(4, --pNumber, sensor)) {
            sensor.requestUpdateFromLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean requestCachedState(int statesPerNibble, int pNumber, XNetListener target) {
        XNetReply cached;
        int replyIndex = pNumber / statesPerNibble;
        int bitIdx = replyIndex / 8;
        int bitMask = pNumber % 8;
        XNetFeedbackMessageCache xNetFeedbackMessageCache = this;
        synchronized (xNetFeedbackMessageCache) {
            block6: {
                if ((this.messagePending[bitIdx] & 1 << bitMask) <= 0) break block6;
                return false;
            }
            cached = this.messageCache[replyIndex];
            if (cached == null) {
                int n = bitIdx;
                this.messagePending[n] = (byte)(this.messagePending[n] | 1 << bitMask);
            }
        }
        if (cached != null) {
            target.message(cached);
            return false;
        }
        return true;
    }

    @Override
    public synchronized void message(XNetReply l) {
        if (log.isDebugEnabled()) {
            log.debug("received message: {}", (Object)l);
        }
        if (!l.isFeedbackBroadcastMessage()) {
            return;
        }
        int numDataBytes = l.getElement(0) & 0xF;
        int i = 1;
        while (i < numDataBytes) {
            int nibbleIndex = l.getElement(i) * 2 + (l.getElement(i + 1) & 0x10) >> 4;
            this.messageCache[nibbleIndex] = l;
            i += 2;
        }
    }

    @Override
    public void message(XNetMessage l) {
    }

    @Override
    public void notifyTimeout(XNetMessage msg) {
        if (log.isDebugEnabled()) {
            log.debug("Notified of timeout on message {}", (Object)msg);
        }
    }
}

