/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz;

import jmri.Consist;
import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.implementation.AbstractConsistManager;
import jmri.jmrix.lenz.XNetConsist;
import jmri.jmrix.lenz.XNetListener;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetSystemConnectionMemo;
import jmri.jmrix.lenz.XNetTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XNetConsistManager
extends AbstractConsistManager {
    protected XNetTrafficController tc;
    private boolean requestingUpdate = false;
    final XNetSystemConnectionMemo systemMemo;
    private static final Logger log = LoggerFactory.getLogger(XNetConsistManager.class);

    public XNetConsistManager(XNetSystemConnectionMemo systemMemo) {
        this.tc = systemMemo.getXNetTrafficController();
        this.systemMemo = systemMemo;
    }

    @Override
    public boolean isCommandStationConsistPossible() {
        return true;
    }

    @Override
    public boolean csConsistNeedsSeperateAddress() {
        return false;
    }

    @Override
    public Consist addConsist(LocoAddress address) {
        if (!(address instanceof DccLocoAddress)) {
            throw new IllegalArgumentException("address is not a DccLocoAddress object");
        }
        if (this.consistTable.containsKey(address)) {
            return (Consist)this.consistTable.get(address);
        }
        XNetConsist consist = new XNetConsist((DccLocoAddress)address, this.tc, this.systemMemo);
        this.consistTable.put(address, consist);
        return consist;
    }

    @Override
    public void requestUpdateFromLayout() {
        if (this.shouldRequestUpdateFromLayout()) {
            new XNetConsistReader();
        }
    }

    @Override
    protected boolean shouldRequestUpdateFromLayout() {
        return !this.requestingUpdate;
    }

    private class XNetConsistReader
    implements XNetListener {
        int _lastMUAddress = 0;
        int _lastAddress = 0;
        int _lastMemberAddress = 0;
        XNetConsist currentConsist = null;
        static final int IDLE = 0;
        static final int SEARCHREQUESTSENT = 1;
        static final int MUSEARCHSENT = 2;
        static final int MUINFOREQUESTSENT = 4;
        static final int DHADDRESS1INFO = 8;
        static final int DHADDRESS2INFO = 16;
        int currentState = 0;

        XNetConsistReader() {
            XNetConsistManager.this.tc.addXNetListener(49, this);
            this.searchNext();
        }

        private void searchNext() {
            XNetConsistManager.this.requestingUpdate = true;
            log.debug("Sending search for next DB Entry, _lastAddress is: {}", (Object)this._lastAddress);
            this.currentState = 1;
            XNetMessage msg = XNetMessage.getNextAddressOnStackMsg(this._lastAddress, true);
            XNetConsistManager.this.tc.sendXNetMessage(msg, this);
        }

        private void searchMU() {
            log.debug("Sending search for next MU Entry, _lastMUAddress is: {} _lastMemberAddress is: {}", (Object)this._lastMUAddress, (Object)this._lastMemberAddress);
            this.currentState = 2;
            XNetMessage msg = XNetMessage.getDBSearchMsgNextMULoco(this._lastMUAddress, this._lastMemberAddress, true);
            XNetConsistManager.this.tc.sendXNetMessage(msg, this);
        }

        private void requestInfoMU() {
            log.debug("Sending search for next MU Entry information , _lastMemberAddress is: {}", (Object)this._lastMemberAddress);
            this.currentState = 4;
            XNetMessage msg = XNetMessage.getLocomotiveInfoRequestMsg(this._lastMemberAddress);
            XNetConsistManager.this.tc.sendXNetMessage(msg, this);
        }

        @Override
        public void message(XNetReply l) {
            switch (this.currentState) {
                case 1: {
                    if (log.isDebugEnabled()) {
                        log.debug("Message Received in SEARCHREQUESTSENT state.  Message is: {}", (Object)l);
                    }
                    if (l.getElement(0) != 227) break;
                    switch (l.getElement(1)) {
                        case 48: 
                        case 51: {
                            this._lastAddress = l.getThrottleMsgAddr();
                            this.searchNext();
                            break;
                        }
                        case 49: {
                            this._lastMUAddress = this._lastAddress = l.getThrottleMsgAddr();
                            this._lastMemberAddress = this._lastAddress;
                            if (log.isDebugEnabled()) {
                                log.debug("Sending search for first DH Entry information , _lastMemberAddress is: {}", (Object)this._lastMemberAddress);
                            }
                            this.currentState = 8;
                            XNetMessage msg = XNetMessage.getLocomotiveInfoRequestMsg(this._lastMemberAddress);
                            XNetConsistManager.this.tc.sendXNetMessage(msg, this);
                            break;
                        }
                        case 50: {
                            this._lastMUAddress = this._lastAddress = l.getThrottleMsgAddr();
                            this.currentConsist = (XNetConsist)XNetConsistManager.this.addConsist(new DccLocoAddress(this._lastMUAddress, false));
                            this.searchMU();
                            break;
                        }
                        case 52: {
                            this.currentState = 0;
                            XNetConsistManager.this.notifyConsistListChanged();
                            XNetConsistManager.this.requestingUpdate = false;
                        }
                    }
                    break;
                }
                case 2: {
                    if (log.isDebugEnabled()) {
                        log.debug("Message Received in MUSEARCHSENT state.  Message is: {}", (Object)l);
                    }
                    if (l.getElement(0) != 227) break;
                    switch (l.getElement(1)) {
                        case 51: {
                            this._lastMemberAddress = l.getThrottleMsgAddr();
                            if (this._lastMemberAddress != 0) {
                                this.requestInfoMU();
                                break;
                            }
                            this.searchNext();
                            break;
                        }
                        case 52: {
                            this.searchNext();
                        }
                    }
                    break;
                }
                case 4: {
                    if (log.isDebugEnabled()) {
                        log.debug("Message Received in MUINFOREQUESTSENT state.  Message is: {}", (Object)l);
                    }
                    if (l.getElement(0) != 229) break;
                    this.currentConsist.restore(new DccLocoAddress(this._lastMemberAddress, this._lastMemberAddress > 99), (l.getElement(2) & 0x80) == 128);
                    this.searchMU();
                    break;
                }
                case 8: {
                    if (log.isDebugEnabled()) {
                        log.debug("Message Received in DHADDRESS1INFO state.  Message is: {}", (Object)l);
                    }
                    if (l.getElement(0) != 230) break;
                    DccLocoAddress firstMember = new DccLocoAddress(this._lastMemberAddress, this._lastMemberAddress > 99);
                    int AH = l.getElement(5);
                    int AL2 = l.getElement(6);
                    this._lastMemberAddress = AH == 0 ? AL2 : (AH * 256 & 0xFF00) + (AL2 & 0xFF) - 49152;
                    if (!XNetConsistManager.this.consistTable.containsKey(firstMember) && !XNetConsistManager.this.consistTable.containsKey(new DccLocoAddress(this._lastMemberAddress, this._lastMemberAddress > 99))) {
                        this.currentConsist = (XNetConsist)XNetConsistManager.this.addConsist(firstMember);
                        this.currentConsist.setConsistType(1);
                        this.currentConsist.restore(firstMember, (l.getElement(2) & 0x80) == 128);
                        if (log.isDebugEnabled()) {
                            log.debug("Sending search for second DH Entry information , _lastMemberAddress is: {}", (Object)this._lastMemberAddress);
                        }
                        this.currentState = 16;
                        XNetMessage msg = XNetMessage.getLocomotiveInfoRequestMsg(this._lastMemberAddress);
                        XNetConsistManager.this.tc.sendXNetMessage(msg, this);
                        break;
                    }
                    this.searchNext();
                    break;
                }
                case 16: {
                    log.debug("Message Received in DHADDRESS2INFO state.  Message is: {}", (Object)l);
                    if (l.getElement(0) == 230) {
                        this.currentConsist.restore(new DccLocoAddress(this._lastMemberAddress, this._lastMemberAddress > 99), (l.getElement(2) & 0x80) == 128);
                    }
                    this.searchNext();
                    break;
                }
                default: {
                    log.debug("Message Received in default(IDLE) state. Message is: {}", (Object)l);
                }
            }
        }

        @Override
        public void message(XNetMessage l) {
        }

        @Override
        public void notifyTimeout(XNetMessage msg) {
            if (log.isDebugEnabled()) {
                log.debug("Notified of timeout on message {}", (Object)msg);
            }
        }
    }
}

