/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz;

import jmri.DccLocoAddress;
import jmri.SpeedStepMode;
import jmri.implementation.DccConsist;
import jmri.jmrix.lenz.XNetListener;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetSystemConnectionMemo;
import jmri.jmrix.lenz.XNetTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XNetConsist
extends DccConsist
implements XNetListener {
    private final int IDLESTATE = 0;
    private final int ADDREQUESTSENTSTATE = 1;
    private final int REMOVEREQUESTSENTSTATE = 2;
    private int _state = 0;
    private DccLocoAddress _locoAddress = null;
    private boolean _directionNormal = false;
    protected XNetTrafficController tc;
    final XNetSystemConnectionMemo systemMemo;
    private static final Logger log = LoggerFactory.getLogger(XNetConsist.class);

    public XNetConsist(int address, XNetTrafficController controller, XNetSystemConnectionMemo systemMemo) {
        super(address);
        this.tc = controller;
        this.systemMemo = systemMemo;
        this.tc.addXNetListener(33, this);
    }

    public XNetConsist(DccLocoAddress address, XNetTrafficController controller, XNetSystemConnectionMemo systemMemo) {
        super(address);
        this.tc = controller;
        this.systemMemo = systemMemo;
        this.tc.addXNetListener(33, this);
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        this.tc.removeXNetListener(33, this);
    }

    @Override
    public void setConsistType(int consistType) {
        switch (consistType) {
            case 0: 
            case 1: {
                this.consistType = consistType;
                break;
            }
            default: {
                log.error("Consist Type Not Supported");
                this.notifyConsistListeners(new DccLocoAddress(0, false), 1);
            }
        }
    }

    @Override
    public boolean isAddressAllowed(DccLocoAddress address) {
        return address.getNumber() != 0;
    }

    @Override
    public int sizeLimit() {
        switch (this.consistType) {
            case 0: {
                return -1;
            }
            case 1: {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public boolean contains(DccLocoAddress address) {
        if (this.consistType == 0 || this.consistType == 1) {
            return this.consistList.contains(address);
        }
        log.error("Consist Type Not Supported");
        this.notifyConsistListeners(address, 1);
        return false;
    }

    @Override
    public boolean getLocoDirection(DccLocoAddress address) {
        if (this.consistType == 0 || this.consistType == 1) {
            return (Boolean)this.consistDir.get(address);
        }
        log.error("Consist Type Not Supported");
        this.notifyConsistListeners(address, 1);
        return false;
    }

    private synchronized void addToConsistList(DccLocoAddress LocoAddress2, boolean directionNormal) {
        if (!this.consistList.contains(LocoAddress2)) {
            this.consistList.add(LocoAddress2);
        }
        this.consistDir.put(LocoAddress2, directionNormal);
        if (this.consistType == 1 && this.consistList.size() == 2) {
            this.notifyConsistListeners(LocoAddress2, 10);
        } else {
            this.notifyConsistListeners(LocoAddress2, 2);
        }
    }

    private synchronized void removeFromConsistList(DccLocoAddress LocoAddress2) {
        if (this.consistList.contains(LocoAddress2)) {
            this.consistDir.remove(LocoAddress2);
            this.consistList.remove(LocoAddress2);
        }
        this.notifyConsistListeners(LocoAddress2, 2);
    }

    @Override
    public synchronized void add(DccLocoAddress locoAddress, boolean directionNormal) {
        switch (this.consistType) {
            case 0: {
                this.addToAdvancedConsist(locoAddress, directionNormal);
                this._locoAddress = locoAddress;
                this._directionNormal = directionNormal;
                break;
            }
            case 1: {
                if (this.consistList.size() < 2) {
                    if (this.consistList.size() == 1 && !this.consistList.contains(locoAddress)) {
                        this.addToCSConsist(locoAddress, directionNormal);
                        this._locoAddress = locoAddress;
                        this._directionNormal = directionNormal;
                        break;
                    }
                    if (this.consistList.size() < 1) {
                        this.addToConsistList(locoAddress, directionNormal);
                        break;
                    }
                    this.notifyConsistListeners(locoAddress, 36);
                    break;
                }
                if (this.consistList.size() == 2 && this.consistList.contains(locoAddress)) {
                    this.addToCSConsist(locoAddress, directionNormal);
                    this._locoAddress = locoAddress;
                    this._directionNormal = directionNormal;
                    break;
                }
                this.notifyConsistListeners(locoAddress, 12);
                break;
            }
            default: {
                log.error("Consist Type Not Supported");
                this.notifyConsistListeners(locoAddress, 1);
            }
        }
    }

    @Override
    public synchronized void restore(DccLocoAddress locoAddress, boolean directionNormal) {
        switch (this.consistType) {
            case 0: 
            case 1: {
                this.addToConsistList(locoAddress, directionNormal);
                break;
            }
            default: {
                log.error("Consist Type Not Supported");
                this.notifyConsistListeners(locoAddress, 1);
            }
        }
    }

    @Override
    public synchronized void remove(DccLocoAddress locoAddress) {
        log.debug("Consist {}: remove called for address {}", (Object)this.consistAddress, (Object)locoAddress);
        switch (this.consistType) {
            case 0: {
                this._locoAddress = locoAddress;
                this.removeFromAdvancedConsist(locoAddress);
                break;
            }
            case 1: {
                if (this.consistList.size() == 2 && this._state != 2) {
                    this._locoAddress = locoAddress;
                    this.removeFromCSConsist(locoAddress);
                    break;
                }
                if (this._state == 2 && this._locoAddress == locoAddress) break;
                this.removeFromConsistList(locoAddress);
                break;
            }
            default: {
                log.error("Consist Type Not Supported");
                this.notifyConsistListeners(locoAddress, 1);
            }
        }
    }

    @Override
    protected synchronized void addToAdvancedConsist(DccLocoAddress locoAddress, boolean directionNormal) {
        log.debug("Adding locomotive {} to consist {}", (Object)locoAddress.getNumber(), (Object)this.consistAddress.getNumber());
        if (this.contains(locoAddress)) {
            this.removeFromAdvancedConsist(locoAddress);
        }
        this.sendDirection(locoAddress, directionNormal);
        XNetMessage msg = XNetMessage.getAddLocoToConsistMsg(this.consistAddress.getNumber(), locoAddress.getNumber(), directionNormal);
        this.tc.sendXNetMessage(msg, this);
        this._state = 1;
    }

    @Override
    protected synchronized void removeFromAdvancedConsist(DccLocoAddress locoAddress) {
        this.sendDirection(locoAddress, this.getLocoDirection(locoAddress));
        XNetMessage msg = XNetMessage.getRemoveLocoFromConsistMsg(this.consistAddress.getNumber(), locoAddress.getNumber());
        this.tc.sendXNetMessage(msg, this);
        this._state = 2;
    }

    private synchronized void addToCSConsist(DccLocoAddress locoAddress, boolean directionNormal) {
        if (this.consistAddress.equals(locoAddress)) {
            log.error("Attempted to add {} to consist {}", (Object)locoAddress, (Object)this.consistAddress);
            this._state = 0;
            this.notifyConsistListeners(this._locoAddress, 36);
            return;
        }
        if (this.consistList.size() == 2 && this.consistList.contains(locoAddress)) {
            XNetMessage msg = XNetMessage.getDisolveDoubleHeaderMsg(((DccLocoAddress)this.consistList.get(0)).getNumber());
            this.tc.sendXNetMessage(msg, this);
        }
        DccLocoAddress address = (DccLocoAddress)this.consistList.get(0);
        Boolean direction = (Boolean)this.consistDir.get(address);
        this.sendDirection(address, direction);
        this.sendDirection(locoAddress, directionNormal);
        XNetMessage msg = XNetMessage.getBuildDoubleHeaderMsg(address.getNumber(), locoAddress.getNumber());
        this.tc.sendXNetMessage(msg, this);
        this._state = 1;
    }

    public synchronized void removeFromCSConsist(DccLocoAddress LocoAddress2) {
        XNetMessage msg = XNetMessage.getDisolveDoubleHeaderMsg(((DccLocoAddress)this.consistList.get(0)).getNumber());
        this.tc.sendXNetMessage(msg, this);
        this._state = 2;
    }

    @Override
    public synchronized void message(XNetReply l) {
        if (this._state != 0) {
            if (l.isOkMessage()) {
                if (this._state == 1) {
                    this.addToConsistList(this._locoAddress, this._directionNormal);
                    if (this.consistType == 0) {
                        this.setRosterEntryCVValue(this._locoAddress);
                    }
                } else if (this._state == 2) {
                    if (this.consistType == 0) {
                        this.resetRosterEntryCVValue(this._locoAddress);
                    }
                    this.removeFromConsistList(this._locoAddress);
                }
                this._state = 0;
            } else if (l.getElement(0) == 225) {
                String text = "XpressNet MU+DH error: ";
                switch (l.getElement(1)) {
                    case 129: {
                        text = String.valueOf(text) + "Selected Locomotive has not been operated by this XpressNet device or address 0 selected";
                        log.error(text);
                        this._state = 0;
                        this.notifyConsistListeners(this._locoAddress, 20);
                        break;
                    }
                    case 130: {
                        text = String.valueOf(text) + "Selected Locomotive is being operated by another XpressNet device";
                        log.error(text);
                        this._state = 0;
                        this.notifyConsistListeners(this._locoAddress, 20);
                        break;
                    }
                    case 131: {
                        text = String.valueOf(text) + "Selected Locomotive already in MU or DH";
                        log.error(text);
                        this._state = 0;
                        this.notifyConsistListeners(this._locoAddress, 36);
                        break;
                    }
                    case 132: {
                        text = String.valueOf(text) + "Unit selected for MU or DH has speed setting other than 0";
                        log.error(text);
                        this._state = 0;
                        this.notifyConsistListeners(this._locoAddress, 132);
                        break;
                    }
                    case 133: {
                        text = String.valueOf(text) + "Locomotive not in a MU";
                        log.error(text);
                        this._state = 0;
                        this.notifyConsistListeners(this._locoAddress, 68);
                        log.error(text);
                        break;
                    }
                    case 134: {
                        text = String.valueOf(text) + "Locomotive address not a multi-unit base address";
                        log.error(text);
                        this._state = 0;
                        this.notifyConsistListeners(this._locoAddress, 260);
                        log.error(text);
                        break;
                    }
                    case 135: {
                        text = String.valueOf(text) + "It is not possible to delete the locomotive";
                        log.error(text);
                        this._state = 0;
                        this.notifyConsistListeners(this._locoAddress, 516);
                        break;
                    }
                    case 136: {
                        text = String.valueOf(text) + "The Command Station Stack is Full";
                        log.error(text);
                        this._state = 0;
                        this.notifyConsistListeners(this._locoAddress, 1028);
                        log.error(text);
                        break;
                    }
                    default: {
                        text = String.valueOf(text) + "Unknown";
                        log.error(text);
                        this._state = 0;
                        this.notifyConsistListeners(this._locoAddress, 4);
                    }
                }
            }
        }
    }

    @Override
    public void message(XNetMessage l) {
    }

    @Override
    public void notifyTimeout(XNetMessage msg) {
        if (log.isDebugEnabled()) {
            log.debug("Notified of timeout on message{}", (Object)msg.toString());
        }
    }

    private void sendDirection(DccLocoAddress address, boolean isForward) {
        XNetMessage msg = XNetMessage.getSpeedAndDirectionMsg(address.getNumber(), SpeedStepMode.NMRA_DCC_28, 0.0f, isForward);
        this.tc.sendXNetMessage(msg, this);
    }
}

