/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.lenz;

import javax.annotation.CheckForNull;
import jmri.jmrix.lenz.XNetReply;

public class FeedbackItem {
    private final int number;
    private final int data;
    private final XNetReply reply;

    protected FeedbackItem(XNetReply reply, int number, int data) {
        this.number = number;
        this.data = data;
        this.reply = reply;
    }

    public boolean isUnsolicited() {
        return this.reply.isUnsolicited();
    }

    @Deprecated
    public void resetUnsolicited() {
    }

    public int getAddress() {
        return this.number;
    }

    public boolean matchesAddress(int address) {
        if (this.isAccessory()) {
            return this.number == address;
        }
        return (address - 1 & 0xFFFFFFFC) + 1 == this.number;
    }

    public boolean isMotionComplete() {
        return (this.data & 0x80) == 0;
    }

    public int getType() {
        return (this.data & 0x60) >> 5;
    }

    public int getTurnoutStatus() {
        int t = this.getType();
        if (t > 1) {
            return -1;
        }
        switch (this.getAccessoryStatus()) {
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
        }
        return -1;
    }

    public boolean isEncoder() {
        return this.getType() == 2;
    }

    public boolean isAccessory() {
        return this.getType() < 2;
    }

    public int getAccessoryStatus() {
        if (!this.isAccessory()) {
            return 3;
        }
        return (this.number & 1) != 0 ? this.data & 3 : (this.data & 0xC) >> 2;
    }

    @CheckForNull
    public Boolean getEncoderStatus(int sensorNumber) {
        if (!this.matchesAddress(this.number) || this.isAccessory()) {
            return null;
        }
        if ((this.data & 1 << (sensorNumber - 1) % 4) > 0) {
            return true;
        }
        return false;
    }

    public FeedbackItem pairedAccessoryItem() {
        if (!this.isAccessory()) {
            return null;
        }
        int a = (this.number & 1) != 0 ? this.number + 1 : this.number - 1;
        return new FeedbackItem(this.reply, a, this.data);
    }
}

