/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.jmriclient.networkdriver;

import java.util.ResourceBundle;
import jmri.jmrix.jmriclient.JMRIClientPortController;
import jmri.jmrix.jmriclient.JMRIClientSystemConnectionMemo;
import jmri.jmrix.jmriclient.JMRIClientTrafficController;
import jmri.util.zeroconf.ZeroConfClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkDriverAdapter
extends JMRIClientPortController {
    static final ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrix.jmriclient.JMRIClientConfigurationBundle");
    private boolean opened = false;
    private boolean mDNSConfigure = false;
    ZeroConfClient mdnsClient = null;
    private static final Logger log = LoggerFactory.getLogger(NetworkDriverAdapter.class);

    public NetworkDriverAdapter() {
        super(new JMRIClientSystemConnectionMemo());
        this.setPort(2048);
    }

    @Override
    public void configure() {
        JMRIClientTrafficController control = new JMRIClientTrafficController();
        control.connectPort(this);
        this.getSystemConnectionMemo().setJMRIClientTrafficController(control);
        this.getSystemConnectionMemo().configureManagers();
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Deprecated
    public static NetworkDriverAdapter instance() {
        log.error("Deprecated method instance Called", (Throwable)new Exception());
        return null;
    }

    @Override
    public void setMdnsConfigure(boolean autoconfig) {
        log.debug("Setting LIUSB Ethernet adapter autoconfiguration to: {}", (Object)autoconfig);
        this.mDNSConfigure = autoconfig;
    }

    @Override
    public boolean getMdnsConfigure() {
        return this.mDNSConfigure;
    }

    @Override
    public void autoConfigure() {
        log.info("Configuring JMRIClient interface via JmDNS");
        if (this.getHostName().equals(rb.getString("defaultMDNSServerName"))) {
            this.setHostName("");
        }
        String serviceType = rb.getString("defaultMDNSServiceType");
        log.debug("Listening for service: {}", (Object)serviceType);
        if (this.mdnsClient == null) {
            this.mdnsClient = new ZeroConfClient();
            this.mdnsClient.startServiceListener(serviceType);
        }
        try {
            String qualifiedHostName = String.valueOf(this.m_HostName) + "." + rb.getString("defaultMDNSDomainName");
            this.setHostAddress(this.mdnsClient.getServiceOnHost(serviceType, qualifiedHostName).getHostAddresses()[0]);
        }
        catch (NullPointerException nullPointerException) {
            String qualifiedServiceName = String.valueOf(rb.getString("defaultMDNSServiceName")) + "." + serviceType;
            this.setHostAddress(this.mdnsClient.getServicebyAdName(serviceType, qualifiedServiceName).getHostAddresses()[0]);
        }
    }

    @Override
    public String getAdvertisementName() {
        return rb.getString("defaultMDNSServiceName");
    }

    @Override
    public String getServiceType() {
        return rb.getString("defaultMDNSServiceType");
    }
}

