/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.jmriclient;

import jmri.implementation.AbstractTurnout;
import jmri.jmrix.jmriclient.JMRIClientListener;
import jmri.jmrix.jmriclient.JMRIClientMessage;
import jmri.jmrix.jmriclient.JMRIClientReply;
import jmri.jmrix.jmriclient.JMRIClientSystemConnectionMemo;
import jmri.jmrix.jmriclient.JMRIClientTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMRIClientTurnout
extends AbstractTurnout
implements JMRIClientListener {
    private int _number;
    private JMRIClientTrafficController tc = null;
    private String prefix = null;
    private String transmitName = null;
    static String[] modeNames = null;
    static int[] modeValues = null;
    private static final Logger log = LoggerFactory.getLogger(JMRIClientTurnout.class);

    public JMRIClientTurnout(int number, JMRIClientSystemConnectionMemo memo) {
        super(String.valueOf(memo.getSystemPrefix()) + "T" + number);
        this._number = number;
        this.tc = memo.getJMRIClientTrafficController();
        this.prefix = memo.getSystemPrefix();
        this.transmitName = String.valueOf(memo.getTransmitPrefix()) + "T" + number;
        this._validFeedbackTypes |= 8;
        this._activeFeedbackType = 8;
        JMRIClientTurnout.setModeInformation(this._validFeedbackNames, this._validFeedbackModes);
        this._validFeedbackNames = JMRIClientTurnout.getModeNames();
        this._validFeedbackModes = JMRIClientTurnout.getModeValues();
        this.tc.addJMRIClientListener(this);
        this.requestUpdateFromLayout();
    }

    private static synchronized void setModeInformation(String[] feedbackNames, int[] feedbackModes) {
        if (modeNames == null) {
            if (feedbackNames.length != feedbackModes.length) {
                log.error("int and string feedback arrays different length");
            }
            modeNames = new String[feedbackNames.length + 1];
            modeValues = new int[feedbackNames.length + 1];
            int i = 0;
            while (i < feedbackNames.length) {
                JMRIClientTurnout.modeNames[i] = feedbackNames[i];
                JMRIClientTurnout.modeValues[i] = feedbackModes[i];
                ++i;
            }
            JMRIClientTurnout.modeNames[feedbackNames.length] = "MONITORING";
            JMRIClientTurnout.modeValues[feedbackNames.length] = 8;
        }
    }

    static int[] getModeValues() {
        return modeValues;
    }

    static String[] getModeNames() {
        return modeNames;
    }

    public int getNumber() {
        return this._number;
    }

    @Override
    protected void forwardCommandChangeToLayout(int newState) {
        if ((newState & 2) != 0) {
            if ((newState & 4) != 0) {
                log.error("Cannot command both CLOSED and THROWN {}", (Object)newState);
                return;
            }
            this.sendMessage(!this.getInverted());
        } else {
            this.sendMessage(this.getInverted());
        }
    }

    @Override
    public boolean canInvert() {
        return true;
    }

    @Override
    public void requestUpdateFromLayout() {
        String text = "TURNOUT " + this.transmitName + "\n";
        this.tc.sendJMRIClientMessage(new JMRIClientMessage(text), this);
        super.requestUpdateFromLayout();
    }

    @Override
    protected void turnoutPushbuttonLockout(boolean _pushButtonLockout) {
        log.debug("Send command to {} Pushbutton {}{}", new Object[]{_pushButtonLockout ? "Lock" : "Unlock", this.prefix, this._number});
    }

    protected void sendMessage(boolean closed) {
        String text = closed ? "TURNOUT " + this.transmitName + " CLOSED\n" : "TURNOUT " + this.transmitName + " THROWN\n";
        this.tc.sendJMRIClientMessage(new JMRIClientMessage(text), this);
    }

    @Override
    public void reply(JMRIClientReply m) {
        String message = m.toString();
        if (!message.contains(String.valueOf(this.transmitName) + " ")) {
            return;
        }
        if (m.toString().contains("THROWN")) {
            this.newKnownState(!this.getInverted() ? 4 : 2);
        } else if (m.toString().contains("CLOSED")) {
            this.newKnownState(!this.getInverted() ? 2 : 4);
        } else {
            this.newKnownState(1);
        }
    }

    @Override
    public void message(JMRIClientMessage m) {
    }
}

