/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.jmriclient;

import jmri.JmriException;
import jmri.jmrix.jmriclient.JMRIClientListener;
import jmri.jmrix.jmriclient.JMRIClientMessage;
import jmri.jmrix.jmriclient.JMRIClientReply;
import jmri.jmrix.jmriclient.JMRIClientSystemConnectionMemo;
import jmri.jmrix.jmriclient.JMRIClientTrafficController;
import jmri.managers.AbstractPowerManager;

public class JMRIClientPowerManager
extends AbstractPowerManager<JMRIClientSystemConnectionMemo>
implements JMRIClientListener {
    JMRIClientTrafficController tc = null;

    public JMRIClientPowerManager(JMRIClientSystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getJMRIClientTrafficController();
        this.tc.addJMRIClientListener(this);
    }

    @Override
    public void setPower(int v) throws JmriException {
        int old = this.power;
        this.power = 1;
        this.checkTC();
        if (v == 2) {
            JMRIClientMessage l = JMRIClientMessage.getEnableMain();
            this.tc.sendJMRIClientMessage(l, this);
        } else if (v == 4) {
            JMRIClientMessage l = JMRIClientMessage.getKillMain();
            this.tc.sendJMRIClientMessage(l, this);
        }
        this.firePowerPropertyChange(old, this.power);
    }

    @Override
    public void dispose() throws JmriException {
        this.tc.removeJMRIClientListener(this);
        this.tc = null;
    }

    private void checkTC() throws JmriException {
        if (this.tc == null) {
            throw new JmriException("attempt to use JMRIClientPowerManager after dispose");
        }
    }

    @Override
    public void reply(JMRIClientReply m) {
        int old = this.power;
        this.power = m.toString().contains("ON") ? 2 : 4;
        this.firePowerPropertyChange(old, this.power);
    }

    @Override
    public void message(JMRIClientMessage m) {
    }
}

