/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ipocs.protocol.packets;

import java.nio.ByteBuffer;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Packet {
    private static final Logger log = LoggerFactory.getLogger(Packet.class);
    private byte length;
    private byte ack;

    public abstract byte getId();

    public byte getAck() {
        return this.ack;
    }

    public void setAck(byte ack) {
        this.ack = ack;
    }

    public byte getLength() {
        return this.length;
    }

    public void setLength(byte length) {
        this.length = length;
    }

    public static Packet parse(ByteBuffer buffer) {
        Object pkt = null;
        byte id = buffer.get();
        byte length = buffer.get();
        byte ack = buffer.get();
        ServiceLoader<Packet> loader = ServiceLoader.load(Packet.class);
        for (Packet implClass : loader) {
            if (implClass.getId() != id) continue;
            pkt = implClass;
            ((Packet)pkt).ack = ack;
            ((Packet)pkt).length = length;
            break;
        }
        if (pkt == null) {
            log.error("No packet found for identifier {}", (Object)id);
            buffer.position(buffer.position() + length - 3);
            return null;
        }
        log.debug("Found packet type {}", (Object)pkt.getClass().getSimpleName());
        ((Packet)pkt).parseSpecific(buffer);
        return pkt;
    }

    public ByteBuffer serialize() {
        byte[] specific = this.serializeSpecific();
        this.length = (byte)(specific.length + 3);
        ByteBuffer buffer = ByteBuffer.allocate(this.length);
        buffer.put(this.getId());
        buffer.put(this.length);
        buffer.put(this.ack);
        buffer.put(specific);
        buffer.rewind();
        return buffer;
    }

    protected abstract void parseSpecific(ByteBuffer var1);

    protected abstract byte[] serializeSpecific();
}

