/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ipocs.configurexml;

import java.io.IOException;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrix.configurexml.AbstractConnectionConfigXml;
import jmri.jmrix.ipocs.IpocsConnectionConfig;
import jmri.jmrix.ipocs.IpocsPortController;
import jmri.jmrix.ipocs.IpocsSystemConnectionMemo;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpocsConnectionConfigXml
extends AbstractConnectionConfigXml {
    private static final Logger log = LoggerFactory.getLogger(IpocsConnectionConfigXml.class);
    IpocsPortController portController;

    @Override
    public Element store(Object o) {
        Element e = new Element("connection");
        this.getInstance((IpocsConnectionConfig)o);
        this.storeCommon(e, this.portController);
        e.setAttribute("port", String.valueOf(this.portController.getPort()));
        e.setAttribute("class", this.getClass().getName());
        this.extendElement(e);
        return e;
    }

    @Override
    public boolean load(Element shared, Element perNode) throws JmriConfigureXmlException {
        this.getInstance();
        try {
            short port = (short)shared.getAttribute("port").getIntValue();
            this.portController.setPort(port);
        }
        catch (DataConversionException dataConversionException) {
            log.warn("Could not parse port attribute: {}", (Object)shared.getAttribute("port"));
        }
        catch (NullPointerException ex) {
            log.error("No port attribute availableCould not parse port attribute", (Throwable)ex);
        }
        this.loadCommon(shared, perNode, this.portController);
        this.register();
        if (!this.portController.getDisabled()) {
            this.portController.configure();
            try {
                this.portController.connect();
            }
            catch (IOException ex) {
                log.error("Unable to start service: {}", (Object)ex.getMessage());
            }
        }
        return true;
    }

    @Override
    protected void getInstance() {
        this.portController = new IpocsPortController(new IpocsSystemConnectionMemo());
        this.portController.getSystemConnectionMemo().setPortController(this.portController);
    }

    protected void getInstance(IpocsConnectionConfig o) {
        this.portController = o.getAdapter();
    }

    @Override
    protected void register() {
        this.register(new IpocsConnectionConfig(this.portController));
    }
}

