/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ipocs;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.ipocs.IpocsClientHandler;
import jmri.jmrix.ipocs.IpocsClientListener;
import jmri.jmrix.ipocs.IpocsSocketAcceptor;
import jmri.jmrix.ipocs.IpocsSystemConnectionMemo;
import jmri.jmrix.ipocs.protocol.Message;
import jmri.util.zeroconf.ZeroConfService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpocsPortController
extends AbstractPortController
implements IpocsClientListener {
    private static final Logger log = LoggerFactory.getLogger(IpocsPortController.class);
    private static String INADDR_ANY = "0.0.0.0";
    private short port = 0;
    private AsynchronousServerSocketChannel serverSocket = null;
    private IpocsSocketAcceptor socketAcceptor;
    private ZeroConfService zeroConfService = null;
    private final List<IpocsClientListener> clientListeners = new ArrayList<IpocsClientListener>();
    private final Map<String, IpocsClientHandler> clients = new HashMap<String, IpocsClientHandler>();
    private final Map<String, Message> lastMessage = new HashMap<String, Message>();

    public IpocsPortController(IpocsSystemConnectionMemo memo) {
        super(memo);
        super.setManufacturer("IPOCSMR");
        AbstractPortController.Option o1 = new AbstractPortController.Option("Port", new String[]{"0"}, false, AbstractPortController.Option.Type.TEXT);
        this.options.put(this.option1Name, o1);
    }

    @Override
    public IpocsSystemConnectionMemo getSystemConnectionMemo() {
        return (IpocsSystemConnectionMemo)super.getSystemConnectionMemo();
    }

    @Override
    public void configure() {
        if (this.getSystemConnectionMemo().getPortController() == null) {
            this.getSystemConnectionMemo().setPortController(this);
        }
        this.getSystemConnectionMemo().configureManagers();
    }

    @Override
    public void connect() throws IOException {
        log.info("Setting up service");
        this.serverSocket = AsynchronousServerSocketChannel.open();
        this.socketAcceptor = new IpocsSocketAcceptor(this, this.serverSocket);
        InetSocketAddress address = new InetSocketAddress(INADDR_ANY, (int)this.port);
        this.serverSocket.bind(address);
        this.serverSocket.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        this.serverSocket.accept(null, this.socketAcceptor);
        int servicePort = ((InetSocketAddress)this.serverSocket.getLocalAddress()).getPort();
        log.info("Starting ZeroConfService _ipocs._tcp.local for port {}", (Object)servicePort);
        this.zeroConfService = ZeroConfService.create("_ipocs._tcp.local.", "ipocs", servicePort, 0, 0, new HashMap<String, String>());
        this.zeroConfService.publish();
    }

    @Override
    public DataInputStream getInputStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataOutputStream getOutputStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCurrentPortName() {
        return "IPOCSMR";
    }

    public void addListener(IpocsClientListener clientListener) {
        this.clientListeners.add(clientListener);
    }

    public void removeListener(IpocsClientListener clientListener) {
        this.clientListeners.remove(clientListener);
    }

    @Override
    public void clientConnected(IpocsClientHandler client) {
        log.info("New client connected");
    }

    @Override
    public void clientDisconnected(IpocsClientHandler client) {
        new HashMap<String, IpocsClientHandler>(this.clients).forEach((userName, storedClient) -> {
            if (storedClient == client) {
                this.clients.remove(userName);
                this.lastMessage.remove(userName);
                for (IpocsClientListener handler : this.clientListeners) {
                    if (!userName.equals(handler.getUserName())) continue;
                    handler.clientDisconnected(client);
                }
            }
        });
    }

    @Override
    public void onMessage(IpocsClientHandler client, Message msg) {
        this.clients.put(msg.getObjectName(), client);
        this.lastMessage.put(msg.getObjectName(), msg);
        for (IpocsClientListener handler : this.clientListeners) {
            if (!handler.getUserName().equals(msg.getObjectName())) continue;
            handler.onMessage(client, msg);
        }
    }

    public void send(Message msg) {
        IpocsClientHandler client = this.clients.get(msg.getObjectName());
        if (client != null) {
            client.send(msg);
        }
    }

    public Message getLastStatus(String userName) {
        return this.lastMessage.get(userName);
    }

    public short getPort() {
        return this.port;
    }

    public void setPort(short port) {
        this.port = port;
    }
}

