/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.internal;

import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.implementation.AbstractSensor;
import jmri.jmrix.internal.Bundle;
import jmri.jmrix.internal.InternalSystemConnectionMemo;
import jmri.managers.AbstractSensorManager;
import jmri.util.PreferNumericComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalSensorManager
extends AbstractSensorManager {
    static int defaultState = 1;
    protected String prefix = "I";
    private static final Logger log = LoggerFactory.getLogger(InternalSensorManager.class);

    public InternalSensorManager(InternalSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    @Nonnull
    protected Sensor createNewSensor(@Nonnull String systemName, String userName) {
        AbstractSensor sen = new AbstractSensor(systemName, userName){

            @Override
            public void requestUpdateFromLayout() {
            }

            @Override
            public int compareSystemNameSuffix(@Nonnull String suffix1, @Nonnull String suffix2, NamedBean n) {
                return new PreferNumericComparator().compare(suffix1, suffix2);
            }
        };
        try {
            sen.setKnownState(InternalSensorManager.getDefaultStateForNewSensors());
        }
        catch (JmriException ex) {
            log.error("An error occurred while trying to set initial state for sensor {}", (Object)sen.getDisplayName());
            log.error(ex.toString());
        }
        log.debug("Internal Sensor \"{}\", \"{}\" created", (Object)systemName, (Object)userName);
        return sen;
    }

    public static synchronized void setDefaultStateForNewSensors(int defaultSetting) {
        log.debug("Default new-Sensor state set to {}", (Object)defaultSetting);
        defaultState = defaultSetting;
    }

    public static synchronized int getDefaultStateForNewSensors() {
        return defaultState;
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddInputEntryToolTip");
    }

    @Override
    @Nonnull
    public InternalSystemConnectionMemo getMemo() {
        return (InternalSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        return String.valueOf(prefix) + this.typeLetter() + curAddress;
    }
}

