/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.xbee.swing.packetgen;

import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.packet.GenericXBeePacket;
import com.digi.xbee.api.packet.XBeePacket;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import jmri.jmrix.ieee802154.xbee.XBeeTrafficController;
import jmri.jmrix.swing.AbstractPacketGenFrame;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketGenFrame
extends AbstractPacketGenFrame {
    final ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrix.ieee802154.IEEE802154ActionListBundle");
    private XBeeTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(PacketGenFrame.class);

    @Override
    public void initComponents() {
        super.initComponents();
        this.setTitle(this.rb.getString("jmri.jmrix.ieee802154.xbee.swing.packetgen.PacketGenAction"));
        this.pack();
    }

    @Override
    public void sendButtonActionPerformed(ActionEvent e) {
        String packetString = this.packetTextField.getSelectedItem().toString();
        byte[] packetByteArray = StringUtil.bytesFromHexString(packetString);
        GenericXBeePacket packet = GenericXBeePacket.createPacket((byte[])packetByteArray);
        try {
            this.tc.getXBee().sendPacketAsync((XBeePacket)packet);
        }
        catch (XBeeException xbe) {
            log.error("Error Sending message to XBee: {}", (Throwable)xbe);
        }
    }

    public void connect(XBeeTrafficController t) {
        this.tc = t;
    }
}

