/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.xbee.swing.nodeconfig;

import com.digi.xbee.api.RemoteXBeeDevice;
import com.digi.xbee.api.listeners.IDiscoveryListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import jmri.jmrix.ieee802154.IEEE802154SystemConnectionMemo;
import jmri.jmrix.ieee802154.swing.nodeconfig.NodeConfigFrame;
import jmri.jmrix.ieee802154.xbee.XBeeConnectionMemo;
import jmri.jmrix.ieee802154.xbee.XBeeNode;
import jmri.jmrix.ieee802154.xbee.XBeeTrafficController;
import jmri.jmrix.ieee802154.xbee.swing.nodeconfig.AssignmentTableModel;
import jmri.jmrix.ieee802154.xbee.swing.nodeconfig.Bundle;
import jmri.jmrix.ieee802154.xbee.swing.nodeconfig.XBeeAddNodeFrame;
import jmri.jmrix.ieee802154.xbee.swing.nodeconfig.XBeeEditNodeFrame;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XBeeNodeConfigFrame
extends NodeConfigFrame
implements IDiscoveryListener {
    private XBeeTrafficController xtc = null;
    protected JButton discoverButton = new JButton(Bundle.getMessage("ButtonDiscover"));
    private JComboBox<XBeeNode> nodeField = new JComboBox();
    protected JTable assignmentTable = null;
    protected TableModel assignmentListModel = null;
    protected JPanel assignmentPanel = null;
    private static final Logger log = LoggerFactory.getLogger(XBeeNodeConfigFrame.class);

    public XBeeNodeConfigFrame(XBeeTrafficController tc) {
        super(tc);
        this.xtc = tc;
    }

    @Override
    public void initComponents() {
        this.setTitle(Bundle.getMessage("WindowTitle"));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(this.initAddressPanel());
        this.assignmentPanel = new JPanel();
        this.assignmentPanel.setLayout(new BoxLayout(this.assignmentPanel, 1));
        this.assignmentListModel = new AssignmentTableModel();
        this.assignmentTable = new JTable(this.assignmentListModel);
        this.assignmentTable.setRowSelectionAllowed(false);
        this.assignmentTable.setPreferredScrollableViewportSize(new Dimension(300, 350));
        JScrollPane assignmentScrollPane = new JScrollPane(this.assignmentTable);
        this.assignmentPanel.add((Component)assignmentScrollPane, "Center");
        contentPane.add(this.assignmentPanel);
        contentPane.add(this.initNotesPanel());
        contentPane.add(this.initButtonPanel());
        this.pack();
        this.xtc.getXBee().getNetwork().addDiscoveryListener((IDiscoveryListener)this);
    }

    @Override
    protected JPanel initAddressPanel() {
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 1));
        JPanel panel11 = new JPanel();
        panel11.setLayout(new FlowLayout());
        panel11.add(new JLabel(String.valueOf(Bundle.getMessage("LabelNodeSelection")) + " "));
        panel11.add(this.nodeField);
        this.nodeField.setToolTipText(Bundle.getMessage("TipNodeSelection"));
        this.nodeField.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                XBeeNodeConfigFrame.this.nodeSelected();
            }
        });
        this.initAddressBoxes();
        panel1.add(panel11);
        return panel1;
    }

    @Override
    protected JPanel initButtonPanel() {
        JPanel panel4 = new JPanel();
        panel4.setLayout(new FlowLayout());
        this.addButton.setText(Bundle.getMessage("ButtonAdd"));
        this.addButton.setVisible(true);
        this.addButton.setToolTipText(Bundle.getMessage("TipAddButton"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XBeeNodeConfigFrame.this.addButtonActionPerformed();
            }
        });
        panel4.add(this.addButton);
        this.discoverButton.setText(Bundle.getMessage("ButtonDiscover"));
        this.discoverButton.setVisible(true);
        this.discoverButton.setToolTipText(Bundle.getMessage("TipAddButton"));
        this.discoverButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XBeeNodeConfigFrame.this.discoverButtonActionPerformed();
            }
        });
        this.discoverButton.setEnabled(!this.xtc.getXBee().getNetwork().isDiscoveryRunning());
        panel4.add(this.discoverButton);
        this.editButton.setText(Bundle.getMessage("ButtonEdit"));
        this.editButton.setVisible(true);
        this.editButton.setToolTipText(Bundle.getMessage("TipEditButton"));
        panel4.add(this.editButton);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XBeeNodeConfigFrame.this.editButtonActionPerformed();
            }
        });
        panel4.add(this.deleteButton);
        this.deleteButton.setText(Bundle.getMessage("ButtonDelete"));
        this.deleteButton.setVisible(true);
        this.deleteButton.setToolTipText(Bundle.getMessage("TipDeleteButton"));
        panel4.add(this.deleteButton);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XBeeNodeConfigFrame.this.deleteButtonActionPerformed();
            }
        });
        panel4.add(this.doneButton);
        this.doneButton.setText(Bundle.getMessage("ButtonDone"));
        this.doneButton.setVisible(true);
        this.doneButton.setToolTipText(Bundle.getMessage("TipDoneButton"));
        panel4.add(this.doneButton);
        this.doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XBeeNodeConfigFrame.this.doneButtonActionPerformed();
            }
        });
        panel4.add(this.updateButton);
        this.updateButton.setText(Bundle.getMessage("ButtonUpdate"));
        this.updateButton.setVisible(true);
        this.updateButton.setToolTipText(Bundle.getMessage("TipUpdateButton"));
        panel4.add(this.updateButton);
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XBeeNodeConfigFrame.this.updateButtonActionPerformed();
            }
        });
        this.updateButton.setVisible(false);
        panel4.add(this.cancelButton);
        this.cancelButton.setText(Bundle.getMessage("ButtonCancel"));
        this.cancelButton.setVisible(true);
        this.cancelButton.setToolTipText(Bundle.getMessage("TipCancelButton"));
        panel4.add(this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XBeeNodeConfigFrame.this.cancelButtonActionPerformed();
            }
        });
        this.cancelButton.setVisible(false);
        return panel4;
    }

    @Override
    public void addButtonActionPerformed() {
        XBeeAddNodeFrame addFrame = new XBeeAddNodeFrame(this.xtc, this);
        try {
            ((JmriJFrame)addFrame).initComponents();
        }
        catch (Exception ex) {
            log.error("Exception initializing Frame: {}", (Object)ex.toString());
            return;
        }
        addFrame.setVisible(true);
    }

    public void discoverButtonActionPerformed() {
        if (this.xtc.getXBee().getNetwork().isDiscoveryRunning()) {
            log.debug("Discovery process already running");
            this.discoverButton.setEnabled(false);
            this.statusText1.setText(Bundle.getMessage("FeedBackDiscover"));
            return;
        }
        IEEE802154SystemConnectionMemo memo = this.xtc.getAdapterMemo();
        if (memo instanceof XBeeConnectionMemo) {
            XBeeConnectionMemo m = (XBeeConnectionMemo)memo;
            m.getXBeeNodeManager().startNodeDiscovery();
            this.discoverButton.setEnabled(false);
        }
        this.statusText1.setText(Bundle.getMessage("FeedBackDiscover"));
        this.errorInStatus1 = true;
        this.resetNotes2();
    }

    @Override
    public void editButtonActionPerformed() {
        this.curNode = (XBeeNode)this.nodeField.getSelectedItem();
        if (this.curNode == null) {
            this.statusText1.setText(Bundle.getMessage("Error4"));
            this.statusText1.setVisible(true);
            this.errorInStatus1 = true;
            this.resetNotes2();
            return;
        }
        XBeeEditNodeFrame editFrame = new XBeeEditNodeFrame(this.xtc, (XBeeNode)this.curNode, this);
        try {
            ((JmriJFrame)editFrame).initComponents();
        }
        catch (Exception ex) {
            log.error("Exception initializing Frame: {}", (Object)ex.toString());
            return;
        }
        editFrame.setVisible(true);
    }

    @Override
    public void deleteButtonActionPerformed() {
        this.curNode = (XBeeNode)this.nodeField.getSelectedItem();
        if (this.curNode == null) {
            this.statusText1.setText(Bundle.getMessage("Error4"));
            this.statusText1.setVisible(true);
            this.errorInStatus1 = true;
            this.resetNotes2();
            return;
        }
        if (JOptionPane.showConfirmDialog(this, String.valueOf(Bundle.getMessage("ConfirmDelete1")) + "\n" + Bundle.getMessage("ConfirmDelete2"), Bundle.getMessage("ConfirmDeleteTitle"), 2, 2) == 0) {
            this.xtc.deleteNode((XBeeNode)this.curNode);
            this.resetNotes();
            this.statusText1.setText(String.valueOf(Bundle.getMessage("FeedBackDelete")) + " " + this.curNode.toString());
            this.errorInStatus1 = true;
            this.changedNode = true;
        } else {
            this.resetNotes();
        }
        this.initAddressBoxes();
    }

    @Override
    public void doneButtonActionPerformed() {
        if (this.editMode) {
            this.editMode = false;
            this.curNode = null;
            this.addButton.setVisible(true);
            this.editButton.setVisible(true);
            this.deleteButton.setVisible(true);
            this.doneButton.setVisible(true);
            this.updateButton.setVisible(false);
            this.cancelButton.setVisible(false);
        }
        if (this.changedNode) {
            JOptionPane.showMessageDialog(this, String.valueOf(Bundle.getMessage("Reminder1")) + "\n" + Bundle.getMessage("Reminder2"), Bundle.getMessage("ReminderTitle"), 1);
        }
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void updateButtonActionPerformed() {
        if (!this.checkConsistency()) {
            return;
        }
        this.setNodeParameters();
        this.changedNode = true;
        this.editMode = false;
        this.curNode = null;
        this.addButton.setVisible(true);
        this.editButton.setVisible(true);
        this.deleteButton.setVisible(true);
        this.doneButton.setVisible(true);
        this.updateButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.statusText2.setText(this.stdStatus2);
        this.statusText3.setText(this.stdStatus3);
        try {
            this.statusText1.setText(String.valueOf(Bundle.getMessage("FeedBackUpdate")) + " " + this.readNodeAddress());
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.errorInStatus1 = true;
    }

    @Override
    public void cancelButtonActionPerformed() {
        this.editMode = false;
        this.curNode = null;
        this.addButton.setVisible(true);
        this.editButton.setVisible(true);
        this.deleteButton.setVisible(true);
        this.doneButton.setVisible(true);
        this.updateButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.statusText1.setText(this.stdStatus1);
        this.statusText2.setText(this.stdStatus2);
        this.statusText3.setText(this.stdStatus3);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.doneButtonActionPerformed();
        super.windowClosing(e);
    }

    @Override
    protected void setNodeParameters() {
        super.setNodeParameters();
    }

    private void resetNotes() {
        if (this.errorInStatus1) {
            if (this.editMode) {
                this.statusText1.setText(this.editStatus1);
            } else {
                this.statusText1.setText(this.stdStatus1);
            }
            this.errorInStatus1 = false;
        }
        this.resetNotes2();
    }

    private void resetNotes2() {
        if (this.errorInStatus2) {
            if (this.editMode) {
                this.statusText1.setText(this.editStatus2);
            } else {
                this.statusText2.setText(this.stdStatus2);
            }
            this.errorInStatus2 = false;
        }
    }

    private String readNodeAddress() {
        String addr = "";
        addr = (String)this.nodeAddrField.getSelectedItem();
        if ((addr == null || addr.equals("FF FE ") || addr.equals("FF FF ")) && (addr = (String)this.nodeAddr64Field.getSelectedItem()) == null) {
            throw new IllegalArgumentException("Invalid Address");
        }
        return addr;
    }

    @Override
    protected boolean checkConsistency() {
        return true;
    }

    @Override
    protected void initAddressBoxes() {
        this.nodeField.removeAllItems();
        int i = 0;
        while (i < this.xtc.getNumNodes()) {
            this.nodeField.insertItemAt((XBeeNode)this.xtc.getNode(i), i);
            ++i;
        }
        this.nodeField.insertItemAt(null, 0);
    }

    void nodeListChanged() {
        this.initAddressBoxes();
    }

    @Override
    protected void nodeSelected() {
        log.debug("node {} selected", this.nodeField.getSelectedItem());
        ((AssignmentTableModel)this.assignmentListModel).setNode((XBeeNode)this.nodeField.getSelectedItem());
    }

    public void deviceDiscovered(RemoteXBeeDevice discoveredDevice) {
        log.debug("New Device discovered {}", (Object)discoveredDevice.toString());
    }

    public void discoveryError(String error) {
        log.error("Error during node discovery process: {}", (Object)error);
    }

    public void discoveryFinished(String error) {
        if (error != null) {
            log.error("Node discovery processed finished with error: {}", (Object)error);
            this.statusText1.setText(Bundle.getMessage("FeedBackDiscoverFail"));
        } else {
            log.debug("Node discovery process completed successfully.");
            this.statusText1.setText(Bundle.getMessage("FeedBackDiscoverSuccess"));
            this.initAddressBoxes();
        }
        this.discoverButton.setEnabled(true);
    }
}

