/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.xbee.swing.nodeconfig;

import com.digi.xbee.api.RemoteXBeeDevice;
import com.digi.xbee.api.models.XBee16BitAddress;
import com.digi.xbee.api.models.XBee64BitAddress;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.jmrix.ieee802154.swing.nodeconfig.EditNodeFrame;
import jmri.jmrix.ieee802154.xbee.XBeeNode;
import jmri.jmrix.ieee802154.xbee.XBeeTrafficController;
import jmri.jmrix.ieee802154.xbee.swing.nodeconfig.Bundle;
import jmri.jmrix.ieee802154.xbee.swing.nodeconfig.StreamConfigPane;
import jmri.jmrix.ieee802154.xbee.swing.nodeconfig.XBeeNodeConfigFrame;
import jmri.util.StringUtil;

public class XBeeEditNodeFrame
extends EditNodeFrame {
    private XBeeTrafficController xtc = null;
    private JTextField nodeIdentifierField = new JTextField();
    private XBeeNodeConfigFrame parent = null;

    public XBeeEditNodeFrame(XBeeTrafficController tc, XBeeNode node, XBeeNodeConfigFrame source) {
        super(tc, node);
        this.xtc = tc;
        this.parent = source;
        this.curNode = node;
    }

    @Override
    public void initComponents() {
        this.setTitle(Bundle.getMessage("EditNodeWindowTitle"));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(new JLabel(String.valueOf(Bundle.getMessage("LabelNodeAddress")) + " "));
        panel.add(this.nodeAddrField);
        this.nodeAddrField.setToolTipText(Bundle.getMessage("TipNodeAddress"));
        panel.add(new JLabel(String.valueOf(Bundle.getMessage("LabelNodeAddress64")) + " "));
        panel.add(this.nodeAddr64Field);
        this.nodeAddr64Field.setToolTipText(Bundle.getMessage("TipNodeAddress64"));
        panel.add(new JLabel(String.valueOf(Bundle.getMessage("LabelNodeIdentifier")) + " "));
        panel.add(this.nodeIdentifierField);
        this.nodeIdentifierField.setToolTipText(Bundle.getMessage("TipNodeIdentifier"));
        this.initAddressBoxes();
        contentPane.add(panel);
        StreamConfigPane streamPane = StreamConfigPane.createPanel((XBeeNode)this.curNode);
        streamPane.setXBeeNode((XBeeNode)this.curNode);
        contentPane.add(streamPane);
        JPanel panel4 = new JPanel();
        panel4.setLayout(new FlowLayout());
        this.editButton.setText(Bundle.getMessage("ButtonEdit"));
        this.editButton.setVisible(true);
        this.editButton.setToolTipText(Bundle.getMessage("TipEditButton"));
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XBeeEditNodeFrame.this.editButtonActionPerformed();
            }
        });
        panel4.add(this.editButton);
        panel4.add(this.cancelButton);
        this.cancelButton.setText(Bundle.getMessage("ButtonCancel"));
        this.cancelButton.setVisible(true);
        this.cancelButton.setToolTipText(Bundle.getMessage("TipCancelButton"));
        panel4.add(this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XBeeEditNodeFrame.this.cancelButtonActionPerformed();
            }
        });
        contentPane.add(panel4);
        this.pack();
    }

    @Override
    public void editButtonActionPerformed() {
        XBee16BitAddress address;
        XBee64BitAddress guid;
        if (this.nodeAddr64Field.getText().equals("") && this.nodeAddrField.getText().equals("")) {
            return;
        }
        if (!this.nodeAddr64Field.getText().equals("")) {
            byte[] GUID2 = StringUtil.bytesFromHexString(this.nodeAddr64Field.getText());
            guid = new XBee64BitAddress(GUID2);
        } else {
            guid = XBee64BitAddress.UNKNOWN_ADDRESS;
        }
        if (!this.nodeAddrField.getText().equals("")) {
            byte[] addr = StringUtil.bytesFromHexString(this.nodeAddrField.getText());
            address = new XBee16BitAddress(addr);
        } else {
            address = XBee16BitAddress.UNKNOWN_ADDRESS;
        }
        String Identifier = this.nodeIdentifierField.getText();
        RemoteXBeeDevice remoteDevice = new RemoteXBeeDevice(this.xtc.getXBee(), guid, address, Identifier);
        RemoteXBeeDevice oldDevice = ((XBeeNode)this.curNode).getXBee();
        this.xtc.getXBee().getNetwork().addRemoteDevice(remoteDevice);
        this.xtc.getXBee().getNetwork().removeRemoteDevice(oldDevice);
        ((XBeeNode)this.curNode).setXBee(remoteDevice);
        this.parent.nodeListChanged();
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    @Override
    public void cancelButtonActionPerformed() {
        this.curNode = null;
        this.editButton.setVisible(true);
        this.cancelButton.setVisible(false);
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    @Override
    protected void initAddressBoxes() {
        this.nodeAddrField.setText(StringUtil.hexStringFromBytes(this.curNode.getUserAddress()));
        this.nodeAddr64Field.setText(StringUtil.hexStringFromBytes(this.curNode.getGlobalAddress()));
        this.nodeIdentifierField.setText(((XBeeNode)this.curNode).getIdentifier());
    }
}

