/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.xbee.swing.nodeconfig;

import com.digi.xbee.api.RemoteXBeeDevice;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.models.XBee16BitAddress;
import com.digi.xbee.api.models.XBee64BitAddress;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.jmrix.ieee802154.swing.nodeconfig.AddNodeFrame;
import jmri.jmrix.ieee802154.xbee.XBeeNode;
import jmri.jmrix.ieee802154.xbee.XBeeTrafficController;
import jmri.jmrix.ieee802154.xbee.swing.nodeconfig.Bundle;
import jmri.jmrix.ieee802154.xbee.swing.nodeconfig.XBeeNodeConfigFrame;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XBeeAddNodeFrame
extends AddNodeFrame {
    private XBeeTrafficController xtc = null;
    private final JTextField nodeIdentifierField = new JTextField();
    private XBeeNodeConfigFrame parent = null;
    private static final Logger log = LoggerFactory.getLogger(XBeeAddNodeFrame.class);

    public XBeeAddNodeFrame(XBeeTrafficController tc, XBeeNodeConfigFrame source) {
        super(tc);
        this.xtc = tc;
        this.parent = source;
    }

    @Override
    public void initComponents() {
        this.setTitle(Bundle.getMessage("AddNodeWindowTitle"));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(new JLabel(String.valueOf(Bundle.getMessage("LabelNodeAddress")) + " "));
        panel.add(this.nodeAddrField);
        this.nodeAddrField.setToolTipText(Bundle.getMessage("TipNodeAddress"));
        panel.add(new JLabel(String.valueOf(Bundle.getMessage("LabelNodeAddress64")) + " "));
        panel.add(this.nodeAddr64Field);
        this.nodeAddr64Field.setToolTipText(Bundle.getMessage("TipNodeAddress64"));
        panel.add(new JLabel(String.valueOf(Bundle.getMessage("LabelNodeIdentifier")) + " "));
        panel.add(this.nodeIdentifierField);
        this.nodeIdentifierField.setToolTipText(Bundle.getMessage("TipNodeIdentifier"));
        this.initAddressBoxes();
        contentPane.add(panel);
        JPanel panel4 = new JPanel();
        panel4.setLayout(new FlowLayout());
        this.addButton.setText(Bundle.getMessage("ButtonAdd"));
        this.addButton.setVisible(true);
        this.addButton.setToolTipText(Bundle.getMessage("TipAddButton"));
        this.addButton.addActionListener(e -> this.addButtonActionPerformed());
        panel4.add(this.addButton);
        panel4.add(this.cancelButton);
        this.cancelButton.setText(Bundle.getMessage("ButtonCancel"));
        this.cancelButton.setVisible(true);
        this.cancelButton.setToolTipText(Bundle.getMessage("TipCancelButton"));
        panel4.add(this.cancelButton);
        this.cancelButton.addActionListener(e -> this.cancelButtonActionPerformed());
        contentPane.add(panel4);
        this.pack();
    }

    @Override
    public void addButtonActionPerformed() {
        XBee16BitAddress address;
        XBee64BitAddress guid;
        if (this.nodeAddr64Field.getText().equals("") && this.nodeAddrField.getText().equals("")) {
            return;
        }
        if (!this.nodeAddr64Field.getText().equals("")) {
            byte[] GUID2 = StringUtil.bytesFromHexString(this.nodeAddr64Field.getText());
            guid = new XBee64BitAddress(GUID2);
        } else {
            guid = XBee64BitAddress.UNKNOWN_ADDRESS;
        }
        if (!this.nodeAddrField.getText().equals("")) {
            byte[] addr = StringUtil.bytesFromHexString(this.nodeAddrField.getText());
            address = new XBee16BitAddress(addr);
        } else {
            address = XBee16BitAddress.UNKNOWN_ADDRESS;
        }
        String Identifier = this.nodeIdentifierField.getText();
        RemoteXBeeDevice remoteDevice = new RemoteXBeeDevice(this.xtc.getXBee(), guid, address, Identifier);
        this.curNode = (XBeeNode)this.xtc.getNodeFromXBeeDevice(remoteDevice);
        if (this.curNode != null) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("Error1", remoteDevice), Bundle.getMessage("AddNodeErrorTitle"), 0);
            return;
        }
        try {
            this.xtc.getXBee().getNetwork().addRemoteDevice(remoteDevice);
            XBeeNode node = new XBeeNode(remoteDevice);
            this.xtc.registerNode(node);
            this.parent.nodeListChanged();
        }
        catch (TimeoutException timeoutException) {
            log.error("Timeout adding node {}.", (Object)remoteDevice);
            JOptionPane.showMessageDialog(this, Bundle.getMessage("Error3"), Bundle.getMessage("AddNodeErrorTitle"), 0);
            log.error("Error creating XBee Node, constructor returned null");
            return;
        }
        catch (XBeeException xBeeException) {
            log.error("Exception adding node {}.", (Object)remoteDevice);
            JOptionPane.showMessageDialog(this, Bundle.getMessage("Error3"), Bundle.getMessage("AddNodeErrorTitle"), 0);
            log.error("Error creating XBee Node, constructor returned null");
            return;
        }
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    @Override
    public void cancelButtonActionPerformed() {
        this.curNode = null;
        this.addButton.setVisible(true);
        this.cancelButton.setVisible(false);
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    @Override
    protected void initAddressBoxes() {
        this.nodeAddrField.setText("");
        this.nodeAddr64Field.setText("");
        this.nodeIdentifierField.setText("");
    }
}

