/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.xbee;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.Turnout;
import jmri.jmrix.ieee802154.xbee.Bundle;
import jmri.jmrix.ieee802154.xbee.XBeeConnectionMemo;
import jmri.jmrix.ieee802154.xbee.XBeeNode;
import jmri.jmrix.ieee802154.xbee.XBeeTrafficController;
import jmri.jmrix.ieee802154.xbee.XBeeTurnout;
import jmri.managers.AbstractTurnoutManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XBeeTurnoutManager
extends AbstractTurnoutManager {
    protected XBeeTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(XBeeTurnoutManager.class);

    public XBeeTurnoutManager(XBeeConnectionMemo memo) {
        super(memo);
        this.tc = (XBeeTrafficController)memo.getTrafficController();
    }

    @Override
    @Nonnull
    public XBeeConnectionMemo getMemo() {
        return (XBeeConnectionMemo)this.memo;
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return false;
    }

    @Override
    @Nonnull
    protected Turnout createNewTurnout(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        String name = this.addressFromSystemName(systemName);
        XBeeNode curNode = (XBeeNode)this.tc.getNodeFromName(name);
        if (curNode == null && (curNode = (XBeeNode)this.tc.getNodeFromAddress(name)) == null) {
            try {
                curNode = (XBeeNode)this.tc.getNodeFromAddress(Integer.parseInt(name));
            }
            catch (NumberFormatException numberFormatException) {
                log.debug("failed to create turnout {}", (Object)systemName);
                throw new IllegalArgumentException("Cannot find Node, check Turnout System Name " + systemName);
            }
        }
        int pin = this.pinFromSystemName(systemName);
        int pin2 = this.pin2FromSystemName(systemName);
        if (!(curNode.getPinAssigned(pin) || pin2 != -1 && curNode.getPinAssigned(pin2))) {
            log.debug("Adding turnout to pin {}", (Object)pin);
            curNode.setPinBean(pin, new XBeeTurnout(systemName, userName, this.tc));
            if (pin2 != -1) {
                curNode.setPinBean(pin2, curNode.getPinBean(pin));
            }
            return (XBeeTurnout)curNode.getPinBean(pin);
        }
        log.debug("failed to create turnout {}", (Object)systemName);
        throw new IllegalArgumentException("Cannot create Turnout " + systemName + ", check pins.");
    }

    @Override
    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        return String.valueOf(prefix) + this.typeLetter() + curAddress;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) {
        super.validateSystemNameFormat(name, locale);
        int pin = this.pinFromSystemName(name);
        int pin2 = this.pin2FromSystemName(name);
        if (pin < 0 || pin > 7) {
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "SystemNameInvalidPin", name), Bundle.getMessage(locale, "SystemNameInvalidPin", name));
        }
        if (pin2 != -1 && (pin2 < 0 || pin2 > 7)) {
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "SystemNameInvalidPin", name), Bundle.getMessage(locale, "SystemNameInvalidPin", name));
        }
        return name;
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        if (this.tc.getNodeFromName(this.addressFromSystemName(systemName)) == null && this.tc.getNodeFromAddress(this.addressFromSystemName(systemName)) == null) {
            try {
                if (this.tc.getNodeFromAddress(Integer.parseInt(this.addressFromSystemName(systemName))) == null) {
                    return Manager.NameValidity.INVALID;
                }
                return this.pinFromSystemName(systemName) >= 0 && this.pinFromSystemName(systemName) <= 7 && (this.pin2FromSystemName(systemName) == -1 || this.pin2FromSystemName(systemName) >= 0 && this.pin2FromSystemName(systemName) <= 7) ? Manager.NameValidity.VALID : Manager.NameValidity.INVALID;
            }
            catch (NumberFormatException numberFormatException) {
                log.error("Unable to convert {} into the Xbee node and pin format of nn:xx", (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
        }
        return this.pinFromSystemName(systemName) >= 0 && this.pinFromSystemName(systemName) <= 7 && (this.pin2FromSystemName(systemName) == -1 || this.pin2FromSystemName(systemName) >= 0 && this.pin2FromSystemName(systemName) <= 7) ? Manager.NameValidity.VALID : Manager.NameValidity.INVALID;
    }

    private String addressFromSystemName(@Nonnull String systemName) {
        String encoderAddress;
        if (systemName.contains(":")) {
            int seperator = systemName.indexOf(":");
            encoderAddress = systemName.substring(this.getSystemPrefix().length() + 1, seperator);
        } else {
            encoderAddress = systemName.substring(this.getSystemPrefix().length() + 1, systemName.length() - 1);
        }
        log.debug("Converted {} to hardware address {}", (Object)systemName, (Object)encoderAddress);
        return encoderAddress;
    }

    private int pinFromSystemName(@Nonnull String systemName) {
        int input = 0;
        int iName = 0;
        if (systemName.contains(":")) {
            int seperator = systemName.indexOf(":");
            int seperator2 = systemName.indexOf(":", seperator + 1);
            int len = systemName.length();
            try {
                if (seperator2 >= 0 && seperator2 <= len) {
                    input = Integer.parseInt(systemName.substring(seperator + 1, seperator2));
                }
                input = Integer.parseInt(systemName.substring(seperator + 1, len));
            }
            catch (NumberFormatException numberFormatException) {
                log.debug("Unable to convert {} into the XBee node and pin format of nn:xx", (Object)systemName);
                return -1;
            }
        } else {
            try {
                iName = Integer.parseInt(systemName.substring(this.getSystemPrefix().length() + 1));
                input = iName % 10;
            }
            catch (NumberFormatException numberFormatException) {
                log.debug("Unable to convert {} system name to a number", (Object)systemName);
                return -1;
            }
        }
        log.debug("Converted {} to pin number {}", (Object)systemName, (Object)input);
        return input;
    }

    private int pin2FromSystemName(@Nonnull String systemName) {
        int input = 0;
        if (systemName.contains(":")) {
            int seperator = systemName.indexOf(":");
            int seperator2 = systemName.indexOf(":", seperator + 1);
            try {
                input = Integer.parseInt(systemName.substring(seperator2 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                log.debug("Unable to convert {} into the cab and input format of nn:xx", (Object)systemName);
                return -1;
            }
        } else {
            input = -1;
        }
        log.debug("Converted {} to pin number {}", (Object)systemName, (Object)input);
        return input;
    }

    @Override
    public void deregister(@Nonnull Turnout t) {
        super.deregister(t);
        String systemName = t.getSystemName();
        String name = this.addressFromSystemName(systemName);
        int pin = this.pinFromSystemName(systemName);
        XBeeNode curNode = (XBeeNode)this.tc.getNodeFromName(name);
        if (curNode == null && (curNode = (XBeeNode)this.tc.getNodeFromAddress(name)) == null) {
            try {
                curNode = (XBeeNode)this.tc.getNodeFromAddress(Integer.parseInt(name));
            }
            catch (NumberFormatException numberFormatException) {
                curNode = null;
            }
        }
        if (curNode != null) {
            if (curNode.removePinBean(pin, t)) {
                log.debug("Removing turnout from pin {}", (Object)pin);
            } else {
                log.debug("Failed to removing turnout from pin {}", (Object)pin);
            }
        }
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddTurnoutEntryToolTip");
    }
}

