/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.xbee;

import com.digi.xbee.api.exceptions.InterfaceNotOpenException;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.io.IOLine;
import com.digi.xbee.api.io.IOValue;
import jmri.implementation.AbstractTurnout;
import jmri.jmrix.ieee802154.xbee.XBeeConnectionMemo;
import jmri.jmrix.ieee802154.xbee.XBeeNode;
import jmri.jmrix.ieee802154.xbee.XBeeTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XBeeTurnout
extends AbstractTurnout {
    private String nodeIdentifier;
    private XBeeNode node = null;
    private int address;
    private int pin;
    private int pin2 = -1;
    private String systemName;
    protected XBeeTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(XBeeTurnout.class);

    public XBeeTurnout(String systemName, String userName, XBeeTrafficController controller) {
        super(systemName, userName);
        this.tc = controller;
        this.init(systemName);
    }

    public XBeeTurnout(String systemName, XBeeTrafficController controller) {
        super(systemName);
        this.tc = controller;
        this.init(systemName);
    }

    /*
     * Unable to fully structure code
     */
    private void init(String id) {
        this.systemName = id;
        m = this.tc.getAdapterMemo();
        if (!(m instanceof XBeeConnectionMemo)) {
            XBeeTurnout.log.error("Memo associated with the traffic controller is not the right type");
            throw new IllegalArgumentException("Memo associated with the traffic controller is not the right type");
        }
        memo = (XBeeConnectionMemo)m;
        prefix = memo.getTurnoutManager().getSystemPrefix();
        if (this.systemName.contains(":")) {
            seperator = this.systemName.indexOf(":");
            seperator2 = this.systemName.indexOf(":", seperator + 1);
            try {
                this.nodeIdentifier = this.systemName.substring(prefix.length() + 1, seperator);
                this.node = (XBeeNode)this.tc.getNodeFromName(this.nodeIdentifier);
                if (this.node == null && (this.node = (XBeeNode)this.tc.getNodeFromAddress(this.nodeIdentifier)) == null) {
                    try {
                        this.node = (XBeeNode)this.tc.getNodeFromAddress(Integer.parseInt(this.nodeIdentifier));
                    }
                    catch (NumberFormatException v0) {
                        this.node = null;
                        throw new IllegalArgumentException("Node not defined");
                    }
                }
                this.pin = Integer.parseInt(this.systemName.substring(seperator + 1, seperator2 > 0 ? seperator2 : this.systemName.length()));
                if (seperator2 <= 0) ** GOTO lbl37
                this.pin2 = Integer.parseInt(this.systemName.substring(seperator2 + 1));
            }
            catch (NumberFormatException v1) {
                XBeeTurnout.log.debug("Unable to convert {} into the cab and input format of nn:xx", (Object)this.systemName);
                throw new IllegalArgumentException("Unable to convert " + this.systemName + " into the cab and input format of nn:xx");
            }
        } else {
            try {
                this.nodeIdentifier = this.systemName.substring(prefix.length() + 1, id.length() - 1);
                this.address = Integer.parseInt(this.systemName.substring(prefix.length() + 1));
                this.node = (XBeeNode)this.tc.getNodeFromAddress(this.address / 10);
                this.pin = this.address % 10;
            }
            catch (NumberFormatException v2) {
                XBeeTurnout.log.debug("Unable to convert {} Hardware Address to a number", (Object)this.systemName);
                throw new IllegalArgumentException("Unable to convert " + this.systemName + " Hardware Address to a number");
            }
        }
lbl37:
        // 3 sources

        if (XBeeTurnout.log.isDebugEnabled()) {
            XBeeTurnout.log.debug("Created Turnout {} (NodeIdentifier {} D{}{})", new Object[]{this.systemName, this.nodeIdentifier, this.pin, this.pin2 > 0 ? " D" + this.pin2 : ""});
        }
    }

    @Override
    protected void forwardCommandChangeToLayout(int s) {
        try {
            if (s == 4 ^ this.getInverted()) {
                this.node.getXBee().setDIOValue(IOLine.getDIO((int)this.pin), IOValue.HIGH);
            } else {
                this.node.getXBee().setDIOValue(IOLine.getDIO((int)this.pin), IOValue.LOW);
            }
            if (this.pin2 >= 0) {
                if (s == 2 ^ this.getInverted()) {
                    this.node.getXBee().setDIOValue(IOLine.getDIO((int)this.pin), IOValue.HIGH);
                } else {
                    this.node.getXBee().setDIOValue(IOLine.getDIO((int)this.pin), IOValue.LOW);
                }
            }
        }
        catch (TimeoutException timeoutException) {
            log.error("Timeout setting IO line value for turnout {} on {}", (Object)this.getUserName(), (Object)this.node.getXBee());
        }
        catch (InterfaceNotOpenException interfaceNotOpenException) {
            log.error("Interface Not Open setting IO line value for turnout {} on {}", (Object)this.getUserName(), (Object)this.node.getXBee());
        }
        catch (XBeeException xBeeException) {
            log.error("Error setting IO line value for turout {} on {}", (Object)this.getUserName(), (Object)this.node.getXBee());
        }
    }

    @Override
    public boolean canInvert() {
        return true;
    }

    @Override
    protected void turnoutPushbuttonLockout(boolean locked) {
    }
}

