/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.xbee;

import com.digi.xbee.api.RemoteXBeeDevice;
import com.digi.xbee.api.XBeeDevice;
import com.digi.xbee.api.connection.IConnectionInterface;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.listeners.IDataReceiveListener;
import com.digi.xbee.api.listeners.IModemStatusReceiveListener;
import com.digi.xbee.api.listeners.IPacketReceiveListener;
import com.digi.xbee.api.models.ModemStatusEvent;
import com.digi.xbee.api.packet.XBeePacket;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.swing.SwingUtilities;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.AbstractMRTrafficController;
import jmri.jmrix.AbstractNode;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.ieee802154.IEEE802154Listener;
import jmri.jmrix.ieee802154.IEEE802154Message;
import jmri.jmrix.ieee802154.IEEE802154Node;
import jmri.jmrix.ieee802154.IEEE802154Reply;
import jmri.jmrix.ieee802154.IEEE802154TrafficController;
import jmri.jmrix.ieee802154.xbee.XBeeAdapter;
import jmri.jmrix.ieee802154.xbee.XBeeInterface;
import jmri.jmrix.ieee802154.xbee.XBeeListener;
import jmri.jmrix.ieee802154.xbee.XBeeMessage;
import jmri.jmrix.ieee802154.xbee.XBeeNode;
import jmri.jmrix.ieee802154.xbee.XBeeReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XBeeTrafficController
extends IEEE802154TrafficController
implements IPacketReceiveListener,
IModemStatusReceiveListener,
IDataReceiveListener,
XBeeInterface {
    private XBeeDevice xbee = null;
    private static final Logger log = LoggerFactory.getLogger(XBeeTrafficController.class);

    @Override
    public IEEE802154Message getIEEE802154Message(int length) {
        return null;
    }

    @Override
    protected AbstractMRReply newReply() {
        return new XBeeReply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"UW_UNCOND_WAIT", "WA_NOT_IN_LOOP"}, justification="The unconditional wait outside of a loop is used to allow the hardware to react to a reset request.")
    public void connectPort(AbstractPortController p) {
        try {
            if (p instanceof XBeeAdapter) {
                XBeeAdapter xbp = (XBeeAdapter)p;
                this.xbee = new XBeeDevice((IConnectionInterface)xbp);
                this.xbee.open();
                this.xbee.reset();
                try {
                    XBeeTrafficController xBeeTrafficController = this;
                    synchronized (xBeeTrafficController) {
                        this.wait(2000L);
                    }
                }
                catch (InterruptedException interruptedException) {}
            } else {
                throw new IllegalArgumentException("Wrong adapter type specified when connecting to the port.");
            }
            this.xbee.addPacketListener((IPacketReceiveListener)this);
            this.xbee.addModemStatusListener((IModemStatusReceiveListener)this);
            this.xbee.addDataListener((IDataReceiveListener)this);
        }
        catch (TimeoutException te) {
            log.error("Timeout during communication with Local XBee on communication start up. Error was {} cause {} ", (Object)te, (Object)te.getCause());
        }
        catch (XBeeException xbe) {
            log.error("Exception during XBee communication start up. Error was {} cause {} ", (Object)xbe, (Object)xbe.getCause());
        }
    }

    @Override
    protected synchronized void forwardToPort(AbstractMRMessage m, AbstractMRListener reply) {
        if (log.isDebugEnabled()) {
            log.debug("forwardToPort message: [{}]", (Object)m);
        }
        this.mLastSender = reply;
        AbstractMRTrafficController.XmtNotifier r = new AbstractMRTrafficController.XmtNotifier(m, this.mLastSender, this);
        SwingUtilities.invokeLater(r);
        try {
            this.xbee.sendPacketAsync((XBeePacket)((XBeeMessage)m).getXBeeRequest());
        }
        catch (XBeeException xbe) {
            log.error("Error Sending message to XBee: {}", (Throwable)xbe);
        }
    }

    @Override
    protected AbstractMRMessage pollMessage() {
        if (this.numNodes <= 0) {
            return null;
        }
        XBeeMessage msg = null;
        if (this.getNode(this.curSerialNodeIndex).getSensorsActive()) {
            msg = XBeeMessage.getForceSampleMessage(((XBeeNode)this.getNode(this.curSerialNodeIndex)).getPreferedTransmitAddress());
        }
        this.curSerialNodeIndex = (this.curSerialNodeIndex + 1) % this.numNodes;
        return msg;
    }

    @Override
    protected AbstractMRListener pollReplyHandler() {
        return null;
    }

    @Override
    protected AbstractMRMessage enterProgMode() {
        return null;
    }

    @Override
    protected AbstractMRMessage enterNormalMode() {
        return null;
    }

    @Override
    public void receiveLoop() {
    }

    @Override
    public void registerNode(AbstractNode node) {
        if (!(node instanceof XBeeNode)) {
            throw new IllegalArgumentException("Attempt to register node of incorrect type for this connection");
        }
        super.registerNode(node);
        XBeeNode xbnode = (XBeeNode)node;
        xbnode.setTrafficController(this);
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="synchronized method provides locking")
    public synchronized void deleteNode(XBeeNode node) {
        int index = 0;
        int i = 0;
        while (i < this.numNodes) {
            if (this.nodeArray[i] == node) {
                index = i;
            }
            ++i;
        }
        if (index == this.curSerialNodeIndex) {
            log.warn("Deleting the serial node active in the polling loop");
        }
        --this.numNodes;
        if (index < this.numNodes) {
            int j = index;
            while (j < this.numNodes) {
                this.nodeArray[j] = this.nodeArray[j + 1];
                ++j;
            }
        }
        this.nodeArray[this.numNodes] = null;
        this.getXBee().getNetwork().addRemoteDevice(node.getXBee());
    }

    public void packetReceived(XBeePacket response) {
        log.debug("packetReceived called with {}", (Object)response);
    }

    public void modemStatusEventReceived(ModemStatusEvent modemStatusEvent) {
        log.debug("modemStatusEventReceived called with event {} ", (Object)modemStatusEvent);
    }

    public void dataReceived(com.digi.xbee.api.models.XBeeMessage xbm) {
        log.debug("dataReceived called with message {} ", (Object)xbm);
    }

    @Override
    public IEEE802154Node newNode() {
        return new XBeeNode();
    }

    @Override
    public void addXBeeListener(XBeeListener l) {
        this.addListener(l);
    }

    @Override
    public void removeXBeeListener(XBeeListener l) {
        this.addListener(l);
    }

    @Override
    public void sendXBeeMessage(XBeeMessage m, XBeeListener l) {
        this.sendMessage(m, l);
    }

    @Override
    protected synchronized void sendMessage(AbstractMRMessage m, AbstractMRListener reply) {
        this.msgQueue.addLast(m);
        this.listenerQueue.addLast(reply);
        if (m != null) {
            log.debug("just notified transmit thread with message {}", (Object)m.toString());
        }
    }

    @Override
    protected void forwardMessage(AbstractMRListener client, AbstractMRMessage m) {
        try {
            ((XBeeListener)client).message((XBeeMessage)m);
        }
        catch (ClassCastException classCastException) {
            ((IEEE802154Listener)client).message((IEEE802154Message)m);
        }
    }

    @Override
    protected void forwardReply(AbstractMRListener client, AbstractMRReply r) {
        if (client instanceof XBeeListener) {
            ((XBeeListener)client).reply((XBeeReply)r);
        } else {
            ((IEEE802154Listener)client).reply((IEEE802154Reply)r);
        }
    }

    public synchronized AbstractNode getNodeFromName(String Name2) {
        log.debug("getNodeFromName called with {}", (Object)Name2);
        int i = 0;
        while (i < this.numNodes) {
            XBeeNode node = (XBeeNode)this.getNode(i);
            if (node.getIdentifier().equals(Name2)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public synchronized AbstractNode getNodeFromXBeeDevice(RemoteXBeeDevice device) {
        log.debug("getNodeFromXBeeDevice called with {}", (Object)device);
        int i = 0;
        while (i < this.numNodes) {
            XBeeNode node = (XBeeNode)this.getNode(i);
            RemoteXBeeDevice nodeXBee = node.getXBee();
            if (nodeXBee.get16BitAddress().equals((Object)device.get16BitAddress()) && nodeXBee.get64BitAddress().equals((Object)device.get64BitAddress())) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public XBeeDevice getXBee() {
        return this.xbee;
    }

    @Override
    protected void terminate() {
        if (this.xbee != null) {
            this.xbee.close();
            this.xbee = null;
        }
    }
}

