/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.xbee;

import com.digi.xbee.api.RemoteXBeeDevice;
import com.digi.xbee.api.XBeeNetwork;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.listeners.IDiscoveryListener;
import com.digi.xbee.api.models.DiscoveryOptions;
import java.util.EnumSet;
import java.util.List;
import jmri.jmrix.ieee802154.xbee.XBeeNode;
import jmri.jmrix.ieee802154.xbee.XBeeTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XBeeNodeManager
implements IDiscoveryListener {
    private XBeeTrafficController xtc;
    private XBeeNetwork xbeeNetwork = null;
    private static final Logger log = LoggerFactory.getLogger(XBeeNodeManager.class);

    public XBeeNodeManager(XBeeTrafficController tc) {
        this.xtc = tc;
        this.startNodeDiscovery();
    }

    public void startNodeDiscovery() {
        log.info("Starting XBee Node Discovery Process");
        this.xbeeNetwork = this.xtc.getXBee().getNetwork();
        try {
            log.debug("configuring discovery timeout");
            this.xbeeNetwork.setDiscoveryTimeout(2000L);
            log.debug("setting discovery options");
            this.xbeeNetwork.setDiscoveryOptions(EnumSet.of(DiscoveryOptions.APPEND_DD, DiscoveryOptions.DISCOVER_MYSELF));
        }
        catch (TimeoutException timeoutException) {
            log.debug("timeout during discovery process setup");
        }
        catch (XBeeException xBeeException) {
            log.error("exception during discovery process setup");
        }
        log.debug("adding Listener for discovery results");
        this.xbeeNetwork.addDiscoveryListener((IDiscoveryListener)this);
        this.xbeeNetwork.startDiscoveryProcess();
        log.debug("Discovery Process started");
    }

    public boolean isDiscoveryRunning() {
        if (this.xbeeNetwork == null) {
            return false;
        }
        return this.xbeeNetwork.isDiscoveryRunning();
    }

    public void stopNodeDiscovery() {
        if (this.isDiscoveryRunning()) {
            this.xbeeNetwork.stopDiscoveryProcess();
        }
    }

    public void deviceDiscovered(RemoteXBeeDevice discoveredDevice) {
        log.debug("New Device discovered {}", (Object)discoveredDevice.toString());
    }

    public void discoveryError(String error) {
        log.error("Error during node discovery process: {}", (Object)error);
    }

    public void discoveryFinished(String error) {
        if (error != null) {
            log.error("Node discovery processed finished with error: {}", (Object)error);
        } else {
            log.info("Node discovery process completed successfully with {} devices discovered", (Object)this.xbeeNetwork.getNumberOfDevices());
            List nodeList = this.xbeeNetwork.getDevices();
            for (RemoteXBeeDevice device : nodeList) {
                XBeeNode node = (XBeeNode)this.xtc.getNodeFromXBeeDevice(device);
                if (node != null) continue;
                try {
                    node = new XBeeNode(device);
                    this.xtc.registerNode(node);
                }
                catch (TimeoutException timeoutException) {
                    log.error("Timeout registering device {}", (Object)device);
                }
                catch (XBeeException xBeeException) {
                    log.error("Exception registering device {}", (Object)device);
                }
            }
        }
    }
}

