/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.xbee;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.Light;
import jmri.Manager;
import jmri.NamedBean;
import jmri.jmrix.ieee802154.xbee.Bundle;
import jmri.jmrix.ieee802154.xbee.XBeeConnectionMemo;
import jmri.jmrix.ieee802154.xbee.XBeeLight;
import jmri.jmrix.ieee802154.xbee.XBeeNode;
import jmri.jmrix.ieee802154.xbee.XBeeTrafficController;
import jmri.managers.AbstractLightManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XBeeLightManager
extends AbstractLightManager {
    protected XBeeTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(XBeeLightManager.class);

    public XBeeLightManager(XBeeConnectionMemo memo) {
        super(memo);
        this.tc = (XBeeTrafficController)memo.getTrafficController();
    }

    @Override
    @Nonnull
    public XBeeConnectionMemo getMemo() {
        return (XBeeConnectionMemo)this.memo;
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return false;
    }

    @Override
    @Nonnull
    protected Light createNewLight(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        int pin;
        String name = this.addressFromSystemName(systemName);
        XBeeNode curNode = (XBeeNode)this.tc.getNodeFromName(name);
        if (curNode == null && (curNode = (XBeeNode)this.tc.getNodeFromAddress(name)) == null) {
            try {
                curNode = (XBeeNode)this.tc.getNodeFromAddress(Integer.parseInt(name));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("failed to find node to create Light: " + systemName);
            }
        }
        if (!curNode.getPinAssigned(pin = this.pinFromSystemName(systemName))) {
            log.debug("Adding sensor to pin {}", (Object)pin);
            curNode.setPinBean(pin, new XBeeLight(systemName, userName, this.tc));
            return (XBeeLight)curNode.getPinBean(pin);
        }
        throw new IllegalArgumentException("failed to create Light: " + systemName);
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) {
        super.validateSystemNameFormat(name, locale);
        int pin = this.pinFromSystemName(name);
        if (pin < 0 || pin > 7) {
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "SystemNameInvalidPin", name), Bundle.getMessage(locale, "SystemNameInvalidPin", name));
        }
        return name;
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        if (this.tc.getNodeFromName(this.addressFromSystemName(systemName)) == null && this.tc.getNodeFromAddress(this.addressFromSystemName(systemName)) == null) {
            try {
                if (this.tc.getNodeFromAddress(Integer.parseInt(this.addressFromSystemName(systemName))) == null) {
                    return Manager.NameValidity.INVALID;
                }
                return this.pinFromSystemName(systemName) >= 0 && this.pinFromSystemName(systemName) <= 7 ? Manager.NameValidity.VALID : Manager.NameValidity.INVALID;
            }
            catch (NumberFormatException numberFormatException) {
                log.error("Unable to convert {} into the Xbee node and pin format of nn:xx", (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
        }
        return this.pinFromSystemName(systemName) >= 0 && this.pinFromSystemName(systemName) <= 7 ? Manager.NameValidity.VALID : Manager.NameValidity.INVALID;
    }

    private String addressFromSystemName(@Nonnull String systemName) {
        String encoderAddress;
        if (systemName.contains(":")) {
            int seperator = systemName.indexOf(":");
            encoderAddress = systemName.substring(this.getSystemPrefix().length() + 1, seperator);
        } else {
            encoderAddress = systemName.length() > this.getSystemPrefix().length() + 1 ? systemName.substring(this.getSystemPrefix().length() + 1, systemName.length() - 1) : systemName.substring(this.getSystemPrefix().length() + 1);
        }
        log.debug("Converted {} to hardware address {}", (Object)systemName, (Object)encoderAddress);
        return encoderAddress;
    }

    private int pinFromSystemName(@Nonnull String systemName) {
        int input = 0;
        int iName = 0;
        if (systemName.contains(":")) {
            int seperator = systemName.indexOf(":");
            try {
                input = Integer.parseInt(systemName.substring(seperator + 1));
            }
            catch (NumberFormatException numberFormatException) {
                log.debug("Unable to convert {} into the XBee node and pin format of nn:xx", (Object)systemName);
                return -1;
            }
        }
        try {
            iName = Integer.parseInt(systemName.substring(this.getSystemPrefix().length() + 1));
            input = iName % 10;
        }
        catch (NumberFormatException numberFormatException) {
            log.debug("Unable to convert {} system name to a number", (Object)systemName);
            return -1;
        }
        log.debug("Converted {} to pin number {}", (Object)systemName, (Object)input);
        return input;
    }

    @Override
    public boolean validSystemNameConfig(@Nonnull String systemName) {
        return true;
    }

    @Override
    public void deregister(@Nonnull Light l) {
        super.deregister(l);
        String systemName = l.getSystemName();
        String name = this.addressFromSystemName(systemName);
        int pin = this.pinFromSystemName(systemName);
        XBeeNode curNode = (XBeeNode)this.tc.getNodeFromName(name);
        if (curNode == null && (curNode = (XBeeNode)this.tc.getNodeFromAddress(name)) == null) {
            try {
                curNode = (XBeeNode)this.tc.getNodeFromAddress(Integer.parseInt(name));
            }
            catch (NumberFormatException numberFormatException) {
                curNode = null;
            }
        }
        if (curNode != null) {
            if (curNode.removePinBean(pin, l)) {
                log.debug("Removing sensor from pin {}", (Object)pin);
            } else {
                log.debug("Failed to removing sensor from pin {}", (Object)pin);
            }
        }
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddEntryToolTip");
    }
}

