/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.xbee;

import com.digi.xbee.api.exceptions.InterfaceNotOpenException;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeException;
import com.digi.xbee.api.io.IOLine;
import com.digi.xbee.api.io.IOValue;
import jmri.implementation.AbstractLight;
import jmri.jmrix.ieee802154.IEEE802154SystemConnectionMemo;
import jmri.jmrix.ieee802154.xbee.XBeeConnectionMemo;
import jmri.jmrix.ieee802154.xbee.XBeeNode;
import jmri.jmrix.ieee802154.xbee.XBeeTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XBeeLight
extends AbstractLight {
    private String nodeIdentifier;
    private XBeeNode node = null;
    private int address;
    private int pin;
    private String systemName;
    protected XBeeTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(XBeeLight.class);

    public XBeeLight(String systemName, String userName, XBeeTrafficController controller) {
        super(systemName, userName);
        this.tc = controller;
        this.init(systemName);
    }

    public XBeeLight(String systemName, XBeeTrafficController controller) {
        super(systemName);
        this.tc = controller;
        this.init(systemName);
    }

    private void init(String id) {
        this.systemName = id;
        IEEE802154SystemConnectionMemo m = this.tc.getAdapterMemo();
        if (!(m instanceof XBeeConnectionMemo)) {
            log.error("Memo associated with the traffic controller is not the right type");
            throw new IllegalArgumentException("Memo associated with the traffic controller is not the right type");
        }
        XBeeConnectionMemo memo = (XBeeConnectionMemo)m;
        String prefix = memo.getLightManager().getSystemPrefix();
        if (this.systemName.contains(":")) {
            int seperator = this.systemName.indexOf(":");
            try {
                this.nodeIdentifier = this.systemName.substring(prefix.length() + 1, seperator);
                this.node = (XBeeNode)this.tc.getNodeFromName(this.nodeIdentifier);
                if (this.node == null && (this.node = (XBeeNode)this.tc.getNodeFromAddress(this.nodeIdentifier)) == null) {
                    try {
                        this.node = (XBeeNode)this.tc.getNodeFromAddress(Integer.parseInt(this.nodeIdentifier));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.node = null;
                    }
                }
                this.pin = Integer.parseInt(this.systemName.substring(seperator + 1));
            }
            catch (NumberFormatException numberFormatException) {
                log.debug("Unable to convert {} into the cab and input format of nn:xx", (Object)this.systemName);
            }
        } else {
            try {
                this.nodeIdentifier = this.systemName.substring(prefix.length() + 1, id.length() - 1);
                this.address = Integer.parseInt(this.systemName.substring(prefix.length() + 1));
                this.node = (XBeeNode)this.tc.getNodeFromAddress(this.address / 10);
                this.pin = this.address % 10;
            }
            catch (NumberFormatException numberFormatException) {
                log.debug("Unable to convert {} Hardware Address to a number", (Object)this.systemName);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Created Light {} (NodeIdentifier {} D{})", new Object[]{this.systemName, this.nodeIdentifier, this.pin});
        }
    }

    @Override
    protected void doNewState(int oldState, int newState) {
        try {
            if (newState == 2) {
                this.node.getXBee().setDIOValue(IOLine.getDIO((int)this.pin), IOValue.HIGH);
            } else {
                this.node.getXBee().setDIOValue(IOLine.getDIO((int)this.pin), IOValue.LOW);
            }
        }
        catch (TimeoutException timeoutException) {
            log.error("Timeout setting IO line value for light {} on {}", (Object)this.getUserName(), (Object)this.node.getXBee());
        }
        catch (InterfaceNotOpenException interfaceNotOpenException) {
            log.error("Interface Not Open setting IO line value for light {} on {}", (Object)this.getUserName(), (Object)this.node.getXBee());
        }
        catch (XBeeException xBeeException) {
            log.error("Error setting IO line value for light {} on {}", (Object)this.getUserName(), (Object)this.node.getXBee());
        }
    }
}

