/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.xbee;

import com.digi.xbee.api.RemoteXBeeDevice;
import com.digi.xbee.api.exceptions.TimeoutException;
import com.digi.xbee.api.exceptions.XBeeException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.util.ArrayList;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.ieee802154.xbee.XBeeNode;
import jmri.jmrix.ieee802154.xbee.XBeeTrafficController;
import jmri.util.ImmediatePipedOutputStream;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XBeeIOStream
extends AbstractPortController {
    private DataOutputStream pout = null;
    private DataInputStream pin = null;
    private DataOutputStream outpipe = null;
    private DataInputStream inpipe = null;
    private Thread sourceThread;
    private Thread sinkThread;
    private RemoteXBeeDevice remoteXBee;
    private final XBeeTrafficController xtc;
    private static final Logger log = LoggerFactory.getLogger(XBeeIOStream.class);

    public XBeeIOStream(XBeeNode node, XBeeTrafficController tc) {
        super(tc.getAdapterMemo());
        this.remoteXBee = node.getXBee();
        try {
            ImmediatePipedOutputStream tempPipeI = new ImmediatePipedOutputStream();
            this.pout = new DataOutputStream(tempPipeI);
            this.inpipe = new DataInputStream(new PipedInputStream(tempPipeI));
            ImmediatePipedOutputStream tempPipeO = new ImmediatePipedOutputStream();
            this.outpipe = new DataOutputStream(tempPipeO);
            this.pin = new DataInputStream(new PipedInputStream(tempPipeO));
        }
        catch (IOException e) {
            log.error("init (pipe): Exception: {}", (Object)e.toString());
        }
        this.xtc = tc;
    }

    @Override
    public DataInputStream getInputStream() {
        if (this.pin == null) {
            log.error("getInputStream called before load(), stream not available");
        }
        return this.pin;
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (this.pout == null) {
            log.error("getOutputStream called before load(), stream not available");
        }
        return this.pout;
    }

    @Override
    public void connect() {
    }

    @Override
    public void configure() {
        this.sourceThread = new Thread(new TransmitThread(this.remoteXBee, this.xtc, this.inpipe));
        this.sourceThread.setName("xbee.XBeeIOStream Transmit thread");
        this.sourceThread.start();
        this.sinkThread = new Thread(new ReceiveThread(this.remoteXBee, this.xtc, this.outpipe));
        this.sinkThread.setName("xbee.XBeeIOStream Receive thread");
        this.sinkThread.start();
    }

    @Override
    public boolean status() {
        return this.pout != null && this.pin != null;
    }

    @Override
    public String getCurrentPortName() {
        return "NONE";
    }

    @Override
    public boolean getDisabled() {
        return false;
    }

    @Override
    public void setDisabled(boolean disabled) {
    }

    @Override
    public void dispose() {
        if (this.sourceThread != null) {
            this.sourceThread.interrupt();
            this.sourceThread = null;
        }
        if (this.sinkThread != null) {
            this.sinkThread.interrupt();
            this.sinkThread = null;
        }
        try {
            this.pin.close();
            this.pout.close();
            this.outpipe.close();
            this.inpipe.close();
        }
        catch (IOException iOException) {
            log.debug("IO Exception closing port during dispose call");
        }
        super.dispose();
    }

    @Override
    public void recover() {
    }

    private static class ReceiveThread
    implements Runnable {
        private final RemoteXBeeDevice node;
        private final XBeeTrafficController xtc;
        private final DataOutputStream pipe;

        public ReceiveThread(RemoteXBeeDevice n, XBeeTrafficController tc, DataOutputStream output) {
            this.node = n;
            this.xtc = tc;
            this.pipe = output;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            if (XBeeIOStream.access$0().isDebugEnabled()) {
                XBeeIOStream.access$0().debug("XBee Receive Thread Started");
            }
            while (true) {
                try {
                    block4: while (true) {
                        if ((message = this.xtc.getXBee().readDataFrom(this.node, 100)) == null) {
                            continue;
                        }
                        data = message.getData();
                        XBeeIOStream.access$0().debug("Received {}", (Object)data);
                        i = 0;
                        while (true) {
                            if (i < data.length) ** break;
                            continue block4;
                            this.pipe.write(data[i]);
                            ++i;
                        }
                        break;
                    }
                }
                catch (IOException v0) {
                    XBeeIOStream.access$0().error("IOException writing serial data from XBee to pipe");
                    continue;
                }
                catch (NullPointerException v1) {
                    XBeeIOStream.access$0().error("NullPointerException writing serial data from XBee to pipe");
                    return;
                }
                break;
            }
        }
    }

    private static class TransmitThread
    implements Runnable {
        private RemoteXBeeDevice node = null;
        private XBeeTrafficController xtc = null;
        private DataInputStream pipe = null;

        public TransmitThread(RemoteXBeeDevice n, XBeeTrafficController tc, DataInputStream input) {
            this.node = n;
            this.xtc = tc;
            this.pipe = input;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            log.debug("XBee Transmit Thread Started");
            while (true) {
                ArrayList<Byte> data = new ArrayList<Byte>();
                try {
                    do {
                        log.debug("Attempting byte read");
                        byte b = this.pipe.readByte();
                        log.debug("Read Byte: {}", (Object)b);
                        data.add(data.size(), b);
                    } while (data.size() < 100 && this.pipe.available() > 0);
                }
                catch (IOException iOException) {
                    log.error("IOException reading serial data from pipe before sending to XBee");
                }
                byte[] dataArray = new byte[data.size()];
                int i = 0;
                for (Byte n : data) {
                    dataArray[i++] = n;
                }
                if (log.isDebugEnabled()) {
                    log.debug("XBee Thread received message {}", (Object)StringUtil.hexStringFromBytes(dataArray));
                }
                try {
                    this.xtc.getXBee().sendData(this.node, dataArray);
                    continue;
                }
                catch (TimeoutException timeoutException) {
                    log.error("Timeout sending stream data to node {}.", (Object)this.node);
                    continue;
                }
                catch (XBeeException xBeeException) {
                    log.error("Exception sending stream data to node {}.", (Object)this.node);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    if (Thread.interrupted()) return;
                    continue;
                }
                break;
            }
        }
    }
}

