/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.xbee;

import com.digi.xbee.api.connection.IConnectionInterface;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.TooManyListenersException;
import jmri.jmrix.ieee802154.IEEE802154SystemConnectionMemo;
import jmri.jmrix.ieee802154.serialdriver.SerialDriverAdapter;
import jmri.jmrix.ieee802154.xbee.Bundle;
import jmri.jmrix.ieee802154.xbee.XBeeConnectionMemo;
import jmri.jmrix.ieee802154.xbee.XBeeTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.SerialPortEvent;
import purejavacomm.SerialPortEventListener;
import purejavacomm.UnsupportedCommOperationException;

public class XBeeAdapter
extends SerialDriverAdapter
implements IConnectionInterface,
SerialPortEventListener {
    private boolean iConnectionOpened = false;
    private String[] validSpeeds = new String[]{Bundle.getMessage("Baud1200"), Bundle.getMessage("Baud2400"), Bundle.getMessage("Baud4800"), Bundle.getMessage("Baud9600"), Bundle.getMessage("Baud19200"), Bundle.getMessage("Baud38400"), Bundle.getMessage("Baud57600"), Bundle.getMessage("Baud115200")};
    private int[] validSpeedValues = new int[]{1200, 2400, 4800, 9600, 19200, 38400, 57600, 115200};
    private static final Logger log = LoggerFactory.getLogger(XBeeAdapter.class);

    public XBeeAdapter() {
        super(new XBeeConnectionMemo());
    }

    @Override
    public String openPort(String portName, String appName) {
        try {
            CommPortIdentifier portID = CommPortIdentifier.getPortIdentifier(portName);
            try {
                this.activeSerialPort = (SerialPort)portID.open(appName, 2000);
            }
            catch (PortInUseException p) {
                return this.handlePortBusy(p, portName, log);
            }
            try {
                this.setSerialPort();
            }
            catch (UnsupportedCommOperationException e) {
                log.error("Cannot set serial parameters on port {}: {}", (Object)portName, (Object)e.getMessage());
                return "Cannot set serial parameters on port " + portName + ": " + e.getMessage();
            }
            this.serialStream = this.activeSerialPort.getInputStream();
            this.purgeStream(this.serialStream);
            if (log.isInfoEnabled()) {
                log.info("{} port opened at {} baud with DTR: {} RTS: {} DSR: {} CTS: {}  CD: {}", new Object[]{portName, this.activeSerialPort.getBaudRate(), this.activeSerialPort.isDTR(), this.activeSerialPort.isRTS(), this.activeSerialPort.isDSR(), this.activeSerialPort.isCTS(), this.activeSerialPort.isCD()});
            }
            if (log.isDebugEnabled()) {
                log.debug(" port flow control shows {}", (Object)(this.activeSerialPort.getFlowControlMode() == 2 ? "hardware flow control" : "no flow control"));
                this.setPortEventLogging(this.activeSerialPort);
            }
            this.opened = true;
        }
        catch (NoSuchPortException p) {
            return this.handlePortNotFound(p, portName, log);
        }
        catch (IOException ex) {
            log.error("Unexpected exception while opening port {} ", (Object)portName, (Object)ex);
            return "Unexpected error while opening port " + portName + ": " + ex;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NO_NOTIFY_NOT_NOTIFYALL", "NN_NAKED_NOTIFY"}, justification="The notify call is notifying the receive thread that data is available.  There is only one receive thead, so no reason to call notifyAll.")
    public void serialEvent(SerialPortEvent e) {
        int type = e.getEventType();
        try {
            if (type == 1) {
                if (((FilterInputStream)this.getInputStream()).available() > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("SerialEvent: DATA_AVAILABLE is {}", (Object)e.getNewValue());
                    }
                    XBeeAdapter xBeeAdapter = this;
                    synchronized (xBeeAdapter) {
                        this.notifyAll();
                    }
                } else {
                    log.warn("SerialEvent: DATA_AVAILABLE but no data available.");
                }
                return;
            }
            if (log.isDebugEnabled()) {
                switch (type) {
                    case 1: {
                        log.info("SerialEvent: DATA_AVAILABLE is {}", (Object)e.getNewValue());
                        return;
                    }
                    case 2: {
                        log.info("SerialEvent: OUTPUT_BUFFER_EMPTY is {}", (Object)e.getNewValue());
                        return;
                    }
                    case 3: {
                        log.info("SerialEvent: CTS is {}", (Object)e.getNewValue());
                        return;
                    }
                    case 4: {
                        log.info("SerialEvent: DSR is {}", (Object)e.getNewValue());
                        return;
                    }
                    case 5: {
                        log.info("SerialEvent: RI is {}", (Object)e.getNewValue());
                        return;
                    }
                    case 6: {
                        log.info("SerialEvent: CD is {}", (Object)e.getNewValue());
                        return;
                    }
                    case 7: {
                        log.info("SerialEvent: OE (overrun error) is {}", (Object)e.getNewValue());
                        return;
                    }
                    case 8: {
                        log.info("SerialEvent: PE (parity error) is {}", (Object)e.getNewValue());
                        return;
                    }
                    case 9: {
                        log.info("SerialEvent: FE (framing error) is {}", (Object)e.getNewValue());
                        return;
                    }
                    case 10: {
                        log.info("SerialEvent: BI (break interrupt) is {}", (Object)e.getNewValue());
                        return;
                    }
                }
                log.info("SerialEvent of unknown type: {} value: {}", (Object)type, (Object)e.getNewValue());
                return;
            }
        }
        catch (IOException ex) {
            log.error("RXTX error in serialEvent method", (Throwable)ex);
        }
    }

    @Override
    protected void setSerialPort() throws UnsupportedCommOperationException {
        log.debug("setSerialPort() called.");
        int baud = this.currentBaudNumber(this.mBaudRate);
        this.activeSerialPort.setSerialPortParams(baud, 8, 1, 0);
        int flow = 0;
        this.configureLeadsAndFlowControl(this.activeSerialPort, flow);
        if (log.isDebugEnabled()) {
            this.activeSerialPort.notifyOnFramingError(true);
            this.activeSerialPort.notifyOnBreakInterrupt(true);
            this.activeSerialPort.notifyOnParityError(true);
            this.activeSerialPort.notifyOnOverrunError(true);
        }
        this.activeSerialPort.enableReceiveTimeout(10);
        this.activeSerialPort.notifyOnDataAvailable(true);
        try {
            this.activeSerialPort.addEventListener(this);
        }
        catch (TooManyListenersException e) {
            log.error("Exception adding listener ", (Throwable)e);
        }
    }

    @Override
    public void configure() {
        log.debug("configure() called.");
        XBeeTrafficController tc = new XBeeTrafficController();
        this.getSystemConnectionMemo().setTrafficController(tc);
        tc.setAdapterMemo(this.getSystemConnectionMemo());
        tc.connectPort(this);
        this.getSystemConnectionMemo().configureManagers();
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }

    @Override
    public XBeeConnectionMemo getSystemConnectionMemo() {
        IEEE802154SystemConnectionMemo m = super.getSystemConnectionMemo();
        if (m instanceof XBeeConnectionMemo) {
            return (XBeeConnectionMemo)m;
        }
        throw new IllegalArgumentException("System Connection Memo associated with this connection is not the right type.");
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }

    public void close() {
        this.activeSerialPort.close();
        this.iConnectionOpened = false;
    }

    public int readData(byte[] b) throws IOException {
        log.debug("read data called with {}", (Object)b);
        return this.serialStream.read(b);
    }

    public int readData(byte[] b, int off, int len) throws IOException {
        log.debug("read data called with {} {} {}", new Object[]{b, off, len});
        return this.serialStream.read(b, off, len);
    }

    public void writeData(byte[] b) throws IOException {
        log.debug("write data called with {}", (Object)b);
        ((FilterOutputStream)this.getOutputStream()).write(b);
    }

    public void writeData(byte[] b, int off, int len) throws IOException {
        log.debug("write data called with {} {} {}", new Object[]{b, off, len});
        ((DataOutputStream)this.getOutputStream()).write(b, off, len);
    }

    public boolean isOpen() {
        log.debug("isOpen called");
        return this.iConnectionOpened;
    }

    public void open() {
        log.debug("open called");
        this.iConnectionOpened = true;
    }
}

