/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154.swing.nodeconfig;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import jmri.InstanceManager;
import jmri.jmrix.ieee802154.IEEE802154SystemConnectionMemo;
import jmri.jmrix.ieee802154.swing.nodeconfig.NodeConfigFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeConfigAction
extends AbstractAction {
    private IEEE802154SystemConnectionMemo icm = null;
    private static final Logger log = LoggerFactory.getLogger(NodeConfigAction.class);

    public NodeConfigAction(String s, IEEE802154SystemConnectionMemo cm) {
        super(s);
        if (cm == null) {
            try {
                this.icm = InstanceManager.getList(IEEE802154SystemConnectionMemo.class).get(0);
            }
            catch (IndexOutOfBoundsException | NullPointerException runtimeException) {
                log.debug("No IEEE 802.15.4 System Connection Memo available");
            }
        } else {
            this.icm = cm;
        }
    }

    public NodeConfigAction() {
        this("Configure IEEE802154 Nodes", (IEEE802154SystemConnectionMemo)null);
    }

    public NodeConfigAction(String s) {
        this(s, (IEEE802154SystemConnectionMemo)null);
    }

    public NodeConfigAction(IEEE802154SystemConnectionMemo cm) {
        this("Configure IEEE802154 Nodes", cm);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        NodeConfigFrame f = new NodeConfigFrame(this.icm.getTrafficController());
        try {
            f.initComponents();
        }
        catch (Exception ex) {
            log.error("Exception: {}", (Object)ex.toString());
        }
        f.setLocation(100, 30);
        f.setVisible(true);
    }
}

