/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInputStream;
import java.io.IOException;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRNodeTrafficController;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.AbstractNode;
import jmri.jmrix.ieee802154.IEEE802154Interface;
import jmri.jmrix.ieee802154.IEEE802154Listener;
import jmri.jmrix.ieee802154.IEEE802154Message;
import jmri.jmrix.ieee802154.IEEE802154Node;
import jmri.jmrix.ieee802154.IEEE802154Reply;
import jmri.jmrix.ieee802154.IEEE802154SystemConnectionMemo;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IEEE802154TrafficController
extends AbstractMRNodeTrafficController
implements IEEE802154Interface {
    protected boolean logDebug = log.isDebugEnabled();
    private IEEE802154SystemConnectionMemo memo = null;
    private static final Logger log = LoggerFactory.getLogger(IEEE802154TrafficController.class);

    public IEEE802154TrafficController() {
        this.init(1, 100);
        this.setAllowUnexpectedReply(true);
        this.mWaitBeforePoll = 1000;
    }

    public IEEE802154Message getIEEE802154Message(int length) {
        return null;
    }

    @Override
    public synchronized void addIEEE802154Listener(IEEE802154Listener l) {
        this.addListener(l);
    }

    @Override
    public synchronized void removeIEEE802154Listener(IEEE802154Listener l) {
        this.removeListener(l);
    }

    @Override
    protected int enterProgModeDelayTime() {
        return 1000;
    }

    @Override
    protected void forwardMessage(AbstractMRListener client, AbstractMRMessage m) {
        ((IEEE802154Listener)client).message((IEEE802154Message)m);
    }

    @Override
    protected void forwardReply(AbstractMRListener client, AbstractMRReply r) {
        ((IEEE802154Listener)client).reply((IEEE802154Reply)r);
    }

    @Override
    protected AbstractMRMessage pollMessage() {
        return null;
    }

    @Override
    protected AbstractMRListener pollReplyHandler() {
        return null;
    }

    @Override
    public void sendIEEE802154Message(IEEE802154Message m, IEEE802154Listener reply) {
        this.sendMessage(m, reply);
    }

    @Override
    protected void forwardToPort(AbstractMRMessage m, AbstractMRListener reply) {
        if (this.logDebug) {
            log.debug("forward {}", (Object)m);
        }
        super.forwardToPort(m, reply);
    }

    @Override
    protected AbstractMRMessage enterProgMode() {
        return null;
    }

    @Override
    protected AbstractMRMessage enterNormalMode() {
        return null;
    }

    public void setAdapterMemo(IEEE802154SystemConnectionMemo adaptermemo) {
        this.memo = adaptermemo;
    }

    public IEEE802154SystemConnectionMemo getAdapterMemo() {
        return this.memo;
    }

    @Override
    protected void waitForStartOfReply(DataInputStream istream) throws IOException {
        while (this.readByteProtected(istream) != 126) {
        }
    }

    @Override
    protected boolean endOfMessage(AbstractMRReply msg) {
        return msg.getElement(0) + 2 == msg.getNumDataElements();
    }

    @Override
    protected void addTrailerToOutput(byte[] msg, int offset, AbstractMRMessage m) {
        if (m.getNumDataElements() == 0) {
            return;
        }
        ((IEEE802154Message)m).setParity();
    }

    public abstract IEEE802154Node newNode();

    public synchronized AbstractNode getNodeFromAddress(String addr) {
        log.debug("String getNodeFromAddress called with {}", (Object)addr);
        byte[] ba = StringUtil.bytesFromHexString(addr);
        return this.getNodeFromAddress(ba);
    }

    public synchronized AbstractNode getNodeFromAddress(int[] ia) {
        int i;
        if (this.logDebug) {
            String s = "";
            i = 0;
            while (i < ia.length) {
                s = StringUtil.appendTwoHexFromInt(ia[i], s);
                ++i;
            }
            log.debug("int array getNodeFromAddress called with {}", (Object)s);
        }
        byte[] ba = new byte[ia.length];
        i = 0;
        while (i < ia.length) {
            ba[i] = (byte)(ia[i] & 0xFF);
            ++i;
        }
        return this.getNodeFromAddress(ba);
    }

    public synchronized AbstractNode getNodeFromAddress(byte[] ba) {
        log.debug("byte array getNodeFromAddress called with {}", (Object)StringUtil.hexStringFromBytes(ba));
        int i = 0;
        while (i < this.numNodes) {
            int j;
            byte[] bsa = ((IEEE802154Node)this.getNode(i)).getUserAddress();
            byte[] bga = ((IEEE802154Node)this.getNode(i)).getGlobalAddress();
            if (bsa.length == ba.length) {
                j = 0;
                while (j < bsa.length) {
                    if (bsa[j] != ba[j]) break;
                    ++j;
                }
                if (j == bsa.length) {
                    return this.getNode(i);
                }
            } else if (bga.length == ba.length) {
                j = 0;
                while (j < bga.length) {
                    if (bga[j] != ba[j]) break;
                    ++j;
                }
                if (j == bga.length) {
                    return this.getNode(i);
                }
            }
            ++i;
        }
        return null;
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="synchronized method provides locking")
    public synchronized void deleteNode(String nodeAddress) {
        int index = 0;
        int i = 0;
        while (i < this.numNodes) {
            if (this.nodeArray[i] == this.getNodeFromAddress(nodeAddress)) {
                index = i;
            }
            ++i;
        }
        if (index == this.curSerialNodeIndex) {
            log.warn("Deleting the serial node active in the polling loop");
        }
        --this.numNodes;
        if (index < this.numNodes) {
            int j = index;
            while (j < this.numNodes) {
                this.nodeArray[j] = this.nodeArray[j + 1];
                ++j;
            }
        }
        this.nodeArray[this.numNodes] = null;
    }
}

