/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.jmrix.AbstractMRReply;

public class IEEE802154Reply
extends AbstractMRReply {
    public IEEE802154Reply() {
        this.setBinary(true);
    }

    public IEEE802154Reply(String s) {
        super(s);
        this.setBinary(true);
    }

    public IEEE802154Reply(IEEE802154Reply l) {
        super(l);
        this.setBinary(true);
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="Would take significant rework")
    public byte[] getDestinationAddress() {
        int destinationMode = this.getDestinationAddressMode();
        int offset = 4;
        int length = 0;
        switch (destinationMode) {
            case 0: {
                return null;
            }
            case 1: {
                return null;
            }
            case 16: {
                length += 2;
                break;
            }
            case 17: {
                length += 8;
                break;
            }
            default: {
                return null;
            }
        }
        if (!this.isIntraPanFrame() && destinationMode != 0) {
            offset += 2;
        }
        byte[] address = new byte[length];
        int i = 0;
        while (i < length) {
            address[i] = (byte)(0xFF & this.getElement(i + offset));
            ++i;
        }
        return address;
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="Would take significant rework")
    public byte[] getSourceAddr() {
        int destinationMode = this.getDestinationAddressMode();
        int sourceMode = this.getSourceAddressMode();
        int offset = 4;
        int length = 0;
        switch (destinationMode) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 16: {
                offset += 2;
                break;
            }
            case 17: {
                offset += 8;
                break;
            }
            default: {
                return null;
            }
        }
        switch (sourceMode) {
            case 0: {
                return null;
            }
            case 1: {
                return null;
            }
            case 16: {
                length += 2;
                break;
            }
            case 17: {
                length += 8;
                break;
            }
            default: {
                return null;
            }
        }
        if (!this.isIntraPanFrame() && destinationMode != 0 && sourceMode != 0) {
            offset += 4;
        }
        byte[] address = new byte[length];
        int i = 0;
        while (i < length) {
            address[i] = (byte)(0xFF & this.getElement(i + offset));
            ++i;
        }
        return address;
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="Would take significant rework")
    public byte[] getPayload() {
        int destinationMode = this.getDestinationAddressMode();
        int sourceMode = this.getSourceAddressMode();
        int offset = 4;
        switch (destinationMode) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 16: {
                offset += 2;
                break;
            }
            case 17: {
                offset += 8;
                break;
            }
            default: {
                return null;
            }
        }
        switch (sourceMode) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 16: {
                offset += 2;
                break;
            }
            case 17: {
                offset += 8;
                break;
            }
            default: {
                return null;
            }
        }
        if (!this.isIntraPanFrame() && destinationMode != 0 && sourceMode != 0) {
            offset += 4;
        }
        int length = this.getLength() - (offset + 2);
        byte[] address = new byte[length];
        int i = 0;
        while (i < length) {
            address[i] = (byte)(0xFF & this.getElement(i + offset));
            ++i;
        }
        return address;
    }

    public int getLength() {
        return this.getElement(0);
    }

    public int getFrameControl() {
        return (this.getElement(1) << 8) + this.getElement(2);
    }

    public int getDestinationAddressMode() {
        return (this.getFrameControl() & 0xC00) >> 10;
    }

    public int getSourceAddressMode() {
        return (this.getFrameControl() & 0xC000) >> 14;
    }

    public boolean isIntraPanFrame() {
        return (this.getFrameControl() & 0x20) != 0;
    }

    public byte getSequenceByte() {
        return (byte)this.getElement(3);
    }

    @Override
    protected int skipPrefix(int index) {
        return index;
    }

    public boolean checkParity() {
        int len = this.getNumDataElements();
        int chksum = 0;
        int loop = 0;
        while (loop < len - 1) {
            chksum ^= this.getElement(loop) << 8;
            chksum ^= this.getElement(loop + 1);
            loop += 2;
        }
        return (chksum & 0xFFFF) == (this.getElement(len - 2) << 8) + this.getElement(len - 1);
    }
}

