/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ieee802154;

import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IEEE802154Node
extends AbstractNode {
    protected byte[] panaddress = new byte[2];
    protected byte[] useraddress = new byte[2];
    protected byte[] globaladdress = new byte[8];
    boolean needSend = true;
    private static final Logger log = LoggerFactory.getLogger(IEEE802154Node.class);

    public IEEE802154Node() {
    }

    public IEEE802154Node(byte[] pan, byte[] user, byte[] global) {
        this.panaddress = pan;
        this.useraddress = user;
        this.globaladdress = global;
        this.setNodeAddress((user[0] << 8) + (user[1] & 0xFF));
    }

    @Override
    public void setNodeAddress(int address) {
        if (!this.checkNodeAddress(address)) {
            log.error("illegal node address: {}", (Object)Integer.toString(address));
            this.nodeAddress = 0;
            throw new IllegalArgumentException("Attempt to set address to invalid value: " + address);
        }
        this.nodeAddress = address;
    }

    @Override
    protected boolean checkNodeAddress(int address) {
        return true;
    }

    public void setPANAddress(byte[] addr) {
        int i = 0;
        while (i < this.panaddress.length) {
            this.panaddress[i] = addr[i];
            ++i;
        }
    }

    public byte[] getPANAddress() {
        return this.panaddress;
    }

    public void setUserAddress(byte[] addr) {
        int i = 0;
        while (i < this.useraddress.length) {
            this.useraddress[i] = addr[i];
            ++i;
        }
    }

    public byte[] getUserAddress() {
        return this.useraddress;
    }

    public void setGlobalAddress(byte[] addr) {
        int i = 0;
        while (i < this.globaladdress.length) {
            this.globaladdress[i] = addr[i];
            ++i;
        }
    }

    public byte[] getGlobalAddress() {
        return this.globaladdress;
    }

    @Override
    public abstract AbstractMRMessage createInitPacket();

    @Override
    public abstract AbstractMRMessage createOutPacket();

    @Override
    public abstract boolean getSensorsActive();

    @Override
    public abstract boolean handleTimeout(AbstractMRMessage var1, AbstractMRListener var2);

    @Override
    public abstract void resetTimeout(AbstractMRMessage var1);

    @Override
    public boolean mustSend() {
        return this.needSend;
    }

    @Override
    public void resetMustSend() {
        this.needSend = false;
    }

    @Override
    public void setMustSend() {
        this.needSend = true;
    }
}

