/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.grapevine.simulator;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import javax.annotation.Nonnull;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.grapevine.GrapevineSystemConnectionMemo;
import jmri.jmrix.grapevine.SerialMessage;
import jmri.jmrix.grapevine.SerialPortController;
import jmri.jmrix.grapevine.SerialReply;
import jmri.jmrix.grapevine.SerialTrafficController;
import jmri.jmrix.grapevine.simulator.Bundle;
import jmri.util.ImmediatePipedOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulatorAdapter
extends SerialPortController
implements Runnable {
    private boolean opened = false;
    private Thread sourceThread;
    private boolean outputBufferEmpty = true;
    private boolean checkBuffer = true;
    private int autoInit = 0;
    int signalBankSize = 16;
    int sensorBankSize = 64;
    Timer timer;
    private DataOutputStream pout = null;
    private DataInputStream pin = null;
    private DataOutputStream outpipe = null;
    private DataInputStream inpipe = null;
    private static final Logger log = LoggerFactory.getLogger(SimulatorAdapter.class);

    public SimulatorAdapter() {
        super(new GrapevineSystemConnectionMemo("G", Bundle.getMessage("GrapevineSimulatorName")));
        this.option1Name = "InitPreference";
        this.options.put(this.option1Name, new AbstractPortController.Option(Bundle.getMessage("AutoInitLabel"), new String[]{Bundle.getMessage("ButtonNoInit"), Bundle.getMessage("ButtonAll"), Bundle.getMessage("Button4Each")}));
        this.setManufacturer("Protrak");
    }

    @Override
    public String openPort(String portName, String appName) {
        try {
            ImmediatePipedOutputStream tempPipeI = new ImmediatePipedOutputStream();
            log.debug("tempPipeI created");
            this.pout = new DataOutputStream(tempPipeI);
            this.inpipe = new DataInputStream(new PipedInputStream(tempPipeI));
            ImmediatePipedOutputStream tempPipeO = new ImmediatePipedOutputStream();
            this.outpipe = new DataOutputStream(tempPipeO);
            this.pin = new DataInputStream(new PipedInputStream(tempPipeO));
        }
        catch (IOException e) {
            log.error("init (pipe): Exception: {}", (Object)e.toString());
        }
        this.opened = true;
        return null;
    }

    public synchronized void setOutputBufferEmpty(boolean s) {
        this.outputBufferEmpty = s;
    }

    public boolean okToSend() {
        if (this.checkBuffer) {
            log.debug("Buffer Empty: {}", (Object)this.outputBufferEmpty);
            return this.outputBufferEmpty;
        }
        log.debug("No Flow Control or Buffer Check");
        return true;
    }

    @Override
    public void configure() {
        log.debug("set tc for memo {}", (Object)this.getSystemConnectionMemo().getUserName());
        SerialTrafficController control = new SerialTrafficController(this.getSystemConnectionMemo());
        control.connectPort(this);
        this.getSystemConnectionMemo().setTrafficController(control);
        this.getSystemConnectionMemo().configureManagers();
        if (this.getOptionState(this.option1Name).equals(this.getOptionChoices(this.option1Name)[1])) {
            this.autoInit = 1;
        } else if (this.getOptionState(this.option1Name).equals(this.getOptionChoices(this.option1Name)[2])) {
            this.autoInit = 2;
        }
        this.sourceThread = new Thread(this);
        this.sourceThread.setName("Grapevine Simulator");
        this.sourceThread.setPriority(1);
        this.sourceThread.start();
    }

    @Override
    public void connect() throws IOException {
        log.debug("connect called");
        super.connect();
    }

    @Override
    public DataInputStream getInputStream() {
        if (!this.opened || this.pin == null) {
            log.error("getInputStream called before load(), stream not available");
        }
        log.debug("DataInputStream pin returned");
        return this.pin;
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (!this.opened || this.pout == null) {
            log.error("getOutputStream called before load(), stream not available");
        }
        log.debug("DataOutputStream pout returned");
        return this.pout;
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        log.debug("validBaudRates should not have been invoked");
        return new String[0];
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[0];
    }

    @Override
    public String getCurrentBaudRate() {
        return "";
    }

    @Override
    public String getCurrentPortName() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.info("Grapevine Simulator Started");
        while (true) {
            SerialReply r;
            int i;
            AbstractStringBuilder buf;
            try {
                SimulatorAdapter simulatorAdapter = this;
                synchronized (simulatorAdapter) {
                    this.wait(50L);
                }
            }
            catch (InterruptedException interruptedException) {
                log.debug("interrupted, ending");
                return;
            }
            SerialMessage m = this.readMessage();
            if (log.isDebugEnabled()) {
                buf = new StringBuffer();
                ((StringBuffer)buf).append("Grapevine Simulator Thread received message: ");
                if (m != null) {
                    i = 0;
                    while (i < m.getNumDataElements()) {
                        ((StringBuffer)buf).append(String.valueOf(Integer.toHexString(0xFF & m.getElement(i))) + " ");
                        ++i;
                    }
                } else {
                    ((StringBuffer)buf).append("null message buffer");
                }
                log.trace(((StringBuffer)buf).toString());
            }
            if (m == null || (r = this.generateReply(m)) == null) continue;
            this.writeReply(r);
            if (!log.isDebugEnabled()) continue;
            buf = new StringBuilder();
            ((StringBuilder)buf).append("Grapevine Simulator Thread sent reply: ");
            i = 0;
            while (i < r.getNumDataElements()) {
                ((StringBuilder)buf).append(Integer.toHexString(0xFF & r.getElement(i))).append(" ");
                ++i;
            }
            log.debug(((StringBuilder)buf).toString());
        }
    }

    private SerialMessage readMessage() {
        SerialMessage msg = null;
        try {
            if (this.inpipe != null && this.inpipe.available() > 0) {
                msg = this.loadChars();
            }
        }
        catch (IOException iOException) {}
        this.setOutputBufferEmpty(true);
        return msg;
    }

    private SerialReply generateReply(SerialMessage msg) {
        log.debug("Generate Reply to message from node {} (string = {})", (Object)msg.getAddr(), (Object)msg.toString());
        SerialReply reply = new SerialReply();
        int nodeaddr = msg.getAddr();
        int b1 = msg.getElement(0);
        int b2 = msg.getElement(1);
        int b3 = msg.getElement(2);
        int b4 = msg.getElement(3);
        int bank = (b4 & 0xF0) >> 4;
        log.debug("Message nodeaddress={} b1={} b2={} b3={} b4={}", new Object[]{nodeaddr, b1, b2, b3, b4});
        if (nodeaddr == 0) {
            log.debug("general error: coded as: {}", (Object)(((b4 & 0x70) << 4) - 1));
            return null;
        }
        switch (b2) {
            case 119: {
                log.debug("get software version (poll) message detected");
                reply.setElement(0, nodeaddr | 0x80);
                reply.setElement(1, 9);
                break;
            }
            case 113: {
                log.debug("init node message 1 detected - ASD sensors");
                if (this.autoInit > 0) {
                    log.debug("start init 1 of node {}", (Object)nodeaddr);
                    this.nodeResponse(nodeaddr, 1, 1, this.autoInit);
                }
                reply = null;
                break;
            }
            case 115: {
                log.debug("init node message 2 detected - parallel sensors");
                if (this.autoInit > 0) {
                    log.debug("start init 2 of node {}", (Object)nodeaddr);
                    this.nodeResponse(nodeaddr, 5, 5, this.autoInit);
                }
                reply = null;
                break;
            }
            default: {
                if (bank == 6) {
                    JOptionPane.showMessageDialog(null, Bundle.getMessage("RenumberSupport"), Bundle.getMessage("MessageTitle"), 0);
                    log.debug("rename command not supported, old address: {}, new address: {}, bank: {}", new Object[]{nodeaddr, b2, bank});
                    break;
                }
                log.debug("echo normal command, node {} bank {} ignored", (Object)nodeaddr, (Object)bank);
                reply = null;
            }
        }
        log.debug(reply == null ? "Message ignored" : "Reply generated " + reply.toString());
        return reply;
    }

    private void writeReply(@Nonnull SerialReply r) {
        int i = 0;
        while (i < r.getNumDataElements()) {
            try {
                this.outpipe.writeByte((byte)r.getElement(i));
            }
            catch (IOException iOException) {}
            ++i;
        }
        try {
            this.outpipe.flush();
        }
        catch (IOException iOException) {}
    }

    private SerialMessage loadChars() throws IOException {
        byte[] rcvBuffer = new byte[32];
        int nchars = this.inpipe.read(rcvBuffer, 0, 32);
        SerialMessage msg = new SerialMessage(nchars);
        int i = 0;
        while (i < nchars) {
            msg.setElement(i, rcvBuffer[i] & 0xFF);
            ++i;
        }
        return msg;
    }

    public SerialReply setParity(SerialReply r, int start) {
        int sum = r.getElement(0 + start) & 0xF;
        sum += (r.getElement(0 + start) & 0x70) >> 4;
        sum += r.getElement(1 + start) * 2 & 0xF;
        sum += (r.getElement(1 + start) * 2 & 0xF0) >> 4;
        int parity = 16 - ((sum += (r.getElement(3 + start) & 0x70) >> 4) & 0xF);
        r.setElement(3 + start, r.getElement(3 + start) & 0xF0 | parity & 0xF);
        return r;
    }

    private void nodeResponse(int node, int startBank, int endBank, int initBits) {
        if (node < 1 || node > 127) {
            log.warn("Invalid Node Address; no response generated");
            return;
        }
        if (initBits > 1) {
            this.signalBankSize = 4;
            this.sensorBankSize = 4;
        }
        int b1 = -1;
        int b2 = -1;
        int b3 = -1;
        int b4 = -1;
        SerialReply nReply = new SerialReply();
        nReply.setElement(0, node | 0x80);
        nReply.setElement(2, node | 0x80);
        int k = startBank;
        while (k <= endBank) {
            int j;
            if (k <= 3) {
                nReply.setElement(3, k << 4);
                log.debug("element 3 set to 0x{} - {}", (Object)(k << 4 & 0x70), (Object)Integer.toBinaryString(k << 4 & 0x70));
                j = 1;
                while (j < this.signalBankSize) {
                    log.debug("Sending signal state of node {}, bank {}, bit {}", new Object[]{node, k, j});
                    nReply.setElement(1, (j << 3 | 6) & 0x7F);
                    nReply = this.setParity(nReply, 0);
                    this.writeReply(nReply);
                    b1 = nReply.getElement(0) & 0x7F;
                    b2 = nReply.getElement(1) & 0x7F;
                    b3 = nReply.getElement(2) & 0x7F;
                    b4 = nReply.getElement(3) & 0xFF;
                    if (b1 != b3) {
                        log.error("Address mismatch on node {} bank {} bit {}", new Object[]{node, k, j});
                    }
                    log.debug("Reply written for node {} bank {} bit {}: b1= {} b2={} b3={} b4={}", new Object[]{node, k, j, b1, b2, b3, b4});
                    log.debug("Reply as hex: {} {} {} {}", new Object[]{Integer.toHexString(b1), Integer.toHexString(b2), Integer.toHexString(b3), Integer.toHexString(b4)});
                    log.debug("Reply as bin: {} - {} - {} - {}", new Object[]{Integer.toBinaryString(b1), Integer.toBinaryString(b2), Integer.toBinaryString(b3), Integer.toBinaryString(b4)});
                    ++j;
                }
            } else {
                nReply.setElement(3, k << 4);
                log.debug("element 3 set to 0x{} - {}", (Object)(k << 4 & 0x70), (Object)Integer.toBinaryString(k << 4 & 0x70));
                j = 1;
                while (j < this.sensorBankSize) {
                    log.debug("Sending sensor state of node {}, bank {}, bit {}", new Object[]{node, k, j});
                    nReply.setElement(1, (j << 1 | 1) & 0x7F);
                    nReply = this.setParity(nReply, 0);
                    this.writeReply(nReply);
                    b1 = nReply.getElement(0) & 0x7F;
                    b2 = nReply.getElement(1) & 0x7F;
                    b3 = nReply.getElement(2) & 0x7F;
                    b4 = nReply.getElement(3) & 0xFF;
                    if (b1 != b3) {
                        log.error("Address mismatch on node {} bank {} bit {}", new Object[]{node, k, j});
                    }
                    log.debug("Reply written for node {} bank {} bit {}: b1= {} b2={} b3={} b4={}", new Object[]{node, k, j, b1, b2, b3, b4});
                    log.debug("Reply as hex: {} {} {} {}", new Object[]{Integer.toHexString(b1), Integer.toHexString(b2), Integer.toHexString(b3), Integer.toHexString(b4)});
                    log.debug("Reply as bin: {} - {} - {} - {}", new Object[]{Integer.toBinaryString(b1), Integer.toBinaryString(b2), Integer.toBinaryString(b3), Integer.toBinaryString(b4)});
                    ++j;
                }
            }
            ++k;
        }
    }
}

