/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.grapevine.serialmon;

import jmri.jmrix.AbstractMonFrame;
import jmri.jmrix.grapevine.GrapevineSystemConnectionMemo;
import jmri.jmrix.grapevine.SerialListener;
import jmri.jmrix.grapevine.SerialMessage;
import jmri.jmrix.grapevine.SerialReply;
import jmri.jmrix.grapevine.serialmon.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialMonFrame
extends AbstractMonFrame
implements SerialListener {
    private GrapevineSystemConnectionMemo memo = null;
    private static final Logger log = LoggerFactory.getLogger(SerialMonFrame.class);

    public SerialMonFrame(GrapevineSystemConnectionMemo _memo) {
        this.memo = _memo;
    }

    @Override
    protected String title() {
        return Bundle.getMessage("MonitorXTitle", "Grapevine");
    }

    @Override
    protected void init() {
        this.memo.getTrafficController().addSerialListener(this);
    }

    @Override
    protected void setHelp() {
        this.addHelpMenu("package.jmri.jmrix.grapevine.serialmon.SerialMonFrame", true);
    }

    @Override
    public void dispose() {
        this.memo.getTrafficController().removeSerialListener(this);
        super.dispose();
    }

    @Override
    public synchronized void message(SerialMessage l) {
        log.debug("Message: {}", (Object)l.toString());
        this.nextLine(String.valueOf(Bundle.getMessage("CommandLabel")) + " " + l.format() + "\n", l.toString());
    }

    @Override
    public synchronized void reply(SerialReply l) {
        log.debug("Reply: {}", (Object)l.toString());
        this.nextLine(String.valueOf(Bundle.getMessage("ReplyLabel")) + " " + l.format() + "\n", l.toString());
    }
}

