/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.grapevine.nodetable;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.Timer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import jmri.jmrix.AbstractNode;
import jmri.jmrix.grapevine.GrapevineSystemConnectionMemo;
import jmri.jmrix.grapevine.SerialListener;
import jmri.jmrix.grapevine.SerialMessage;
import jmri.jmrix.grapevine.SerialReply;
import jmri.jmrix.grapevine.nodeconfig.NodeConfigFrame;
import jmri.jmrix.grapevine.nodetable.Bundle;
import jmri.jmrix.grapevine.nodetable.RenumberFrame;
import jmri.swing.RowSorterUtil;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTablePane
extends JPanel
implements SerialListener {
    private GrapevineSystemConnectionMemo memo = null;
    NodesModel nodesModel = null;
    JLabel status;
    Timer timer;
    boolean[] scanSeen = new boolean[128];
    private static final Logger log = LoggerFactory.getLogger(NodeTablePane.class);

    public NodeTablePane(GrapevineSystemConnectionMemo _memo) {
        this.memo = _memo;
    }

    public void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.nodesModel = new NodesModel();
        JTable nodesTable = new JTable(this.nodesModel);
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        nodesTable.setDefaultRenderer(JButton.class, buttonRenderer);
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        nodesTable.setDefaultEditor(JButton.class, buttonEditor);
        TableRowSorter<NodesModel> sorter = new TableRowSorter<NodesModel>(this.nodesModel);
        RowSorterUtil.setSortOrder(sorter, 1, SortOrder.DESCENDING);
        nodesTable.setRowSorter(sorter);
        nodesTable.setRowSelectionAllowed(false);
        JButton spacer = new JButton("spacer");
        nodesTable.setRowHeight(spacer.getPreferredSize().height - 4);
        nodesTable.setPreferredScrollableViewportSize(new Dimension(580, 80));
        JScrollPane scrollPane = new JScrollPane(nodesTable);
        this.add(scrollPane);
        JPanel p = new JPanel(){

            @Override
            public Dimension getMaximumSize() {
                int height = this.getPreferredSize().height;
                int width = super.getMaximumSize().width;
                return new Dimension(width, height);
            }
        };
        p.setLayout(new BoxLayout(p, 0));
        JButton b = new JButton(Bundle.getMessage("ButtonCheck"));
        b.setToolTipText(Bundle.getMessage("TipCheck"));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NodeTablePane.this.startPoll();
            }
        });
        p.add(b);
        p.add(new JLabel("   "));
        this.status = new JLabel("");
        this.status.setFont(this.status.getFont().deriveFont(0.9f * (float)b.getFont().getSize()));
        this.status.setForeground(Color.gray);
        p.add(this.status);
        p.add(Box.createHorizontalGlue());
        b = new JButton(Bundle.getMessage("ButtonRenumber"));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NodeTablePane.this.renumber();
            }
        });
        p.add(b);
        this.add(p);
        this.startPoll();
    }

    void renumber() {
        RenumberFrame f = new RenumberFrame(this.memo);
        f.initComponents();
        f.setVisible(true);
    }

    public void startPoll() {
        int i = 0;
        while (i < 128) {
            this.scanSeen[i] = false;
            ++i;
        }
        this.status.setText(Bundle.getMessage("StatusStart"));
        this.timer = new Timer(50, new ActionListener(){
            int node = 1;

            @Override
            public void actionPerformed(ActionEvent e) {
                log.debug("polling node {}", (Object)this.node);
                NodeTablePane.this.status.setText(Bundle.getMessage("StatusRunningX", this.node, 127));
                NodeTablePane.this.memo.getTrafficController().sendSerialMessage(SerialMessage.getPoll(this.node), null);
                ++this.node;
                if (this.node >= 128) {
                    NodeTablePane.this.timer.stop();
                    NodeTablePane.this.timer = null;
                    if (NodeTablePane.this.status.getText().equals(Bundle.getMessage("StatusStart"))) {
                        NodeTablePane.this.status.setText(Bundle.getMessage("StatusFail"));
                    } else {
                        NodeTablePane.this.status.setText(Bundle.getMessage("StatusOK"));
                    }
                }
            }
        });
        this.timer.setInitialDelay(50);
        this.timer.setRepeats(true);
        this.timer.start();
        this.nodesModel.fireTableDataChanged();
    }

    @Override
    public void message(SerialMessage m) {
    }

    @Override
    public void reply(SerialReply m) {
        if (this.status.getText().equals(Bundle.getMessage("StatusStart"))) {
            this.status.setText(Bundle.getMessage("StatusRunning"));
        }
        if (m.getNumDataElements() != 2) {
            return;
        }
        if ((m.getElement(1) & 0xFF) == 119) {
            return;
        }
        int num = m.getElement(0) & 0x7F;
        this.scanSeen[num] = true;
        this.nodesModel.fireTableRowsUpdated(num - 1, num - 1);
    }

    public class NodesModel
    extends AbstractTableModel {
        private static final int ADDRCOL = 0;
        private static final int STATUSCOL = 1;
        private static final int EDITCOL = 2;
        private static final int INITCOL = 3;
        private static final int LAST = 3;

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return 127;
        }

        @Override
        public String getColumnName(int c) {
            switch (c) {
                case 0: {
                    return Bundle.getMessage("TitleAddress");
                }
                case 1: {
                    return Bundle.getMessage("TitleStatus");
                }
                case 2: {
                    return "";
                }
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int c) {
            if (c == 2 || c == 3) {
                return JButton.class;
            }
            if (c == 0) {
                return Integer.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return c == 2 || c == 3;
        }

        @Override
        public Object getValueAt(int r, int c) {
            switch (c) {
                case 0: {
                    return r + 1;
                }
                case 1: {
                    if (NodeTablePane.this.memo.getTrafficController().getNodeFromAddress(r + 1) != null) {
                        return Bundle.getMessage("StatusConfig");
                    }
                    if (NodeTablePane.this.scanSeen[r + 1]) {
                        return Bundle.getMessage("StatusPresent");
                    }
                    return Bundle.getMessage("StatusAbsent");
                }
                case 2: {
                    if (NodeTablePane.this.memo.getTrafficController().getNodeFromAddress(r + 1) != null) {
                        return Bundle.getMessage("ButtonEdit");
                    }
                    return Bundle.getMessage("ButtonAdd");
                }
                case 3: {
                    if (NodeTablePane.this.memo.getTrafficController().getNodeFromAddress(r + 1) != null) {
                        return Bundle.getMessage("ButtonInit");
                    }
                    return null;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
            switch (c) {
                case 2: {
                    NodeConfigFrame f = new NodeConfigFrame(NodeTablePane.this.memo);
                    f.initComponents();
                    f.setNodeAddress(r + 1);
                    f.setVisible(true);
                    return;
                }
                case 3: {
                    AbstractNode t = NodeTablePane.this.memo.getTrafficController().getNodeFromAddress(r + 1);
                    NodeTablePane.this.memo.getTrafficController().sendSerialMessage((SerialMessage)t.createInitPacket(), null);
                    return;
                }
            }
        }
    }
}

