/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.grapevine.nodeconfig;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import jmri.jmrix.grapevine.GrapevineSystemConnectionMemo;
import jmri.jmrix.grapevine.SerialMessage;
import jmri.jmrix.grapevine.SerialNode;
import jmri.jmrix.grapevine.SerialSensorManager;
import jmri.jmrix.grapevine.nodeconfig.Bundle;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeConfigFrame
extends JmriJFrame {
    private GrapevineSystemConnectionMemo memo = null;
    protected JSpinner nodeAddrSpinner;
    protected JLabel nodeAddrStatic = new JLabel("000");
    protected JComboBox<String> nodeTypeBox;
    protected JButton addButton = new JButton(Bundle.getMessage("ButtonAdd"));
    protected JButton editButton = new JButton(Bundle.getMessage("ButtonEdit"));
    protected JButton deleteButton = new JButton(Bundle.getMessage("ButtonDelete"));
    protected JButton initButton = new JButton(Bundle.getMessage("ButtonInit"));
    protected JButton doneButton = new JButton(Bundle.getMessage("ButtonDone"));
    protected JButton updateButton = new JButton(Bundle.getMessage("ButtonUpdate"));
    protected JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
    protected JLabel statusText1 = new JLabel();
    protected JLabel statusText2 = new JLabel();
    protected JLabel statusText3 = new JLabel();
    protected boolean changedNode = false;
    protected boolean editMode = false;
    protected SerialNode curNode = null;
    protected int nodeAddress = 0;
    protected int nodeType = 0;
    protected boolean errorInStatus1 = false;
    protected boolean errorInStatus2 = false;
    protected String stdStatus1 = Bundle.getMessage("NotesStd1");
    protected String stdStatus2 = Bundle.getMessage("NotesStd2");
    protected String stdStatus3 = Bundle.getMessage("NotesStd3");
    protected String editStatus1 = Bundle.getMessage("NotesEdit1");
    protected String editStatus2 = Bundle.getMessage("NotesEdit2");
    protected String editStatus3 = Bundle.getMessage("NotesEdit3");
    private static final Logger log = LoggerFactory.getLogger(NodeConfigFrame.class);

    public NodeConfigFrame(GrapevineSystemConnectionMemo _memo) {
        this.memo = _memo;
    }

    @Override
    public void initComponents() {
        this.setTitle(Bundle.getMessage("ConfigNodesTitle"));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 1));
        JPanel panel11 = new JPanel();
        panel11.setLayout(new FlowLayout());
        panel11.add(new JLabel(String.valueOf(Bundle.getMessage("LabelNodeAddress")) + " "));
        this.nodeAddrSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 100, 1));
        panel11.add(this.nodeAddrSpinner);
        this.nodeAddrSpinner.setToolTipText(Bundle.getMessage("TipNodeAddress"));
        panel11.add(this.nodeAddrStatic);
        this.nodeAddrStatic.setVisible(false);
        panel11.add(new JLabel("   " + Bundle.getMessage("LabelNodeType") + " "));
        this.nodeTypeBox = new JComboBox<String>(SerialNode.getBoardNames());
        panel11.add(this.nodeTypeBox);
        this.nodeTypeBox.setToolTipText(Bundle.getMessage("TipNodeType"));
        contentPane.add(panel11);
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 1));
        JPanel panel31 = new JPanel();
        panel31.setLayout(new FlowLayout());
        this.statusText1.setText(this.stdStatus1);
        this.statusText1.setVisible(true);
        panel31.add(this.statusText1);
        JPanel panel32 = new JPanel();
        panel32.setLayout(new FlowLayout());
        this.statusText2.setText(this.stdStatus2);
        this.statusText2.setVisible(true);
        panel32.add(this.statusText2);
        JPanel panel33 = new JPanel();
        panel33.setLayout(new FlowLayout());
        this.statusText3.setText(this.stdStatus3);
        this.statusText3.setVisible(true);
        panel33.add(this.statusText3);
        panel3.add(panel31);
        panel3.add(panel32);
        panel3.add(panel33);
        Border panel3Border = BorderFactory.createEtchedBorder();
        TitledBorder panel3Titled = BorderFactory.createTitledBorder(panel3Border, Bundle.getMessage("BoxLabelNotes"));
        panel3.setBorder(panel3Titled);
        contentPane.add(panel3);
        JPanel panel4 = new JPanel();
        panel4.setLayout(new FlowLayout());
        this.addButton.setText(Bundle.getMessage("ButtonAdd"));
        this.addButton.setVisible(true);
        this.addButton.setToolTipText(Bundle.getMessage("TipAddButton"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeConfigFrame.this.addButtonActionPerformed();
            }
        });
        panel4.add(this.addButton);
        this.editButton.setText(Bundle.getMessage("ButtonEdit"));
        this.editButton.setVisible(true);
        this.editButton.setToolTipText(Bundle.getMessage("TipEditButton"));
        panel4.add(this.editButton);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeConfigFrame.this.editButtonActionPerformed();
            }
        });
        panel4.add(this.deleteButton);
        this.deleteButton.setText(Bundle.getMessage("ButtonDelete"));
        this.deleteButton.setVisible(true);
        this.deleteButton.setToolTipText(Bundle.getMessage("TipDeleteButton"));
        panel4.add(this.deleteButton);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeConfigFrame.this.deleteButtonActionPerformed();
            }
        });
        panel4.add(this.doneButton);
        this.doneButton.setText(Bundle.getMessage("ButtonDone"));
        this.doneButton.setVisible(true);
        this.doneButton.setToolTipText(Bundle.getMessage("TipDoneButton"));
        panel4.add(this.doneButton);
        this.doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeConfigFrame.this.doneButtonActionPerformed();
            }
        });
        panel4.add(this.updateButton);
        this.updateButton.setText(Bundle.getMessage("ButtonUpdate"));
        this.updateButton.setVisible(true);
        this.updateButton.setToolTipText(Bundle.getMessage("TipUpdateButton"));
        panel4.add(this.updateButton);
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeConfigFrame.this.updateButtonActionPerformed();
            }
        });
        this.updateButton.setVisible(false);
        panel4.add(this.initButton);
        this.initButton.setText(Bundle.getMessage("ButtonInit"));
        this.initButton.setVisible(true);
        this.initButton.setToolTipText(Bundle.getMessage("TipInitButton"));
        panel4.add(this.initButton);
        this.initButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeConfigFrame.this.initButtonActionPerformed();
            }
        });
        this.initButton.setVisible(true);
        panel4.add(this.cancelButton);
        this.cancelButton.setText(Bundle.getMessage("ButtonCancel"));
        this.cancelButton.setVisible(true);
        this.cancelButton.setToolTipText(Bundle.getMessage("TipCancelButton"));
        panel4.add(this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeConfigFrame.this.cancelButtonActionPerformed();
            }
        });
        this.cancelButton.setVisible(false);
        contentPane.add(panel4);
        this.addHelpMenu("package.jmri.jmrix.grapevine.nodeconfig.NodeConfigFrame", true);
        this.pack();
    }

    public void setNodeAddress(int node) {
        this.nodeAddrSpinner.setValue(node);
    }

    public void addButtonActionPerformed() {
        int nodeAddress = this.readNodeAddress();
        if (nodeAddress < 0) {
            return;
        }
        this.curNode = (SerialNode)this.memo.getTrafficController().getNodeFromAddress(nodeAddress);
        if (this.curNode != null) {
            this.statusText1.setText(Bundle.getMessage("Error1", Integer.toString(nodeAddress)));
            this.statusText1.setVisible(true);
            this.errorInStatus1 = true;
            this.resetNotes2();
            return;
        }
        this.nodeType = this.nodeTypeBox.getSelectedIndex();
        this.curNode = new SerialNode(nodeAddress, this.nodeType, this.memo.getTrafficController());
        this.setNodeParameters();
        ((SerialSensorManager)this.memo.getSensorManager()).registerSensorsForNode(this.curNode);
        this.resetNotes();
        this.changedNode = true;
        this.statusText1.setText(String.valueOf(Bundle.getMessage("FeedBackAdd")) + " " + Integer.toString(nodeAddress));
        this.errorInStatus1 = true;
    }

    public void editButtonActionPerformed() {
        this.nodeAddress = this.readNodeAddress();
        if (this.nodeAddress < 0) {
            return;
        }
        this.curNode = (SerialNode)this.memo.getTrafficController().getNodeFromAddress(this.nodeAddress);
        if (this.curNode == null) {
            this.statusText1.setText(Bundle.getMessage("Error4"));
            this.statusText1.setVisible(true);
            this.errorInStatus1 = true;
            this.resetNotes2();
            return;
        }
        this.nodeAddrStatic.setText(Integer.toString(this.nodeAddress));
        this.nodeAddrSpinner.setVisible(false);
        this.nodeAddrStatic.setVisible(true);
        this.nodeType = this.curNode.getNodeType();
        this.nodeTypeBox.setSelectedIndex(this.nodeType);
        this.editMode = true;
        this.addButton.setVisible(false);
        this.editButton.setVisible(false);
        this.deleteButton.setVisible(false);
        this.doneButton.setVisible(false);
        this.updateButton.setVisible(true);
        this.cancelButton.setVisible(true);
        this.statusText1.setText(this.editStatus1);
        this.statusText2.setText(this.editStatus2);
        this.statusText3.setText(this.editStatus3);
    }

    public void initButtonActionPerformed() {
        int nodeAddress = this.readNodeAddress();
        log.debug("node read {}", (Object)nodeAddress);
        if (nodeAddress < 0) {
            return;
        }
        this.curNode = (SerialNode)this.memo.getTrafficController().getNodeFromAddress(nodeAddress);
        if (this.curNode == null) {
            this.statusText1.setText(Bundle.getMessage("Error4"));
            this.statusText1.setVisible(true);
            this.errorInStatus1 = true;
            this.resetNotes2();
            return;
        }
        log.debug("init packet sent to node {}", (Object)nodeAddress);
        this.memo.getTrafficController().sendSerialMessage((SerialMessage)this.curNode.createInitPacket(), null);
    }

    public void deleteButtonActionPerformed() {
        int nodeAddress = this.readNodeAddress();
        if (nodeAddress < 0) {
            return;
        }
        this.curNode = (SerialNode)this.memo.getTrafficController().getNodeFromAddress(nodeAddress);
        if (this.curNode == null) {
            this.statusText1.setText(Bundle.getMessage("Error4"));
            this.statusText1.setVisible(true);
            this.errorInStatus1 = true;
            this.resetNotes2();
            return;
        }
        if (JOptionPane.showConfirmDialog(this, String.valueOf(Bundle.getMessage("ConfirmDelete1")) + "\n" + Bundle.getMessage("ConfirmDelete2"), Bundle.getMessage("ConfirmDeleteTitle"), 2, 2) == 0) {
            this.memo.getTrafficController().deleteNode(nodeAddress);
            this.resetNotes();
            this.statusText1.setText(String.valueOf(Bundle.getMessage("FeedBackDelete")) + " " + Integer.toString(nodeAddress));
            this.errorInStatus1 = true;
            this.changedNode = true;
        } else {
            this.resetNotes();
        }
    }

    public void doneButtonActionPerformed() {
        if (this.editMode) {
            this.editMode = false;
            this.curNode = null;
            this.addButton.setVisible(true);
            this.editButton.setVisible(true);
            this.deleteButton.setVisible(true);
            this.doneButton.setVisible(true);
            this.updateButton.setVisible(false);
            this.cancelButton.setVisible(false);
            this.nodeAddrSpinner.setVisible(true);
            this.nodeAddrStatic.setVisible(false);
        }
        if (this.changedNode) {
            JOptionPane.showMessageDialog(this, String.valueOf(Bundle.getMessage("ReminderNode1")) + "\n" + Bundle.getMessage("Reminder2"), Bundle.getMessage("ReminderTitle"), 1);
        }
        this.setVisible(false);
        this.dispose();
    }

    public void updateButtonActionPerformed() {
        this.nodeType = this.nodeTypeBox.getSelectedIndex();
        log.debug("update performed: was {] request {}", (Object)this.curNode.getNodeType(), (Object)this.nodeType);
        if (this.curNode.getNodeType() != this.nodeType) {
            this.curNode.setNodeType(this.nodeType);
        }
        this.setNodeParameters();
        this.changedNode = true;
        this.editMode = false;
        this.curNode = null;
        this.addButton.setVisible(true);
        this.editButton.setVisible(true);
        this.deleteButton.setVisible(true);
        this.doneButton.setVisible(true);
        this.updateButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.nodeAddrSpinner.setVisible(true);
        this.nodeAddrStatic.setVisible(false);
        this.statusText2.setText(this.stdStatus2);
        this.statusText3.setText(this.stdStatus3);
        this.statusText1.setText(String.valueOf(Bundle.getMessage("FeedBackUpdate")) + " " + Integer.toString(this.nodeAddress));
        this.errorInStatus1 = true;
    }

    public void cancelButtonActionPerformed() {
        this.editMode = false;
        this.curNode = null;
        this.addButton.setVisible(true);
        this.editButton.setVisible(true);
        this.deleteButton.setVisible(true);
        this.doneButton.setVisible(true);
        this.updateButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.nodeAddrSpinner.setVisible(true);
        this.nodeAddrStatic.setVisible(false);
        this.statusText1.setText(this.stdStatus1);
        this.statusText2.setText(this.stdStatus2);
        this.statusText3.setText(this.stdStatus3);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.doneButtonActionPerformed();
    }

    void setNodeParameters() {
        this.curNode.setNodeType(this.nodeType);
        this.memo.getTrafficController().initializeSerialNode(this.curNode);
    }

    private void resetNotes() {
        if (this.errorInStatus1) {
            if (this.editMode) {
                this.statusText1.setText(this.editStatus1);
            } else {
                this.statusText1.setText(this.stdStatus1);
            }
            this.errorInStatus1 = false;
        }
        this.resetNotes2();
    }

    private void resetNotes2() {
        if (this.errorInStatus2) {
            if (this.editMode) {
                this.statusText1.setText(this.editStatus2);
            } else {
                this.statusText2.setText(this.stdStatus2);
            }
            this.errorInStatus2 = false;
        }
    }

    private int readNodeAddress() {
        int addr = -1;
        addr = (Integer)this.nodeAddrSpinner.getValue();
        return addr;
    }
}

