/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.grapevine;

import jmri.implementation.DefaultSignalHead;
import jmri.jmrix.grapevine.GrapevineSystemConnectionMemo;
import jmri.jmrix.grapevine.SerialAddress;
import jmri.jmrix.grapevine.SerialMessage;
import jmri.jmrix.grapevine.SerialNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialSignalHead
extends DefaultSignalHead {
    GrapevineSystemConnectionMemo memo = null;
    String tSystemName;
    int output;
    int bank;
    private static final Logger log = LoggerFactory.getLogger(SerialSignalHead.class);

    public SerialSignalHead(String systemName, GrapevineSystemConnectionMemo _memo) {
        super(systemName);
        this.memo = _memo;
        this.tSystemName = systemName;
        int num = SerialAddress.getBitFromSystemName(systemName, this.memo.getSystemPrefix());
        this.output = num % 100 - 1;
        this.bank = num / 100 - 1;
    }

    public SerialSignalHead(String systemName, String userName, GrapevineSystemConnectionMemo _memo) {
        super(systemName, userName);
        this.memo = _memo;
        this.tSystemName = systemName;
        int num = SerialAddress.getBitFromSystemName(systemName, this.memo.getSystemPrefix());
        this.output = num % 100 - 1;
        this.bank = num / 100 - 1;
    }

    @Override
    protected void updateOutput() {
        int cmd;
        SerialNode tNode = SerialAddress.getNodeFromSystemName(this.tSystemName, this.memo.getTrafficController());
        if (tNode == null) {
            log.error("Can't find node for {}, command ignored", (Object)this.tSystemName);
            return;
        }
        boolean high = this.output >= 12;
        int tOut = this.output;
        if (high) {
            tOut = this.output - 12;
        }
        if (this.bank < 0 || this.bank > 4) {
            log.error("invalid bank {} for signal {}", (Object)this.bank, (Object)this.getSystemName());
            this.bank = 0;
        }
        if (this.mLit) {
            switch (this.mAppearance) {
                case 1: {
                    cmd = 6;
                    break;
                }
                case 2: {
                    cmd = 7;
                    break;
                }
                case 4: {
                    cmd = 2;
                    break;
                }
                case 8: {
                    cmd = 3;
                    break;
                }
                case 16: {
                    cmd = 0;
                    break;
                }
                case 32: {
                    cmd = 1;
                    break;
                }
                case 0: {
                    cmd = 4;
                    break;
                }
                default: {
                    log.warn("Unexpected new appearance: {}", (Object)this.mAppearance);
                    cmd = 7;
                    break;
                }
            }
        } else {
            cmd = 4;
        }
        SerialMessage m = new SerialMessage(high ? 8 : 4);
        int i = 0;
        if (high) {
            m.setElement(i++, tNode.getNodeAddress() | 0x80);
            m.setElement(i++, 122);
            m.setElement(i++, tNode.getNodeAddress() | 0x80);
            m.setElement(i++, 16);
            m.setParity(i - 4);
        }
        m.setElement(i++, tNode.getNodeAddress() | 0x80);
        m.setElement(i++, tOut << 3 | cmd);
        m.setElement(i++, tNode.getNodeAddress() | 0x80);
        m.setElement(i++, this.bank << 4);
        m.setParity(i - 4);
        this.memo.getTrafficController().sendSerialMessage(m, null);
    }

    @Override
    public void startFlash() {
    }

    @Override
    public void stopFlash() {
    }
}

