/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.grapevine;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.grapevine.SerialMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialReply
extends AbstractMRReply {
    private static final Logger log = LoggerFactory.getLogger(SerialReply.class);

    public SerialReply() {
        this.setBinary(true);
    }

    public SerialReply(SerialReply l) {
        super(l);
        this.setBinary(true);
    }

    public SerialReply(String s) {
        super(s);
        this.setBinary(true);
    }

    public int getAddr() {
        return this.getElement(0) & 0x7F;
    }

    @Override
    public boolean isUnsolicited() {
        return true;
    }

    @Override
    protected int skipPrefix(int index) {
        return index;
    }

    public int getBank() {
        return (this.getElement(3) & 0x70) >> 4;
    }

    public boolean isError() {
        return (this.getElement(0) & 0x7F) == 0;
    }

    public boolean isFromParallelSensor() {
        if ((this.getElement(3) & 0x70) != 80) {
            return false;
        }
        return (this.getElement(1) & 0x20) == 0;
    }

    public boolean isFromOldSerialSensor() {
        if ((this.getElement(3) & 0x70) != 80) {
            return false;
        }
        return (this.getElement(1) & 0x20) == 32;
    }

    public boolean isFromNewSerialSensor() {
        return (this.getElement(3) & 0x70) == 64;
    }

    public void setNumDataElements(int len) {
        if (len > this._nDataChars) {
            log.error("Can't shorten reply from {} to {}", (Object)this._nDataChars, (Object)len);
            return;
        }
        this._nDataChars = len;
    }

    @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    public String format() {
        int b1 = -1;
        int b2 = -1;
        int b3 = -1;
        int b4 = -1;
        switch (this.getNumDataElements()) {
            case 4: {
                b4 = this.getElement(3) & 0xFF;
            }
            case 3: {
                b3 = this.getElement(2) & 0xFF;
            }
            case 2: {
                b2 = this.getElement(1) & 0xFF;
            }
            case 1: {
                b1 = this.getElement(0) & 0xFF;
                break;
            }
            default: {
                log.warn("Unhandled number of elements: {}", (Object)this.getNumDataElements());
            }
        }
        return SerialMessage.staticFormat(b1, b2, b3, b4);
    }
}

