/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.grapevine;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Sensor;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractNode;
import jmri.jmrix.grapevine.Bundle;
import jmri.jmrix.grapevine.SerialMessage;
import jmri.jmrix.grapevine.SerialReply;
import jmri.jmrix.grapevine.SerialTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialNode
extends AbstractNode {
    static final int MAXSENSORS = 999;
    public static final int NODE2002V6 = 0;
    public static final int NODE2002V1 = 1;
    public static final int NODE2000 = 2;
    private static final String[] boardNames = new String[]{Bundle.getMessage("BoardName1"), Bundle.getMessage("BoardName2"), Bundle.getMessage("BoardName3")};
    static final int[] outputBits = new int[]{424, 424, 424};
    static final int[] inputBits = new int[]{224, 224, 224};
    protected int nodeType = 0;
    protected byte[] outputArray = new byte[500];
    protected boolean[] outputByteChanged = new boolean[500];
    protected boolean hasActiveSensors = false;
    protected int lastUsedSensor = 0;
    protected Sensor[] sensorArray = new Sensor[1000];
    protected int[] sensorLastSetting = new int[1000];
    protected int[] sensorTempSetting = new int[1000];
    private SerialTrafficController tc = null;
    boolean warned = false;
    static final int offsetA = 100;
    static final int offsetM = 200;
    static final int offsetP = 0;
    static final int offsetS = 20;
    int timeout = 0;
    private static final Logger log = LoggerFactory.getLogger(SerialNode.class);

    public static String[] getBoardNames() {
        return (String[])boardNames.clone();
    }

    public SerialNode(SerialTrafficController tc) {
        this(1, tc);
    }

    public SerialNode(int address, SerialTrafficController tc) {
        this(address, 0, tc);
    }

    public SerialNode(int address, int type, SerialTrafficController tc) {
        this.tc = tc;
        this.setNodeAddress(address);
        this.setNodeType(type);
        int i = 0;
        while (i < 1000) {
            this.sensorArray[i] = null;
            this.sensorLastSetting[i] = 1;
            this.sensorTempSetting[i] = 1;
            ++i;
        }
        i = 0;
        while (i < 256) {
            this.outputArray[i] = 0;
            this.outputByteChanged[i] = false;
            ++i;
        }
        this.setMustSend();
        this.hasActiveSensors = false;
        tc.registerNode(this);
        log.debug("new serial node {}", (Object)this);
    }

    public void setOutputBit(int bitNumber, boolean state) {
        int byteNumber = (bitNumber - 1) / 8;
        if (bitNumber > outputBits[this.nodeType] - 1) {
            this.warn("Output bit out-of-range for defined node: " + bitNumber);
        }
        if (byteNumber >= 256) {
            byteNumber = 255;
        }
        byte bit = (byte)(1 << (bitNumber - 1) % 8);
        byte oldByte = this.outputArray[byteNumber];
        if (state) {
            int n = byteNumber;
            this.outputArray[n] = (byte)(this.outputArray[n] & ~bit);
        } else {
            int n = byteNumber;
            this.outputArray[n] = (byte)(this.outputArray[n] | bit);
        }
        if (oldByte != this.outputArray[byteNumber]) {
            this.setMustSend();
            this.outputByteChanged[byteNumber] = true;
        }
    }

    @Override
    public boolean getSensorsActive() {
        return this.hasActiveSensors;
    }

    @Override
    public void resetMustSend() {
        int i = 0;
        while (i < (outputBits[this.nodeType] + 7) / 8) {
            if (this.outputByteChanged[i]) {
                return;
            }
            ++i;
        }
        super.resetMustSend();
    }

    public int getNodeType() {
        return this.nodeType;
    }

    @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    public void setNodeType(int type) {
        this.nodeType = type;
        switch (this.nodeType) {
            default: {
                log.error("Unexpected nodeType in setNodeType: {}", (Object)this.nodeType);
            }
            case 0: 
            case 1: 
            case 2: 
        }
    }

    @Override
    protected boolean checkNodeAddress(int address) {
        return address >= 1 && address <= 127;
    }

    @Override
    public AbstractMRMessage createInitPacket() {
        Timer timer = new Timer(250, null);
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SerialMessage m2 = new SerialMessage(4);
                int i = 0;
                m2.setElement(i++, SerialNode.this.getNodeAddress() | 0x80);
                m2.setElement(i++, 115);
                m2.setElement(i++, SerialNode.this.getNodeAddress() | 0x80);
                m2.setElement(i++, 0);
                m2.setParity(i - 4);
                log.debug("Node {} initpacket 2 sent to {} trafficController", (Object)SerialNode.this.getNodeAddress(), (Object)SerialNode.this.tc.getSystemConnectionMemo().getSystemPrefix());
                SerialNode.this.tc.sendSerialMessage(m2, null);
            }
        };
        timer.addActionListener(l);
        timer.setRepeats(false);
        timer.setInitialDelay(250);
        timer.start();
        SerialMessage m1 = new SerialMessage(4);
        int i = 0;
        m1.setElement(i++, this.getNodeAddress() | 0x80);
        m1.setElement(i++, 113);
        m1.setElement(i++, this.getNodeAddress() | 0x80);
        m1.setElement(i++, 0);
        m1.setParity(i - 4);
        log.debug("Node {} initpacket 1 ready to send to {} trafficController", (Object)this.getNodeAddress(), (Object)this.tc.getSystemConnectionMemo().getSystemPrefix());
        return m1;
    }

    @Override
    public AbstractMRMessage createOutPacket() {
        if (log.isDebugEnabled()) {
            log.debug("createOutPacket for nodeType {} with {} {};{} {};{} {};{} {};", new Object[]{this.nodeType, this.outputByteChanged[0], this.outputArray[0], this.outputByteChanged[1], this.outputArray[1], this.outputByteChanged[2], this.outputArray[2], this.outputByteChanged[3], this.outputArray[3]});
        }
        SerialMessage m = new SerialMessage();
        m.setElement(0, this.getNodeAddress());
        m.setElement(1, 17);
        int i = 0;
        while (i < (outputBits[this.nodeType] + 7) / 8) {
            if (this.outputByteChanged[i]) {
                this.outputByteChanged[i] = false;
                m.setElement(2, i);
                m.setElement(3, this.outputArray[i]);
                return m;
            }
            ++i;
        }
        m.setElement(2, 0);
        m.setElement(3, this.outputArray[0]);
        return m;
    }

    void warn(String s) {
        if (this.warned) {
            return;
        }
        this.warned = true;
        log.warn(s);
    }

    public void markChanges(SerialReply l) {
        if (!(l.isFromParallelSensor() || l.isFromNewSerialSensor() || l.isFromOldSerialSensor())) {
            return;
        }
        if (l.isFromNewSerialSensor()) {
            boolean input = (l.getElement(1) & 1) == 0;
            int card = (l.getElement(1) & 0x60) >> 5;
            if (card > 2) {
                log.warn("Did not expect card number {}, message {}", (Object)card, (Object)l.toString());
            }
            boolean motion = (l.getElement(1) & 0x10) != 0;
            int number = ((l.getElement(1) & 0xE) >> 1) + 1;
            int sensor = card * 8 + (motion ? 200 : 100) + number;
            this.markBit(input, sensor);
        } else if (l.isFromOldSerialSensor()) {
            int byte1 = l.getElement(1);
            boolean altPort = (byte1 & 0x40) != 0;
            boolean highNibble = (byte1 & 0x10) != 0;
            boolean b0 = (byte1 & 1) == 0;
            boolean b1 = (byte1 & 2) == 0;
            boolean b2 = (byte1 & 4) == 0;
            boolean b3 = (byte1 & 8) == 0;
            int number = 1 + (highNibble ? 4 : 0) + (altPort ? 8 : 0) + 20;
            this.markBit(b0, number);
            this.markBit(b1, number + 1);
            this.markBit(b2, number + 2);
            this.markBit(b3, number + 3);
        } else {
            int byte1 = l.getElement(1);
            boolean altPort = (byte1 & 0x40) != 0;
            boolean highNibble = (byte1 & 0x10) != 0;
            boolean b0 = (byte1 & 1) == 0;
            boolean b1 = (byte1 & 2) == 0;
            boolean b2 = (byte1 & 4) == 0;
            boolean b3 = (byte1 & 8) == 0;
            int number = 1 + (highNibble ? 4 : 0) + (altPort ? 8 : 0) + 0;
            this.markBit(b0, number);
            this.markBit(b1, number + 1);
            this.markBit(b2, number + 2);
            this.markBit(b3, number + 3);
        }
    }

    void markBit(boolean input, int sensorNum) {
        log.debug("Mark bit {} {} in node {}", new Object[]{sensorNum, input, this.getNodeAddress()});
        if (this.sensorArray[sensorNum] == null) {
            log.debug("Try to create sensor {} on node {} since sensor doesn't exist", (Object)sensorNum, (Object)this.getNodeAddress());
            InstanceManager.sensorManagerInstance().provideSensor(String.valueOf(this.tc.getSystemConnectionMemo().getSystemPrefix()) + "S" + (this.getNodeAddress() * 1000 + sensorNum));
            if (this.sensorArray[sensorNum] == null) {
                log.error("Creating sensor {}S{} failed unexpectedly", (Object)this.tc.getSystemConnectionMemo().getSystemPrefix(), (Object)(this.getNodeAddress() * 1000 + sensorNum));
                log.debug("node should be {}", (Object)this);
                return;
            }
        }
        boolean value = input ^ this.sensorArray[sensorNum].getInverted();
        try {
            if (value) {
                if (this.sensorLastSetting[sensorNum] != 2) {
                    this.sensorLastSetting[sensorNum] = 2;
                    this.sensorArray[sensorNum].setKnownState(2);
                }
            } else if (this.sensorLastSetting[sensorNum] != 4) {
                this.sensorLastSetting[sensorNum] = 4;
                this.sensorArray[sensorNum].setKnownState(4);
            }
        }
        catch (JmriException e) {
            log.error("exception in markChanges: {}", (Throwable)e);
        }
    }

    public void registerSensor(Sensor s, int i) {
        log.debug("Register sensor {} index {}", (Object)s.getSystemName(), (Object)i);
        if (i < 0 || i > inputBits[this.nodeType] || i > 999) {
            log.error("Unexpected sensor ordinal in registerSensor: {}", (Object)Integer.toString(i));
            return;
        }
        this.hasActiveSensors = true;
        if (this.sensorArray[i] == null) {
            this.sensorArray[i] = s;
            if (this.lastUsedSensor < i) {
                this.lastUsedSensor = i;
            }
        } else {
            log.warn("multiple registration of same sensor: {}S{}", new Object[]{this.tc.getSystemConnectionMemo().getSystemPrefix(), this.getNodeAddress() * 1000 + i, new Exception("mult reg " + i + " S:" + s.getSystemName())});
        }
    }

    @Override
    public boolean handleTimeout(AbstractMRMessage m, AbstractMRListener l) {
        ++this.timeout;
        if (m.getElement(1) != 80) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.warn("Timeout to poll for addr = {}: consecutive timeouts: {}", (Object)this.getNodeAddress(), (Object)this.timeout);
        }
        if (this.timeout > 5) {
            this.timeout = 0;
            this.setMustSend();
            return true;
        }
        return false;
    }

    @Override
    public void resetTimeout(AbstractMRMessage m) {
        if (this.timeout > 0) {
            log.debug("Reset {} timeout count", (Object)this.timeout);
        }
        this.timeout = 0;
    }
}

