/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.grapevine;

import jmri.jmrix.AbstractMRMessage;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialMessage
extends AbstractMRMessage {
    int replyLen = 4;
    static String[] colors = new String[]{"green", "flashing green", "yellow", "flashing yellow", "off", "flashing off", "red", "flashing red"};
    private static final Logger log = LoggerFactory.getLogger(SerialMessage.class);

    public SerialMessage() {
        super(4);
        this.setBinary(true);
    }

    public SerialMessage(int len) {
        super(len);
        this.setBinary(true);
    }

    public SerialMessage(SerialMessage m) {
        super(m);
        this.setBinary(true);
    }

    public SerialMessage(String m) {
        super(m);
        this.setBinary(true);
    }

    public SerialMessage(byte[] a) {
        super(String.valueOf(a));
        this.setBinary(true);
    }

    @Override
    public boolean replyExpected() {
        return false;
    }

    public int getAddr() {
        return this.getElement(0) & 0x7F;
    }

    public static SerialMessage getPoll(int addr) {
        SerialMessage m = new SerialMessage();
        m.setElement(0, addr | 0x80);
        m.setElement(1, 119);
        m.setElement(2, addr | 0x80);
        m.setElement(3, 119);
        m.setReplyLen(2);
        return m;
    }

    public void setBank(int b) {
        if (b > 7 || b < 0) {
            log.error("Setting back to bad value: {}", (Object)b);
        }
        int old = this.getElement(3) & 0xF;
        this.setElement(3, old | (b & 7) << 4);
    }

    public void setParity() {
        this.setParity(0);
    }

    public void setParity(int start) {
        if (this.getElement(1 + start) == 119 && this.getElement(3 + start) == 119) {
            return;
        }
        if ((this.getElement(0 + start) & 0x7F) == 0) {
            this.setElement(3, this.getElement(3 + start) & 0xF0);
            return;
        }
        int sum = this.getElement(0 + start) & 0xF;
        sum += (this.getElement(0 + start) & 0x70) >> 4;
        sum += this.getElement(1 + start) * 2 & 0xF;
        sum += (this.getElement(1 + start) * 2 & 0xF0) >> 4;
        int parity = 16 - ((sum += (this.getElement(3 + start) & 0x70) >> 4) & 0xF);
        this.setElement(3 + start, this.getElement(3 + start) & 0xF0 | parity & 0xF);
    }

    public void setReplyLen(int len) {
        this.replyLen = len;
    }

    public int getReplyLen() {
        return this.replyLen;
    }

    public String format() {
        if (this.getNumDataElements() == 8) {
            String result = "(2-part) ";
            result = String.valueOf(result) + SerialMessage.staticFormat(this.getElement(0) & 0xFF, this.getElement(1) & 0xFF, this.getElement(2) & 0xFF, this.getElement(3) & 0xFF);
            result = String.valueOf(result) + "; ";
            result = String.valueOf(result) + SerialMessage.staticFormat(this.getElement(4) & 0xFF, this.getElement(5) & 0xFF, this.getElement(6) & 0xFF, this.getElement(7) & 0xFF);
            return result;
        }
        return SerialMessage.staticFormat(this.getElement(0) & 0xFF, this.getElement(1) & 0xFF, this.getElement(2) & 0xFF, this.getElement(3) & 0xFF);
    }

    static String staticFormat(int b1, int b2, int b3, int b4) {
        if (b3 < 0) {
            return "Node " + (b1 & 0x7F) + " reports software version " + b2;
        }
        if ((b1 & 0x7F) == 0) {
            String result = "Error report from node " + b2 + ": ";
            switch (((b4 & 0x70) >> 4) - 1) {
                case 0: {
                    result = String.valueOf(result) + "Parity Error";
                    break;
                }
                case 1: {
                    result = String.valueOf(result) + "First Byte Data";
                    break;
                }
                case 2: {
                    result = String.valueOf(result) + "Second Byte Address";
                    break;
                }
                case 3: {
                    result = String.valueOf(result) + "error 3";
                    break;
                }
                case 4: {
                    result = String.valueOf(result) + "Software UART Overflow";
                    break;
                }
                case 5: {
                    result = String.valueOf(result) + "Serial Detector Power Failure";
                    break;
                }
                case 6: {
                    result = String.valueOf(result) + "Printer Busy";
                    break;
                }
                case 7: {
                    result = String.valueOf(result) + "I/O Configuration Not Set";
                    break;
                }
                default: {
                    result = String.valueOf(result) + "error number " + ((b4 & 0x70) >> 4);
                }
            }
            return result;
        }
        String result = "address: " + (b1 & 0x7F) + ", data bytes: 0x" + StringUtil.twoHexFromInt(b2) + " 0x" + StringUtil.twoHexFromInt(b4) + " => ";
        if (b2 == 122 && (b4 & 0x70) == 16) {
            result = String.valueOf(result) + "Shift to high 24 outputs";
            return result;
        }
        if (b2 == b4 && b2 == 119) {
            result = String.valueOf(result) + "software version query";
            return result;
        }
        if (b2 == 112 && (b4 & 0xF0) == 16) {
            result = String.valueOf(result) + "Initialize parallel sensors";
            return result;
        }
        if (b2 == 113 && (b4 & 0xF0) == 0) {
            result = String.valueOf(result) + "Initialize ASD sensors";
            return result;
        }
        if ((b4 & 0xF0) <= 48) {
            result = String.valueOf(result) + "bank " + ((b4 & 0xF0) >> 4) + " signal " + ((b2 & 0x78) >> 3);
            int cmd = b2 & 7;
            result = String.valueOf(result) + " cmd " + cmd;
            result = String.valueOf(result) + " (set " + SerialMessage.colorAsString(cmd);
            if (cmd == 0) {
                result = String.valueOf(result) + "/closed";
            }
            if (cmd == 6) {
                result = String.valueOf(result) + "/thrown";
            }
            result = String.valueOf(result) + ")";
            return result;
        }
        if ((b4 & 0xF0) == 64) {
            result = String.valueOf(result) + "serial sensor bit " + (((b2 & 0x7E) >> 1) + 1) + " is " + ((b2 & 1) == 0 ? "active" : "inactive");
            return result;
        }
        if ((b4 & 0xF0) == 80) {
            if ((b2 & 0x20) == 0) {
                if ((b2 & 0x40) != 0) {
                    result = String.valueOf(result) + "2nd connector ";
                }
                result = String.valueOf(result) + "parallel sensor " + ((b2 & 0x10) != 0 ? "high" : "low") + " nibble:";
            } else {
                result = String.valueOf(result) + "older serial sensor " + ((b2 & 0x10) != 0 ? "high" : "low") + " nibble:";
            }
            result = String.valueOf(result) + ((b2 & 8) == 0 ? " A" : " I");
            result = String.valueOf(result) + ((b2 & 4) == 0 ? " A" : " I");
            result = String.valueOf(result) + ((b2 & 2) == 0 ? " A" : " I");
            result = String.valueOf(result) + ((b2 & 1) == 0 ? " A" : " I");
            return result;
        }
        return String.valueOf(result) + "bank " + ((b4 & 0xF0) >> 4) + ", unknown message";
    }

    static String colorAsString(int color) {
        return colors[color];
    }
}

