/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.grapevine;

import jmri.implementation.AbstractLight;
import jmri.jmrix.grapevine.GrapevineSystemConnectionMemo;
import jmri.jmrix.grapevine.SerialAddress;
import jmri.jmrix.grapevine.SerialMessage;
import jmri.jmrix.grapevine.SerialNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialLight
extends AbstractLight {
    private GrapevineSystemConnectionMemo memo = null;
    int output;
    int bank;
    private static final Logger log = LoggerFactory.getLogger(SerialLight.class);

    public SerialLight(String systemName, GrapevineSystemConnectionMemo _memo) {
        super(systemName);
        this.memo = _memo;
        this.initializeLight(systemName);
    }

    public SerialLight(String systemName, String userName, GrapevineSystemConnectionMemo _memo) {
        super(systemName, userName);
        this.memo = _memo;
        this.initializeLight(systemName);
    }

    private void initializeLight(String systemName) {
        int num = SerialAddress.getBitFromSystemName(systemName, this.memo.getSystemPrefix());
        this.output = num % 100 - 1;
        this.bank = num / 100 - 1;
        this.setState(4);
    }

    @Override
    protected void doNewState(int oldState, int newState) {
        SerialNode mNode = SerialAddress.getNodeFromSystemName(this.getSystemName(), this.memo.getTrafficController());
        if (mNode != null) {
            if (newState == 2) {
                this.sendMessage(true);
            } else if (newState == 4) {
                this.sendMessage(false);
            } else {
                log.warn("illegal state requested for Light: {}", (Object)this.getSystemName());
            }
        }
    }

    protected void sendMessage(boolean on) {
        SerialNode tNode = SerialAddress.getNodeFromSystemName(this.getSystemName(), this.memo.getTrafficController());
        if (tNode == null) {
            log.error("Can't find node for {}, command ignored", (Object)this.getSystemName());
            return;
        }
        boolean high = this.output >= 12;
        int tOut = this.output;
        if (high) {
            tOut = this.output - 12;
        }
        if (this.bank < 0 || this.bank > 4) {
            log.error("invalid bank {}  for Light {}", (Object)this.bank, (Object)this.getSystemName());
            this.bank = 0;
        }
        SerialMessage m = new SerialMessage(high ? 8 : 4);
        int i = 0;
        if (high) {
            m.setElement(i++, tNode.getNodeAddress() | 0x80);
            m.setElement(i++, 122);
            m.setElement(i++, tNode.getNodeAddress() | 0x80);
            m.setElement(i++, 16);
            m.setParity(i - 4);
        }
        m.setElement(i++, tNode.getNodeAddress() | 0x80);
        m.setElement(i++, tOut << 3 | (on ? 0 : 4));
        m.setElement(i++, tNode.getNodeAddress() | 0x80);
        m.setElement(i++, this.bank << 4);
        m.setParity(i - 4);
        this.memo.getTrafficController().sendSerialMessage(m, null);
    }
}

