/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.grapevine;

import java.util.Comparator;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.LightManager;
import jmri.NamedBean;
import jmri.SensorManager;
import jmri.TurnoutManager;
import jmri.jmrix.ConfiguringSystemConnectionMemo;
import jmri.jmrix.DefaultSystemConnectionMemo;
import jmri.jmrix.grapevine.Bundle;
import jmri.jmrix.grapevine.SerialLightManager;
import jmri.jmrix.grapevine.SerialSensorManager;
import jmri.jmrix.grapevine.SerialTrafficController;
import jmri.jmrix.grapevine.SerialTurnoutManager;
import jmri.jmrix.grapevine.swing.GrapevineComponentFactory;
import jmri.jmrix.swing.ComponentFactory;
import jmri.util.NamedBeanComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrapevineSystemConnectionMemo
extends DefaultSystemConnectionMemo
implements ConfiguringSystemConnectionMemo {
    private SerialTrafficController tc = null;
    ComponentFactory cf = null;
    private static final Logger log = LoggerFactory.getLogger(GrapevineSystemConnectionMemo.class);

    public GrapevineSystemConnectionMemo() {
        this("G", Bundle.getMessage("MenuSystem"));
    }

    public GrapevineSystemConnectionMemo(@Nonnull String prefix, @Nonnull String name) {
        super(prefix, name);
        InstanceManager.store(this, GrapevineSystemConnectionMemo.class);
        this.cf = new GrapevineComponentFactory(this);
        InstanceManager.store(this.cf, ComponentFactory.class);
        log.debug("Created GrapevineSystemConnectionMemo, prefix = {}", (Object)prefix);
    }

    public void setTrafficController(SerialTrafficController tc) {
        this.tc = tc;
        log.debug("Memo {} set GrapevineTrafficController {}", (Object)this.getUserName(), (Object)tc);
    }

    public SerialTrafficController getTrafficController() {
        if (this.tc == null) {
            this.setTrafficController(new SerialTrafficController(this));
            log.debug("Auto create of SerialTrafficController for initial configuration");
        }
        return this.tc;
    }

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        return ResourceBundle.getBundle("jmri.jmrix.grapevine.GrapevineActionListBundle");
    }

    @Override
    public <B extends NamedBean> Comparator<B> getNamedBeanComparator(Class<B> type) {
        return new NamedBeanComparator();
    }

    @Override
    public void configureManagers() {
        this.setTurnoutManager(new SerialTurnoutManager(this));
        InstanceManager.setTurnoutManager(this.getTurnoutManager());
        this.setLightManager(new SerialLightManager(this));
        InstanceManager.setLightManager(this.getLightManager());
        this.setSensorManager(new SerialSensorManager(this));
        InstanceManager.setSensorManager(this.getSensorManager());
        this.register();
    }

    public SensorManager getSensorManager() {
        log.debug(this.get(SensorManager.class) != null ? "getSensorManager OK" : "getSensorManager returned NULL");
        return (SensorManager)this.get(SensorManager.class);
    }

    public void setSensorManager(SerialSensorManager s) {
        this.store(s, SensorManager.class);
        this.getTrafficController().setSensorManager(s);
    }

    public TurnoutManager getTurnoutManager() {
        log.debug(this.get(TurnoutManager.class) != null ? "getTurnoutManager OK" : "getTurnoutManager returned NULL");
        return (TurnoutManager)this.get(TurnoutManager.class);
    }

    public void setTurnoutManager(SerialTurnoutManager t) {
        this.store(t, TurnoutManager.class);
    }

    public LightManager getLightManager() {
        log.debug(this.get(LightManager.class) != null ? "getLightManager OK" : "getLightManager returned NULL");
        return (LightManager)this.get(LightManager.class);
    }

    public void setLightManager(SerialLightManager l) {
        this.store(l, LightManager.class);
    }

    @Override
    public void dispose() {
        this.tc = null;
        InstanceManager.deregister(this, GrapevineSystemConnectionMemo.class);
        if (this.cf != null) {
            InstanceManager.deregister(this.cf, ComponentFactory.class);
        }
        super.dispose();
    }
}

